/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.gui.InputField;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldEventMulticaster;
import ch.e2e.gui.event.InputFieldListener;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class InputPasswordField
extends JPasswordField
implements InputField,
DocumentListener {
    private InputFieldListener listener;

    public InputPasswordField() {
        this.getDocument().addDocumentListener(this);
    }

    public InputPasswordField(int columns) {
        super(columns);
        this.getDocument().addDocumentListener(this);
    }

    public InputPasswordField(String text) {
        super(text);
        this.getDocument().addDocumentListener(this);
    }

    @Override
    public Object getContent() {
        return new String(this.getPassword());
    }

    @Override
    public void setContent(Object content) {
        this.setText(content.toString());
    }

    @Override
    public void addInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.addListener(this.listener, listener);
    }

    @Override
    public void removeInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.removeListener(this.listener, listener);
    }

    public void fireInputField() {
        if (this.listener != null) {
            this.listener.inputFieldChanged(new InputFieldEvent(this));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireInputField();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireInputField();
    }
}

