/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.settings.utils;

import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class Converter {
    private static TransformerFactory FACTORY = DomUtilities.getTransformerFactory((ClassLoader)DomUtilities.class.getClassLoader());

    public Document convert(File source) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Document doc = DomUtilities.parse((File)source, (boolean)false, (boolean)false, (boolean)false);
        return this.convert(doc);
    }

    public Document convert(InputStream source) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Document doc = DomUtilities.parse((InputStream)source, (boolean)false, (boolean)false, (boolean)false);
        return this.convert(doc);
    }

    public Document convert(Document source) throws TransformerException {
        Document target = DomUtilities.newDocument();
        this.newTransformer().transform(new DOMSource(source), new DOMResult(target));
        return target;
    }

    protected Transformer newTransformer() throws TransformerConfigurationException {
        return FACTORY.newTransformer(this.getXsltDocument());
    }

    private Source getXsltDocument() {
        InputStream xsltResource = this.getClass().getResourceAsStream(this.getXslResourceName());
        return new StreamSource(xsltResource);
    }

    protected abstract String getXslResourceName();
}

