/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration.types.input;

import ch.e2e.ant.gui.configuration.types.input.InputElement;
import ch.e2e.gui.InputField;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.InputTextArea;
import ch.e2e.swing.RegexPasswordField;
import ch.e2e.swing.RegexTextField;
import ch.e2e.swing.document.RegexFieldDocument;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;

public class TextField
extends InputElement
implements InputFieldListener {
    private JTextComponent textComponent;
    private JComponent component;
    private int rows = 1;
    private int columns = -1;
    private int maxRows = -1;
    private int maxColumns = -1;
    private int maxLength = -1;
    private String text;
    private boolean fireEvent = true;
    private boolean password = false;
    private String pattern = ".*";

    @Override
    public String getValue() {
        String value = (String)((InputField)this.textComponent).getContent();
        return value.length() == 0 ? null : value;
    }

    @Override
    public boolean isEnabled() {
        return this.textComponent.isEnabled();
    }

    @Override
    public void requestFocus() {
        this.textComponent.requestFocus();
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setText(String text) {
        this.fireEvent = false;
        this.text = text;
        if (this.textComponent != null) {
            this.textComponent.setText(text);
        }
        this.fireEvent = true;
    }

    public void addText(String text) {
        this.text = text;
        if (this.textComponent != null) {
            this.textComponent.setText(text);
        }
    }

    public void updateText(String text) {
        this.setText(text);
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void updatePattern(String pattern) {
        this.setPattern(pattern);
        if (this.textComponent != null) {
            ((RegexFieldDocument)this.textComponent.getDocument()).setPattern(pattern);
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public void setMaxColumns(int maxColumns) {
        this.maxColumns = maxColumns;
    }

    public int getMaxColumns() {
        return this.maxColumns;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getRows() {
        return this.rows;
    }

    public void setPassword(boolean password) {
        this.password = password;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public JComponent getGuiElement() {
        if (this.textComponent == null) {
            if (this.rows == 1) {
                this.textComponent = this.getOneLineComponent();
                this.component = this.textComponent;
            } else {
                this.textComponent = this.columns == -1 ? new InputTextArea(this.rows, 0) : new InputTextArea(this.rows, this.columns);
                this.component = new JScrollPane(this.textComponent);
                this.setFill("both");
            }
            ((InputField)this.textComponent).addInputFieldListener((InputFieldListener)this);
            this.textComponent.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    String text = TextField.this.textComponent.getText();
                    if (text.length() > 0) {
                        TextField.this.textComponent.setSelectionStart(0);
                        TextField.this.textComponent.setSelectionEnd(text.length());
                    }
                }
            });
        }
        return this.component;
    }

    private JTextComponent getOneLineComponent() {
        JTextComponent textComponent;
        if (this.columns == -1) {
            textComponent = this.password ? this.createPasswordField() : this.createTextField();
            this.setFill("horizontal");
        } else if (this.password) {
            textComponent = new RegexPasswordField(this.pattern, this.columns, this.maxLength);
            ((RegexPasswordField)textComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextField.this.fireAction(e);
                }
            });
        } else {
            textComponent = new RegexTextField(this.pattern, this.columns, this.maxLength);
            ((RegexTextField)textComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextField.this.fireAction(e);
                }
            });
        }
        if (this.text != null) {
            textComponent.setText(this.text);
        }
        return textComponent;
    }

    private JTextComponent createTextField() {
        RegexTextField textComponent = new RegexTextField(this.pattern);
        textComponent.setMaxLength(this.maxLength);
        textComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextField.this.fireAction(e);
            }
        });
        return textComponent;
    }

    private JTextComponent createPasswordField() {
        RegexPasswordField textComponent = new RegexPasswordField(this.pattern);
        textComponent.setMaxLength(this.maxLength);
        textComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextField.this.fireAction(e);
            }
        });
        return textComponent;
    }

    public void inputFieldChanged(InputFieldEvent e) {
        if (this.fireEvent) {
            this.fireInputFieldChanged(this);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textComponent.setEnabled(enabled);
    }
}

