/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant;

import ch.e2e.util.VersionChecker;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.AbstractCvsTask;

public class CvsPackageChangedReport
extends AbstractCvsTask {
    private boolean executing;
    private String property;
    private File statusFile;

    public void execute() throws BuildException {
        if (this.property == null) {
            throw new BuildException("The attribute 'property' must be set.");
        }
        if (this.statusFile == null) {
            throw new BuildException("The attribute 'statusFile' must be set.");
        }
        ArrayList oldFiles = this.createFileList();
        this.executing = true;
        this.setCommand("-Q status");
        this.setQuiet(false);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.setOutputStream(out);
        super.execute();
        this.parseOutput(out.toString());
        this.executing = false;
        ArrayList newFiles = this.createFileList();
        ArrayList changedPackages = this.compare(oldFiles, newFiles);
        String value = this.createPackageString(changedPackages);
        this.getProject().setProperty(this.property, value);
    }

    public void setCommand(String c) throws BuildException {
        if (!this.executing) {
            throw new BuildException("The attribute 'command' is fixed to 'status'");
        }
        super.setCommand(c);
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setStatusFile(File statusFile) {
        this.statusFile = statusFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList createFileList() {
        ArrayList<FileEntry> files = new ArrayList<FileEntry>();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(this.statusFile));
            while ((line = in.readLine()) != null) {
                try {
                    files.add(new FileEntry(line));
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return files;
    }

    private ArrayList compare(ArrayList oldFiles, ArrayList newFiles) {
        int index;
        FileEntry fileEntry;
        int i;
        ArrayList<String> changedPackages = new ArrayList<String>();
        int length = newFiles.size();
        for (i = 0; i < length; ++i) {
            fileEntry = (FileEntry)newFiles.get(i);
            index = oldFiles.indexOf(fileEntry);
            if (index == -1) {
                if (changedPackages.contains(fileEntry.packageName)) continue;
                changedPackages.add(fileEntry.packageName);
                continue;
            }
            FileEntry oldEntry = (FileEntry)oldFiles.get(index);
            if (!VersionChecker.isNewer((String)oldEntry.version, (String)fileEntry.version) || changedPackages.contains(fileEntry.packageName)) continue;
            changedPackages.add(fileEntry.packageName);
        }
        length = oldFiles.size();
        for (i = 0; i < length; ++i) {
            fileEntry = (FileEntry)oldFiles.get(i);
            index = newFiles.indexOf(fileEntry);
            if (index != -1 || changedPackages.contains(fileEntry.packageName)) continue;
            changedPackages.add(fileEntry.packageName);
        }
        return changedPackages;
    }

    private String createPackageString(ArrayList packages) {
        StringBuffer s = new StringBuffer();
        int length = packages.size();
        for (int i = 0; i < length; ++i) {
            s.append((String)packages.get(i) + ' ');
        }
        return s.toString().trim();
    }

    private void parseOutput(String cvsout) {
        if (cvsout.length() > 0) {
            BufferedReader in = new BufferedReader(new StringReader(cvsout));
            PrintWriter out = null;
            if (!this.statusFile.getParentFile().exists()) {
                this.statusFile.getParentFile().mkdirs();
            }
            try {
                String cvsRoot = this.getCvsRootWithoutServer();
                String line = in.readLine().replace('\\', '/');
                int index = line.indexOf(cvsRoot);
                while (index == -1 && line != null) {
                    line = in.readLine();
                    if (line == null) continue;
                    index = line.indexOf(cvsRoot);
                    line = line.replace('\\', '/');
                }
                if (line != null) {
                    String rootDest = this.createDestRoot(cvsRoot, line, index);
                    out = new PrintWriter(new FileWriter(this.statusFile));
                    while (line != null) {
                        line = line.trim().replace('\\', '/');
                        if ((line = this.checkLine(line, rootDest)) != null) {
                            out.println(line);
                        }
                        line = in.readLine();
                    }
                }
            }
            catch (Exception ex) {
                throw new BuildException((Throwable)ex);
            }
            finally {
                try {
                    out.flush();
                }
                catch (Exception exception) {}
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getCvsRootWithoutServer() {
        String cvsRoot = this.getCvsRoot();
        int index = cvsRoot.lastIndexOf(58);
        if (index != -1) {
            cvsRoot = cvsRoot.substring(index + 1);
        }
        return cvsRoot.replace('\\', '/');
    }

    private String createDestRoot(String cvsRoot, String line, int index) {
        String dest;
        String entry;
        String start = line.substring(0, index);
        if (start.endsWith(":")) {
            cvsRoot = start.substring(start.length() - 2) + cvsRoot;
            index -= 2;
        }
        if ((entry = line.substring(index + cvsRoot.length(), line.length() - 2)).startsWith("/")) {
            entry = entry.substring(1);
        }
        if ((dest = this.getDest().getAbsolutePath().replace('\\', '/')).startsWith("/")) {
            dest = dest.substring(1);
        }
        while (!entry.startsWith(dest)) {
            index = dest.indexOf(47);
            dest = dest.substring(index + 1);
        }
        dest = (cvsRoot = cvsRoot.replace('\\', '/')).endsWith("/") ? cvsRoot + dest : cvsRoot + "/" + dest;
        if (!dest.endsWith("/")) {
            dest = dest + "/";
        }
        return dest;
    }

    private String checkLine(String line, String rootDest) {
        int index = line.indexOf(rootDest);
        if (index != -1) {
            String cvsentry = line.substring(index + rootDest.length(), line.length() - 2);
            if (cvsentry.charAt(0) == '/') {
                cvsentry = cvsentry.substring(1);
            }
            int dashIndex = line.indexOf(58);
            String version = line.substring(dashIndex + 1, index).trim();
            return cvsentry + ';' + version;
        }
        return null;
    }

    private class FileEntry {
        private String fullname;
        private String packageName;
        private String version;

        private FileEntry(String cvsentry) {
            int index = cvsentry.indexOf(59);
            this.fullname = cvsentry.substring(0, index);
            String filename = new File(this.fullname).getName();
            this.version = cvsentry.substring(index + 1);
            this.packageName = cvsentry.substring(0, index - filename.length() - 1);
        }

        public boolean equals(Object other) {
            return ((FileEntry)other).fullname.equals(this.fullname);
        }
    }
}

