/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.project.gui;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.io.FileService;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.base.project.event.ProjectFolderChangedEvent;
import ch.e2e.builder.base.project.event.ProjectFolderChangedListener;
import ch.e2e.builder.base.project.event.ProjectFolderChangedMulticaster;
import ch.e2e.builder.base.project.gui.ProjectDialog;
import ch.e2e.builder.base.project.gui.ProjectWizardPanel;
import ch.e2e.builder.base.project.gui.RenameDialog;
import ch.e2e.builder.base.resource.DialogStrings;
import ch.e2e.builder.base.resource.E2EBuilderStrings;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.io.FileUtilities;
import ch.e2e.swing.InputTextField;
import ch.e2e.swing.document.FileTextFieldDocument;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class GeneralProjectSettingsPanel
extends ProjectWizardPanel
implements DialogStrings,
InputFieldListener,
E2EBuilderStrings {
    private ProjectDialog parent;
    private JButton renameButton;
    public static final String projectNameFieldName = GeneralProjectSettingsPanel.class.toString() + ".projectNameField";
    private InputTextField projectNameField;
    public static final String projectFolderFieldName = GeneralProjectSettingsPanel.class.toString() + ".projectFolderField";
    private JTextField projectFolderField;
    private JTextField author;
    private JTextArea description;
    private File projectFolder;
    private String projectName;
    private ProjectFolderChangedListener listener;
    private RenameDialog renameDialog;

    public GeneralProjectSettingsPanel(ProjectDialog parent) {
        this.parent = parent;
        this.createGui();
    }

    public void addProjectFolderChangedListener(ProjectFolderChangedListener listener) {
        this.listener = ProjectFolderChangedMulticaster.addListener(this.listener, listener);
    }

    public void removeProjectFolderChangedListener(ProjectFolderChangedListener listener) {
        this.listener = ProjectFolderChangedMulticaster.removeListener(this.listener, listener);
    }

    public void setNameFieldEditable(boolean editable) {
        this.renameButton.setVisible(!editable);
        this.projectNameField.setEditable(editable);
        if (editable) {
            this.projectNameField.addInputFieldListener((InputFieldListener)this);
            this.projectNameField.setSelectionStart(0);
            this.projectNameField.setSelectionEnd(this.projectNameField.getText().trim().length());
            this.projectNameField.requestFocus();
        } else {
            this.projectNameField.removeInputFieldListener((InputFieldListener)this);
        }
    }

    public void inputFieldChanged(InputFieldEvent event) {
        String newProjectName = this.projectNameField.getText().trim();
        if (newProjectName.length() == 0) {
            this.parent.setOkButtonEnabled(false);
        } else {
            this.parent.setOkButtonEnabled(true);
            if (!this.projectName.equals(newProjectName)) {
                File oldProjectHome = new File(this.projectFolder, this.projectName);
                this.projectName = this.projectNameField.getText().trim();
                File newProjectHome = new File(this.projectFolder, this.projectName);
                this.fireProjectFolderChanged(newProjectHome, oldProjectHome);
            }
        }
    }

    protected File getProjectHome() {
        return new File(this.projectFolderField.getText().trim(), this.projectNameField.getText().trim());
    }

    void fillProject(E2EBuilderProject project) throws PropertyVetoException {
        File projectHome = new File(this.projectFolder, this.projectName);
        project.setProjectHome(projectHome);
        project.setName(this.projectNameField.getText().trim());
        project.setAuthor(this.author.getText());
        project.setDescription(this.description.getText());
    }

    File fillDefaults(File projectFolder) {
        this.projectNameField.setText("NewProject");
        this.projectName = "NewProject";
        this.projectNameField.setSelectionStart(0);
        this.projectNameField.setSelectionEnd("NewProject".length());
        this.author.setText(System.getProperty("user.name"));
        this.projectFolder = projectFolder;
        this.projectFolderField.setText(projectFolder.getAbsolutePath());
        return new File(projectFolder, "NewProject");
    }

    @Override
    protected void fillProjectInfo(E2EBuilderProject project) {
        this.projectName = project.getName();
        this.projectNameField.setText(this.projectName);
        this.author.setText(project.getAuthor());
        File projectHome = project.getProjectHome();
        if (projectHome != null) {
            this.projectFolder = projectHome.getParentFile();
            this.projectFolderField.setText(FileUtilities.getAbsolutePath((File)this.projectFolder));
        }
        this.description.setText(project.getDescription());
    }

    private void fireProjectFolderChanged(String projectPath) {
        File oldProjectHome = new File(this.projectFolder, this.projectName);
        this.projectFolder = new File(projectPath);
        File newProjectHome = new File(this.projectFolder, this.projectName);
        this.fireProjectFolderChanged(newProjectHome, oldProjectHome);
    }

    private void fireProjectFolderChanged(File newPath, File oldPath) {
        if (this.listener != null) {
            ProjectFolderChangedEvent event = new ProjectFolderChangedEvent(this, newPath, oldPath);
            this.listener.projectFolderChanged(event);
        }
    }

    private void createGui() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = this.createGridBagConstraints();
        this.addProjectName(c, this.parent);
        this.addProjectHome(c);
        c.weightx = 1.0;
        this.addAuthor(c);
        this.addLabel("project.description", c);
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        this.description = new JTextArea(4, 50);
        JScrollPane sp = new JScrollPane(this.description, 20, 30);
        this.add((Component)sp, c);
    }

    private void addProjectName(GridBagConstraints c, final ProjectDialog parent) {
        this.addLabel("project.name", c);
        double weightx = c.weightx;
        Insets insets = c.insets;
        JPanel nameFieldPanel = new JPanel(new GridBagLayout());
        this.projectNameField = new InputTextField();
        this.projectNameField.setDocument((Document)new FileTextFieldDocument());
        this.projectNameField.setName(projectNameFieldName);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridwidth = 1;
        c.weightx = 1.0;
        nameFieldPanel.add((Component)this.projectNameField, c);
        this.renameButton = new JButton(this.getTranslation("button.rename"));
        this.renameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralProjectSettingsPanel.this.renameProject(parent);
            }
        });
        c.insets = new Insets(0, 5, 0, 0);
        c.gridwidth = 0;
        c.weightx = 0.0;
        nameFieldPanel.add((Component)this.renameButton, c);
        c.weightx = weightx;
        c.insets = insets;
        this.add((Component)nameFieldPanel, c);
    }

    private void addLabel(String key, GridBagConstraints c) {
        JLabel label = ComponentFactory.createLabel(key, (String)null);
        this.add((Component)label, c);
    }

    private void addProjectHome(GridBagConstraints c) {
        JLabel homeLabel = ComponentFactory.createLabel("project.home", (String)null);
        String title = this.getTranslation("project.home.select.title");
        String subtitle = this.getTranslation("project.home.select.subtitle");
        this.projectFolderField = this.createFolderInput(homeLabel, this, c, new ProjectWizardPanel.BrowseAction(title, subtitle){

            @Override
            public void actionPerformed(ActionEvent event) {
                super.actionPerformed(event);
                GeneralProjectSettingsPanel.this.fireProjectFolderChanged(GeneralProjectSettingsPanel.this.projectFolderField.getText().trim());
            }

            @Override
            public File selectFolder(File startDir, String title, String subtitle) {
                return FileService.selectFolderNoProject(startDir, startDir.getParentFile(), null, title, subtitle);
            }
        }, false);
        this.projectFolderField.setName(projectFolderFieldName);
    }

    private void addAuthor(GridBagConstraints c) {
        this.addLabel("project.author", c);
        this.author = new JTextField();
        this.add((Component)this.author, c);
    }

    private GridBagConstraints createGridBagConstraints() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 0, 5);
        c.anchor = 11;
        return c;
    }

    private void renameProject(ProjectDialog parent) {
        String newName;
        if (this.renameDialog == null) {
            this.renameDialog = new RenameDialog(parent);
        }
        if (!(newName = this.renameDialog.getProjectName(this.projectNameField.getText()).trim()).equals(this.projectName)) {
            File oldProjectHome = new File(this.projectFolder, this.projectName);
            this.projectName = newName;
            this.projectNameField.setText(newName);
            File newProjectHome = new File(this.projectFolder, this.projectName);
            this.fireProjectFolderChanged(newProjectHome, oldProjectHome);
        }
    }
}

