/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.project;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.message.SendMessageEvent;
import ch.e2e.builder.base.project.ComplexProjectValue;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.base.project.ProjectConstants;
import ch.e2e.builder.base.project.ProjectReader;
import ch.e2e.builder.base.project.ProjectSettingObject;
import ch.e2e.builder.base.project.ProjectSettingObjectMap;
import ch.e2e.builder.base.resource.MessageType;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.util.EventObject;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectSerializer
implements ProjectConstants {
    private static ProjectSerializer serializer;

    private ProjectSerializer() {
    }

    public static void serialize(E2EBuilderProject project) {
        if (serializer == null) {
            serializer = new ProjectSerializer();
        }
        serializer.serializeProject(project);
        ProjectReader.setProjectFile((File)project.getProjectFile());
    }

    public static void serializeAs(E2EBuilderProject project) {
        if (serializer == null) {
            serializer = new ProjectSerializer();
        }
        serializer.serializeProject(project);
    }

    private void serializeProject(E2EBuilderProject project) {
        File projectFile = this.checkProjectFile(project);
        Document projectDoc = this.createNewDocument(project, false);
        File projectWorkspaceFile = project.getProjectWorkspaceFile();
        Document projectWorkspaceDoc = this.createNewDocument(project, true);
        try {
            DomUtilities.serialize((File)projectFile, (Document)projectDoc, (boolean)true, (ClassLoader)this.getClass().getClassLoader());
            DomUtilities.serialize((File)projectWorkspaceFile, (Document)projectWorkspaceDoc, (boolean)true, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (Exception ex) {
            String classname = this.getClass().getName();
            E2EBuilder.logger.severe("Caught a " + ex.getClass().getName() + " in " + classname + ".serializeProject");
            E2EBuilder.logger.throwing(classname, "serializeProject", ex);
            EventController.fire((EventObject)new SendMessageEvent((Object)this, ex.getMessage(), null, "fatalerror", "E2EBuilder", MessageType.APPLICATION_ERROR));
        }
    }

    private File checkProjectFile(E2EBuilderProject project) {
        File projectFile = project.getProjectFile();
        if (projectFile == null) {
            projectFile = this.chooseProjectFile(project);
        }
        if (projectFile.exists() && !projectFile.canWrite()) {
            projectFile.delete();
        }
        if (projectFile.getParentFile() != null && !projectFile.getParentFile().exists()) {
            projectFile.getParentFile().mkdirs();
        }
        return projectFile;
    }

    private File chooseProjectFile(E2EBuilderProject project) {
        return new File(project.getName()).getAbsoluteFile();
    }

    private Document createNewDocument(E2EBuilderProject project, Boolean workspace) {
        HashMap settings = project.getSettings();
        Document document = DomUtilities.newDocument((String)"project");
        Element projectElement = document.getDocumentElement();
        this.writeGenericSettings((ProjectSettingObjectMap)settings.get("generic"), projectElement, project, workspace);
        for (Object o : settings.keySet()) {
            String module = (String)o;
            if (module.equals("generic")) continue;
            ProjectSettingObjectMap moduleSettings = (ProjectSettingObjectMap)settings.get(module);
            this.appendSettings(moduleSettings, module, projectElement, project, workspace);
        }
        return document;
    }

    private void writeGenericSettings(ProjectSettingObjectMap moduleSettings, Element projectElement, E2EBuilderProject project, Boolean workspace) {
        Element moduleElement = projectElement.getOwnerDocument().createElement("generic");
        if (moduleSettings != null) {
            for (Object o : moduleSettings.keySet()) {
                ProjectSettingObject settingObject;
                String key = (String)o;
                if (key.equals("home") || (settingObject = moduleSettings.getProjectSettingObject(key)).getWorkspace() != workspace) continue;
                this.appendValue(key, settingObject.getValue(), moduleElement, project);
            }
        }
        projectElement.appendChild(moduleElement);
    }

    private void appendValue(String key, Object value, Element moduleElement, E2EBuilderProject project) {
        if (value.getClass().isArray()) {
            this.appendArray(key, (Object[])value, moduleElement, project);
        } else {
            String type = value instanceof File ? File.class.getName() : value.getClass().getName();
            if (value instanceof ComplexProjectValue) {
                Element valueElement = ((ComplexProjectValue)value).toElement(moduleElement.getOwnerDocument());
                moduleElement.appendChild(valueElement);
            } else {
                moduleElement.appendChild(this.createValue(key, this.createValue(value, project), type, moduleElement.getOwnerDocument()));
            }
        }
    }

    private void appendArray(String key, Object[] objects, Element parent, E2EBuilderProject project) {
        Element arrayElement = parent.getOwnerDocument().createElement(key);
        arrayElement.setAttribute("type", objects.getClass().getName());
        for (Object object : objects) {
            this.appendValue(key, object, arrayElement, project);
        }
        parent.appendChild(arrayElement);
    }

    private void appendSettings(ProjectSettingObjectMap moduleSettings, String module, Element projectElement, E2EBuilderProject project, Boolean workspace) {
        Element moduleElement = projectElement.getOwnerDocument().createElement(module);
        for (Object o : moduleSettings.keySet()) {
            String key = (String)o;
            ProjectSettingObject settingObject = moduleSettings.getProjectSettingObject(key);
            if (settingObject.getWorkspace() != workspace) continue;
            this.appendValue(key, settingObject.getValue(), moduleElement, project);
        }
        projectElement.appendChild(moduleElement);
    }

    private String createValue(Object value, E2EBuilderProject project) {
        if (value instanceof File) {
            try {
                return FileUtilities.getRelativePath((File)((File)value), (File)project.getProjectHome());
            }
            catch (Exception e) {
                E2EBuilder.logger.throwing(this.getClass().getName(), "createValue", e);
            }
        }
        return value.toString();
    }

    private Element createValue(String nodeName, String value, String type, Document document) {
        Element valueElement = document.createElement(nodeName);
        valueElement.setAttribute("type", type);
        if (value.length() > 0) {
            valueElement.appendChild(document.createTextNode(value));
        }
        return valueElement;
    }
}

