/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.testsuite;

import ch.e2e.builder.regtest.model.TestImportTreeNode;
import ch.e2e.builder.regtest.testsuite.ImportTestcaseContainer;
import ch.e2e.builder.regtest.testsuite.TraceTestcase;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.TreePath;

public class TraceTestcaseContainer
extends TestcaseContainer
implements TestImportTreeNode,
ImportTestcaseContainer {
    public static final int OFFSET_SELECTABLE = 3000;
    public static final int OFFSET_NOT_SELECTABLE = 3500;
    private boolean testSuiteSelectionMode;
    private int nameConflictOffset;

    public TraceTestcaseContainer(String name, int type) {
        super(name, type);
    }

    public int getType() {
        return super.getType() + (this.isSelectable() ? 3000 + this.nameConflictOffset : 3500);
    }

    @Override
    public boolean isSelectable() {
        return this.testSuiteSelectionMode && this.hasExecutedTestcases();
    }

    @Override
    public void setTestSuitSelectionMode(boolean testSuiteSelectionMode) {
        this.testSuiteSelectionMode = testSuiteSelectionMode;
        for (TestcaseObject testcaseObject : this.getChildren().values()) {
            if (!(testcaseObject instanceof TestImportTreeNode)) continue;
            ((TestImportTreeNode)testcaseObject).setTestSuitSelectionMode(testSuiteSelectionMode);
        }
    }

    public TestcaseContainer getContainer(String name, boolean create, int type) {
        TraceTestcaseContainer result = (TraceTestcaseContainer)this.getChildren().get(name);
        if (create && result == null) {
            result = new TraceTestcaseContainer(name, type);
            this.add((TestcaseObject)result);
        }
        return result;
    }

    public List<TreePath> getSelectablePaths() {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        if (this.testSuiteSelectionMode) {
            if (this.hasExecutedTestcases()) {
                TreePath path = new TreePath(this);
                result.add(path);
            }
        } else {
            ArrayList<TreePath> selectablePaths = new ArrayList<TreePath>();
            for (TestcaseObject testcaseObject : this.getChildren().values()) {
                selectablePaths.addAll(((TestImportTreeNode)testcaseObject).getSelectablePaths());
            }
            for (TreePath path : selectablePaths) {
                Object[] pathElements = new Object[path.getPath().length + 1];
                pathElements[0] = this;
                System.arraycopy(path.getPath(), 0, pathElements, 1, path.getPath().length);
                result.add(new TreePath(pathElements));
            }
        }
        return result;
    }

    @Override
    public void setExistingNames(Collection<String> existingNames) {
        this.nameConflictOffset = this.isSelectable() && existingNames.contains(this.getName()) ? 150 : 0;
        for (TestcaseObject testcaseObject : this.getChildren().values()) {
            ((TestImportTreeNode)testcaseObject).setExistingNames(existingNames);
        }
    }

    @Override
    public void setExistingPaths(Collection<String> existingPaths, String rootPath) {
        rootPath = rootPath + this.getName() + '/';
        for (TestcaseObject testcaseObject : this.getChildren().values()) {
            ((TestImportTreeNode)testcaseObject).setExistingPaths(existingPaths, rootPath);
        }
    }

    @Override
    public boolean hasNameConflict() {
        return this.nameConflictOffset != 0;
    }

    @Override
    public void checkNames(String rootPath) {
        rootPath = rootPath + this.getName() + '/';
        for (TestcaseObject testcaseObject : this.getChildren().values()) {
            ((TestImportTreeNode)testcaseObject).checkNames(rootPath);
        }
    }

    @Override
    public Collection<TraceTestcase> findNameConflicts() {
        ArrayList<TraceTestcase> result = new ArrayList<TraceTestcase>();
        for (TestcaseObject testcase : this.getChildren().values()) {
            result.addAll(((TestImportTreeNode)testcase).findNameConflicts());
        }
        return result;
    }

    @Override
    public Collection<TestcaseObject> getChildCollection() {
        return this.getChildren().values();
    }
}

