/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.tools;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.gui.Property;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.io.Base64Tools;
import ch.e2e.swing.RegexTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.util.HashMap;
import java.util.List;
import javax.swing.JDialog;

public class AuthorizationPropertyDialog
extends E2EBuilderDialog {
    private static HashMap<Window, AuthorizationPropertyDialog> propertyDialogs = new HashMap();
    private RegexTextField user;
    private RegexTextField password;

    private AuthorizationPropertyDialog(JDialog parent, E2EBuilderModule module) {
        super((Dialog)parent, module.getTranslation("http.header.authorization.property.title"), module.getTranslation("http.header.authorization.property.internaltitle"), module.getTranslation("http.header.authorization.property.subtitle"), 3);
        this.createGui(module);
    }

    private AuthorizationPropertyDialog(Frame parent, E2EBuilderModule module) {
        super(parent, module.getTranslation("http.header.authorization.property.title"), module.getTranslation("http.header.authorization.property.internaltitle"), module.getTranslation("http.header.authorization.property.subtitle"), 3);
        this.createGui(module);
    }

    private static String userNamePasswordBase64(String username, String password) {
        String s = username + ":" + password;
        String encs = Base64Tools.encodeToString((byte[])s.getBytes());
        return "Basic " + encs;
    }

    public static Property edit(List properties, E2EBuilderModule module) {
        Property found;
        Window parent = E2EBuilder.getInstance().getDialogParent();
        AuthorizationPropertyDialog propertyDialog = propertyDialogs.get(parent);
        if (propertyDialog == null) {
            propertyDialog = parent instanceof JDialog ? new AuthorizationPropertyDialog((JDialog)parent, module) : new AuthorizationPropertyDialog((Frame)parent, module);
            propertyDialogs.put(parent, propertyDialog);
        }
        propertyDialog.user.setText("");
        propertyDialog.password.setText("");
        int index = AuthorizationPropertyDialog.findAuthorizationProperty(properties);
        if (index != -1 && (found = (Property)properties.get(index)).getKey().equals("Authorization")) {
            String userAndPassword = found.getValue();
            Property user = AuthorizationPropertyDialog.getUser(userAndPassword);
            propertyDialog.user.setText(user.getKey());
            propertyDialog.password.setText(user.getValue());
        }
        if (propertyDialog.showDialog() == 1) {
            return new Property("Authorization", AuthorizationPropertyDialog.userNamePasswordBase64(propertyDialog.user.getText(), propertyDialog.password.getText()));
        }
        return null;
    }

    private static Property getUser(String userAndPassword) {
        String decodedUserAndPassword;
        int index;
        byte[] decoded;
        Property user = new Property("", "");
        if (userAndPassword.startsWith("Basic ") && (decoded = Base64Tools.decodeToBytes((String)(userAndPassword = userAndPassword.substring("Basic ".length())))) != null && (index = (decodedUserAndPassword = new String(decoded)).indexOf(":")) > -1) {
            user.setKey(decodedUserAndPassword.substring(0, index));
            user.setValue(decodedUserAndPassword.substring(index + 1));
        }
        return user;
    }

    private void createGui(E2EBuilderModule module) {
        this.setLayout(new GridLayout(4, 1));
        this.add(ComponentFactory.createLabel((String)"http.header.authorization.property.label.user", (E2EBuilderModule)module));
        this.user = new RegexTextField(".*");
        this.user.addInputFieldListener(new InputFieldListener(){

            public void inputFieldChanged(InputFieldEvent e) {
                AuthorizationPropertyDialog.this.setOkButtonEnabled(AuthorizationPropertyDialog.this.user.getText().length() > 0);
            }
        });
        this.add((Component)this.user);
        this.add(ComponentFactory.createLabel((String)"http.header.authorization.property.label.password", (E2EBuilderModule)module));
        this.password = new RegexTextField(".*");
        this.add((Component)this.password);
    }

    public static int findAuthorizationProperty(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Property found = (Property)list.get(i);
            if (!found.getKey().equals("Authorization")) continue;
            return i;
        }
        return -1;
    }
}

