/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.trace.gui.testcase.TestcaseTransferable;
import ch.e2e.builder.trace.gui.tree.TestcaseTreeEvent;
import ch.e2e.builder.trace.gui.tree.TestcaseTreeListener;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.AbstractTestcaseFolder;
import ch.e2e.swing.Tree;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class TestcaseTransferHandler
extends TransferHandler {
    private TestcaseTreeListener testcaseListener;

    public TestcaseTransferHandler(TestcaseTreeListener testcaseListener) {
        this.testcaseListener = testcaseListener;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        boolean result = false;
        if (this.canImport(support)) {
            try {
                AbstractSynchronousTestcase testcase = (AbstractSynchronousTestcase)support.getTransferable().getTransferData(TestcaseTransferable.testcaseFlavor);
                if (support.isDrop()) {
                    Object comp = ((JTree.DropLocation)support.getDropLocation()).getPath().getLastPathComponent();
                    AbstractTestcaseFolder folder = (AbstractTestcaseFolder)(comp instanceof AbstractSynchronousTestcase ? ((AbstractSynchronousTestcase)comp).getParent() : comp);
                    this.testcaseListener.copyTestcase(new TestcaseTreeEvent(this, testcase, folder));
                    result = true;
                } else {
                    Tree tree = (Tree)support.getComponent();
                    TreePath path = tree.getSelectionPath();
                    if (path != null) {
                        Object comp = path.getLastPathComponent();
                        if (comp instanceof AbstractSynchronousTestcase) {
                            AbstractTestcaseFolder folder = (AbstractTestcaseFolder)((AbstractSynchronousTestcase)comp).getParent();
                            this.testcaseListener.copyTestcase(new TestcaseTreeEvent(this, testcase, folder));
                        } else if (comp instanceof AbstractTestcaseFolder) {
                            AbstractTestcaseFolder folder = (AbstractTestcaseFolder)comp;
                            this.testcaseListener.copyTestcase(new TestcaseTreeEvent(this, testcase, folder));
                        }
                        result = true;
                    }
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return support.isDataFlavorSupported(TestcaseTransferable.testcaseFlavor) && (!support.isDrop() || this.shouldAcceptDropLocation(support.getDropLocation()));
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        Tree tree = (Tree)c;
        TreePath path = tree.getSelectionPath();
        Object object = path != null && tree.getSelectionCount() == 1 ? path.getLastPathComponent() : null;
        return object instanceof AbstractSynchronousTestcase ? new TestcaseTransferable((AbstractSynchronousTestcase)object) : null;
    }

    private boolean shouldAcceptDropLocation(TransferHandler.DropLocation dropLocation) {
        Object comp = ((JTree.DropLocation)dropLocation).getPath().getLastPathComponent();
        return comp instanceof AbstractSynchronousTestcase || comp instanceof AbstractTestcaseFolder;
    }
}

