/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui;

import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.util.DateTimeUtil;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class DateViewerDialog
extends E2EBuilderDialog {
    private static final Map<String, DateViewerDialog> INSTANCES = new ConcurrentHashMap<String, DateViewerDialog>();
    private static final String DIALOG_TITLE = "date.viewer.title";
    private final JTextField utcItem = new JTextField(20);
    private final JTextField localItem = new JTextField(20);

    public static DateViewerDialog getDialog(E2EBuilderModule module) {
        return INSTANCES.computeIfAbsent(module.getName(), s -> new DateViewerDialog(module));
    }

    public int show(String timestamp) {
        this.setTimestamp(timestamp);
        return this.showDialog();
    }

    private void setTimestamp(String timestamp) {
        this.utcItem.setText(timestamp);
        this.localItem.setText(DateTimeUtil.formatLocalDateTime((String)timestamp));
    }

    private DateViewerDialog(E2EBuilderModule module) {
        super(module.getTranslation(DIALOG_TITLE, "Date Viewer"), null, null, 0);
        this.createGui();
    }

    private void createGui() {
        this.setTitlePanelVisible(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 21;
        this.createLocalItems((GridBagConstraints)constraints.clone());
        this.createUtcItems((GridBagConstraints)constraints.clone());
    }

    private void createLocalItems(GridBagConstraints constraints) {
        constraints.gridy = 0;
        constraints.insets = new Insets(10, 10, 5, 10);
        this.add(new JLabel("Local:"), constraints);
        this.localItem.setEditable(false);
        this.localItem.setBackground(Color.WHITE);
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.insets = new Insets(10, 0, 5, 10);
        this.add(this.localItem, constraints);
    }

    private void createUtcItems(GridBagConstraints constraints) {
        constraints.gridy = 1;
        constraints.insets = new Insets(5, 10, 10, 10);
        this.add(new JLabel("UTC:"), constraints);
        this.utcItem.setEditable(false);
        this.utcItem.setBackground(Color.WHITE);
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.insets = new Insets(5, 0, 10, 10);
        this.add(this.utcItem, constraints);
    }
}

