/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.gui.tree.menu;

import ch.e2e.builder.analyzer.gui.tree.menu.Logging;
import ch.e2e.builder.analyzer.tree.RefreshTracesTreeEvent;
import ch.e2e.builder.base.gui.E2EBuilderQuestionDialog;
import ch.e2e.builder.trace.E2ETraceModule;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.event.TestcaseEvent;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.io.FilesNotDeletedException;
import ch.e2e.util.StringTools;
import java.io.File;
import java.util.EventObject;

public class DeleteTraceExecuter
implements EventExecuter,
Logging {
    private static final String TRACE = "trace";
    private static final String DELETE_QUESTION_MESSAGE = "trace.delete.question.message";
    private static final String DELETE_QUESTION_SUBTITLE = "trace.delete.question.subtitle";
    private static final String DELETE_QUESTION_TITLE = "trace.delete.question.title";
    private E2ETraceModule module;

    public DeleteTraceExecuter(E2ETraceModule module) {
        this.module = module;
    }

    public void execute(EventObject event) {
        TestcaseObject trace = ((TestcaseEvent)event).getTestcaseObject();
        String name = trace.toString();
        String question = this.module.getTranslation(DELETE_QUESTION_MESSAGE);
        question = StringTools.replaceProperty((String)question, (String)TRACE, (String)name);
        String title = this.module.getTranslation(DELETE_QUESTION_TITLE);
        title = StringTools.replaceProperty((String)title, (String)TRACE, (String)name);
        String subtitle = this.module.getTranslation(DELETE_QUESTION_SUBTITLE);
        if (E2EBuilderQuestionDialog.doYesNoQuestion((String)title, (String)(subtitle = StringTools.replaceProperty((String)subtitle, (String)TRACE, (String)name)), (String)question)) {
            TestcaseContainer container = trace.getParent();
            try {
                container.delete(trace);
            }
            catch (FilesNotDeletedException e) {
                for (File file : e.getFiles()) {
                    String msg = "Could not delete " + (file.isDirectory() ? "directory" : "file") + " '" + file.getPath() + "'";
                    this.module.showError(msg);
                }
            }
            EventController.fire((EventObject)((Object)new RefreshTracesTreeEvent(this, (TestcaseObject)container)));
        }
    }
}

