/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.junit;

import ch.e2e.ant.gui.junit.JUnitGuiRegistry;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.swing.border.SmallBevelBorder;
import ch.e2e.test.Testable;
import ch.e2e.test.junit.event.JUnitTestClearStatusEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.EventObject;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class JUnitStatusLine
extends JTextField {
    public static final Font PLAIN_FONT = new Font("dialog", 0, 12);
    public static final Font BOLD_FONT = new Font("dialog", 1, 12);

    public JUnitStatusLine(int preferredWidth) {
        this.createGui(preferredWidth);
        this.addEventHandler();
        JUnitGuiRegistry.getInstance().registerGui(this);
    }

    public void showStatus(final String message, final int type) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (type) {
                    case 0: {
                        JUnitStatusLine.this.showError(message);
                        break;
                    }
                    case 1: {
                        JUnitStatusLine.this.showInfo(message);
                    }
                }
            }
        });
    }

    private void showInfo(String message) {
        this.setFont(PLAIN_FONT);
        this.setForeground(Color.black);
        this.setText(message);
    }

    private void showError(String status) {
        this.setFont(BOLD_FONT);
        this.setForeground(Color.red);
        this.setText(status);
        this.setToolTipText(status);
    }

    private void createGui(int preferredWidth) {
        this.setFont(BOLD_FONT);
        this.setEditable(false);
        this.setBorder((Border)new SmallBevelBorder(1));
        Dimension d = this.getPreferredSize();
        d.width = preferredWidth;
        this.setPreferredSize(d);
    }

    private void addEventHandler() {
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                JUnitStatusLine.this.clear();
            }
        }, JUnitTestClearStatusEvent.class);
    }

    public void clear() {
        this.setText("");
        this.setToolTipText(null);
    }

    public void testSelected(Testable test) {
        this.clear();
    }
}

