/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.junit;

import ch.e2e.ant.gui.junit.JUnitTestListener;
import ch.e2e.test.E2ETask;
import ch.e2e.test.junit.TestUnit;
import java.lang.reflect.Constructor;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;

public abstract class E2ETestListener
implements TestListener {
    public static final String E2E_TEST_LISTENER_KEY = "ch.e2e.ant.gui.junit.TestListener";
    private static E2ETestListener testListener;
    private TestResult result;
    private TestUnit root;
    private int taskCount;

    public abstract void showStatus(String var1, int var2);

    public TestUnit getRoot() {
        return this.root;
    }

    public TestResult getResult() {
        return this.result;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public void testStarting(Test test, TestResult result) {
        this.taskCount = 0;
        this.root = new TestUnit();
        this.root.addTest(test);
        this.result = result;
        result.addListener((TestListener)this);
    }

    public void testStarting(TestUnit root, TestResult result) {
        this.taskCount = 0;
        this.root = root;
        this.result = result;
        result.addListener((TestListener)this);
    }

    public void testFinished(Test test, TestResult result) {
    }

    public void testFailed(Test test, Throwable t) {
    }

    public static E2ETestListener getInstance() {
        if (testListener == null) {
            testListener = E2ETestListener.createTestListener();
        }
        return testListener;
    }

    public void addError(Test test, Throwable throwable) {
        this.root.addError(test);
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.root.addFailure(test);
    }

    public void endTest(Test test) {
        if (test instanceof E2ETask) {
            ++this.taskCount;
        }
        this.root.addRunTest(test);
    }

    public void startTest(Test test) {
        if (test instanceof E2ETask) {
            this.showStatus("Running Task '" + test.toString() + "'.", 1);
        } else {
            this.showStatus("Running Test '" + test.toString() + "'.", 1);
        }
    }

    private static E2ETestListener createTestListener() {
        E2ETestListener testListener;
        String className = System.getProperty(E2E_TEST_LISTENER_KEY);
        if (className == null) {
            testListener = new JUnitTestListener();
        } else {
            try {
                Class<?> clazz = Class.forName(className, true, E2ETestListener.class.getClassLoader());
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                testListener = (E2ETestListener)constructor.newInstance(new Object[0]);
            }
            catch (Throwable e) {
                testListener = new JUnitTestListener();
            }
        }
        return testListener;
    }
}

