/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class TokenizerLoop
extends Task
implements TaskContainer {
    private ArrayList insertedTasks = new ArrayList();
    private String ifString;
    private String unless;
    private String token = "next.token";
    private String delim = " ,";
    private String str;

    public void execute() throws BuildException {
        if (TokenizerLoop.testIfCondition(this.ifString, this.getProject()) && TokenizerLoop.testUnlessCondition(this.unless, this.getProject())) {
            StringTokenizer tokenizer = new StringTokenizer(this.str, this.delim);
            while (tokenizer.hasMoreTokens()) {
                String nextToken = tokenizer.nextToken();
                this.getProject().setProperty(this.token, nextToken);
                this.reconfigure();
                int length = this.insertedTasks.size();
                for (int i = 0; i < length; ++i) {
                    Task nextTask = (Task)this.insertedTasks.get(i);
                    nextTask.perform();
                }
            }
        }
    }

    public void addTask(Task task) {
        this.insertedTasks.add(task);
    }

    public void setStr(String str) {
        this.str = str;
    }

    public void setDelim(String delim) {
        this.delim = delim;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setIf(String ifString) {
        this.ifString = ifString;
    }

    public void setUnless(String unless) {
        this.unless = unless;
    }

    public void maybeConfigure() throws BuildException {
        if (this.isInvalid()) {
            super.maybeConfigure();
        } else {
            this.getRuntimeConfigurableWrapper().maybeConfigure(this.getProject(), false);
        }
    }

    private static boolean testIfCondition(String ifString, Project project) {
        boolean result = true;
        if (ifString != null) {
            String test = project.replaceProperties(ifString);
            result = project.getProperty(test) != null;
        }
        return result;
    }

    private static boolean testUnlessCondition(String unless, Project project) {
        boolean result = true;
        if (unless != null) {
            String test = project.replaceProperties(unless);
            result = project.getProperty(test) == null;
        }
        return result;
    }
}

