/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class Loop
extends Task
implements TaskContainer {
    private ArrayList insertedTasks = new ArrayList();
    private String ifString;
    private String unless;
    private String next = "next";
    private String delim = " ,";
    private String str;
    private File file;
    private boolean failOnError = true;

    public void execute() throws BuildException {
        if (Loop.testIfCondition(this.ifString, this.getProject()) && Loop.testUnlessCondition(this.unless, this.getProject())) {
            if (this.str != null) {
                this.doTokenizerLoop();
            } else if (this.file != null) {
                this.doFileLoop();
            } else if (this.failOnError) {
                throw new BuildException("The attribute 'str' or 'file' must be defined for the loop element.");
            }
        }
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    private void doFileLoop() {
        if (this.file.exists()) {
            String[] lines = this.readLines();
            for (int i = 0; i < lines.length; ++i) {
                this.executeTasks(lines[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] readLines() {
        ArrayList<String> lineList = new ArrayList<String>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(this.file));
            String line = in.readLine();
            while (line != null) {
                lineList.add(line);
                line = in.readLine();
            }
        }
        catch (IOException ex) {
            if (this.failOnError) {
                throw new BuildException((Throwable)ex);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ex) {}
        }
        String[] lines = new String[lineList.size()];
        lineList.toArray(lines);
        return lines;
    }

    private void doTokenizerLoop() {
        StringTokenizer tokenizer = new StringTokenizer(this.str, this.delim);
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            this.executeTasks(nextToken);
        }
    }

    private void executeTasks(String value) {
        this.getProject().setProperty(this.next, value);
        this.reconfigure();
        int length = this.insertedTasks.size();
        for (int i = 0; i < length; ++i) {
            Task nextTask = (Task)this.insertedTasks.get(i);
            nextTask.perform();
        }
    }

    public void setFile(File file) {
        if (this.str != null && this.failOnError) {
            throw new BuildException("Only the attribute 'str' or 'file' is allowed for the loop element.");
        }
        this.file = file;
    }

    public void addTask(Task task) {
        this.insertedTasks.add(task);
    }

    public void setStr(String str) {
        if (this.file != null && this.failOnError) {
            throw new BuildException("Only the attribute 'str' or 'file' is allowed for the loop element.");
        }
        this.str = str;
    }

    public void setDelim(String delim) {
        this.delim = delim;
    }

    public void setNext(String next) {
        this.next = next;
    }

    public void setIf(String ifString) {
        this.ifString = ifString;
    }

    public void setUnless(String unless) {
        this.unless = unless;
    }

    public void maybeConfigure() throws BuildException {
        if (this.isInvalid()) {
            super.maybeConfigure();
        } else {
            this.getRuntimeConfigurableWrapper().maybeConfigure(this.getProject(), false);
        }
    }

    private static boolean testIfCondition(String ifString, Project project) {
        boolean result = true;
        if (ifString != null) {
            String test = project.replaceProperties(ifString);
            result = project.getProperty(test) != null;
        }
        return result;
    }

    private static boolean testUnlessCondition(String unless, Project project) {
        boolean result = true;
        if (unless != null) {
            String test = project.replaceProperties(unless);
            result = project.getProperty(test) == null;
        }
        return result;
    }
}

