/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.activity;

import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.gui.uml.UmlVertexView;
import ch.e2e.builder.trace.gui.uml.activity.SignalCell;
import ch.e2e.builder.trace.testcase.uml.Action;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;

public class SignalView
extends UmlVertexView {
    private static final SignalRenderer RENDERER = new SignalRenderer();

    public SignalView() {
        this(null);
    }

    public SignalView(Object cell) {
        super(cell);
    }

    @Override
    public CellViewRenderer getRenderer() {
        return RENDERER;
    }

    protected static class SignalRenderer
    extends UmlVertexView.UmlVertexRenderer {
        private int[] xBorderPoints;
        private int[] yBorderPoints;
        private int nPoints;
        private Action.Type type;

        protected SignalRenderer() {
        }

        @Override
        public void paint(Graphics g) {
            Color color = g.getColor();
            switch (this.type) {
                case RECEIVE: {
                    this.paintRecieveSignal(g);
                    break;
                }
                case SEND: {
                    this.paintSendSignal(g);
                }
            }
            g.setColor(color);
            super.paint(g);
        }

        public void paintSendSignal(Graphics g) {
            g.setColor(this.getBackground());
            int[] xPoints = new int[]{0, this.getWidth() - 15, this.getWidth(), this.getWidth() - 15, 0};
            int[] yPoints = new int[]{0, 0, this.getHeight() / 2, this.getHeight(), this.getHeight()};
            this.nPoints = xPoints.length;
            g.fillPolygon(xPoints, yPoints, this.nPoints);
            g.setColor(this.getBorderColor());
            this.xBorderPoints = new int[]{0, this.getWidth() - 15 - 1, this.getWidth(), this.getWidth() - 15 - 1, 0};
            this.yBorderPoints = new int[]{0, 0, this.getHeight() / 2 - 1, this.getHeight() - 1, this.getHeight() - 1};
            g.drawPolygon(this.xBorderPoints, this.yBorderPoints, this.nPoints);
            this.setBorder(null);
            this.setOpaque(false);
        }

        public void paintRecieveSignal(Graphics g) {
            g.setColor(this.getBackground());
            int[] xPoints = new int[]{0, this.getWidth(), this.getWidth(), 0, 15};
            int[] yPoints = new int[]{0, 0, this.getHeight(), this.getHeight(), this.getHeight() / 2};
            this.nPoints = xPoints.length;
            g.fillPolygon(xPoints, yPoints, this.nPoints);
            g.setColor(this.getBorderColor());
            this.xBorderPoints = new int[]{0, this.getWidth() - 1, this.getWidth() - 1, 0, 14};
            this.yBorderPoints = new int[]{0, 0, this.getHeight() - 1, this.getHeight() - 1, this.getHeight() / 2 - 1};
            g.drawPolygon(this.xBorderPoints, this.yBorderPoints, this.nPoints);
            this.setBorder(null);
            this.setOpaque(false);
        }

        @Override
        protected void paintSelectionBorder(Graphics g) {
            switch (this.type) {
                case RECEIVE: 
                case SEND: {
                    Graphics2D g2 = (Graphics2D)g;
                    Stroke previousStroke = g2.getStroke();
                    if (this.childrenSelected || this.selected) {
                        g2.setStroke(UmlGraphConstants.SELECTION_STROKE);
                        if (this.childrenSelected) {
                            g.setColor(this.gridColor);
                        } else if (this.hasFocus && this.selected) {
                            g.setColor(this.lockedHandleColor);
                        } else {
                            g.setColor(this.highlightColor);
                        }
                        g.drawPolygon(this.xBorderPoints, this.yBorderPoints, this.nPoints);
                        break;
                    }
                    g2.setStroke(previousStroke);
                    break;
                }
                default: {
                    super.paintSelectionBorder(g);
                }
            }
        }

        @Override
        protected void installAttributes(CellView view) {
            super.installAttributes(view);
            this.type = ((SignalCell)view.getCell()).getType();
        }
    }
}

