/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.base.event.ApplicationWantsCloseEvent;
import ch.e2e.builder.base.plugin.gui.SetFrameWaitStateEvent;
import ch.e2e.builder.trace.E2ETraceModule;
import ch.e2e.builder.trace.gui.CloseIconJTabbedPane;
import ch.e2e.builder.trace.gui.event.OpenLinkEvent;
import ch.e2e.builder.trace.gui.event.SelectUmlObjectEvent;
import ch.e2e.builder.trace.gui.event.TabbedPaneEvent;
import ch.e2e.builder.trace.gui.event.TabbedPaneListener;
import ch.e2e.builder.trace.gui.testcase.ActivityDiagramPanel;
import ch.e2e.builder.trace.gui.testcase.DiagramPanel;
import ch.e2e.builder.trace.gui.testcase.Logging;
import ch.e2e.builder.trace.gui.testcase.MessageDisplay;
import ch.e2e.builder.trace.gui.testcase.SequenceDiagramPanel;
import ch.e2e.builder.trace.gui.testcase.StateDiagramPanel;
import ch.e2e.builder.trace.gui.testcase.TabbedView;
import ch.e2e.builder.trace.gui.watch.ActionScriptWatch;
import ch.e2e.builder.trace.gui.watch.WatchView;
import ch.e2e.builder.trace.testcase.FlowNotInspectedException;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.uml.IOUmlObject;
import ch.e2e.builder.trace.testcase.uml.IteratorFlow;
import ch.e2e.builder.trace.testcase.uml.Preprocessor;
import ch.e2e.builder.trace.testcase.uml.State;
import ch.e2e.builder.trace.testcase.uml.TransformerFlow;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.trace.testcase.uml.UmlObjectWithDiagram;
import ch.e2e.builder.trace.tools.Query;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.swing.SplitPane;
import ch.e2e.util.StringTools;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;

public class UmlTabbedView
extends SplitPane
implements TabbedView,
EventExecuter {
    private static final int DIVIDER_SIZE = 3;
    private static final double PROPORTIONAL_DIVIDER_LOCATION = 0.8;
    private static final double RESIZE_WEIGHT = 0.5;
    private Map<String, DiagramPanel> panels = new HashMap<String, DiagramPanel>();
    private Testcase testcase = null;
    private DiagramPanel statePanel = null;
    private DiagramPanel sequencePanel = null;
    private DiagramPanel mainPanel = null;
    private DiagramPanel activePanel = null;
    private CloseIconJTabbedPane tabs = null;
    private WatchView watchView;
    private ActionScriptWatch actionScriptWatch = null;
    private E2ETraceModule module;
    private Object root;
    private boolean commitTabSelection = true;
    private long runDate = -1L;

    public UmlTabbedView(E2ETraceModule module) {
        super(0);
        this.module = module;
        this.setDividerSize(3);
        this.setDividerLocation(0.8);
        this.setResizeWeight(0.5);
        this.createGui();
        this.addEventHandler();
    }

    public void execute(EventObject event) {
        EventController.fire((EventObject)new SetFrameWaitStateEvent((Object)this, true));
        this.openLink(((OpenLinkEvent)event).getUri());
        EventController.fire((EventObject)new SetFrameWaitStateEvent((Object)this, false));
    }

    @Override
    public void setTestcase(Testcase testcase) {
        if (this.testcase == null || !this.testcase.equals((Object)testcase) || this.runDate != testcase.getRunDate()) {
            if (this.activePanel != null) {
                this.activePanel.saveDiagramLayout();
            }
            this.testcase = testcase;
            this.commitTabSelection = false;
            this.tabs.removeAll();
            this.watchView.setTestcase(testcase);
            if (testcase == null) {
                this.runDate = -1L;
            } else {
                this.runDate = testcase.getRunDate();
                int testcaseType = testcase.getType();
                if (testcaseType == 40) {
                    this.mainPanel = this.getStatePanel();
                } else if (testcaseType != 39) {
                    this.mainPanel = this.getSequencePanel();
                }
            }
            if (this.mainPanel != null) {
                this.mainPanel.setTestcase(testcase);
            }
            this.commitTabSelection = true;
        }
    }

    public void setActive(boolean active) {
        this.activePanel.setActive(active);
    }

    @Override
    public void setRoot(Object root) {
        this.root = root;
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected) {
            if (this.root == null && this.testcase != null || this.root instanceof Testcase && !this.root.equals(this.testcase) || this.testcase != null && this.root instanceof TreePath && !UmlTabbedView.contains(this.testcase, (TreePath)this.root)) {
                this.root = this.testcase;
            }
            DiagramPanel diagram = null;
            if (this.root instanceof Testcase) {
                this.insertMain(this.mainPanel);
                diagram = this.mainPanel;
            } else if (this.root instanceof TreePath) {
                TreePath path = (TreePath)this.root;
                diagram = this.openUmlView(path);
            }
            if (diagram != null) {
                diagram.showDiagram();
            }
        }
    }

    public static boolean contains(Testcase testcase, TreePath path) {
        TreePath testcasePath = new TreePath(testcase.getPath());
        int pathCount = testcasePath.getPathCount();
        return testcasePath.isDescendant(path) && testcase.getUmlTree() != null && pathCount < path.getPathCount() && testcase.getUmlTree().getIndexOfChild(path.getPathComponent(pathCount)) != -1;
    }

    public CloseIconJTabbedPane getTabs() {
        return this.tabs;
    }

    @Override
    public void refresh() {
    }

    @Override
    public Object getPrintableObject() {
        return this.activePanel == null ? null : this.activePanel.getPrintableObject();
    }

    public void openLink(String uri) {
        try {
            URL url = new URL(uri);
            Query query = new Query(url.getQuery());
            if (url.getPath().endsWith("addToWatches")) {
                this.addWatch(url);
            } else if (url.getPath().endsWith("showMessage")) {
                MessageDisplay.getInstance(this.module).showMessage(query);
            } else if (url.getPath().endsWith("openActivity")) {
                this.openActivityDiagram(query);
            } else if (url.getPath().endsWith("openState")) {
                this.openStateDiagram(query);
            } else if (url.getPath().endsWith("showScript")) {
                this.openActionScriptViewer(query);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void createGui() {
        this.tabs = new CloseIconJTabbedPane();
        this.setTopComponent((Component)((Object)this.tabs));
        this.watchView = new WatchView(this.module);
        this.setBottomComponent((Component)((Object)this.watchView));
    }

    private void addEventHandler() {
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UmlTabbedView.this.setSelectedTab();
            }
        });
        this.tabs.addTabbedPaneListener(new TabbedPaneListener(){

            @Override
            public void tabAdded(TabbedPaneEvent event) {
                UmlTabbedView.this.initScrollBar(event.getTab());
            }

            @Override
            public void tabRemoved(TabbedPaneEvent event) {
                UmlTabbedView.this.removeUmlPanel((DiagramPanel)event.getTab());
            }
        });
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) throws EventExecutionVetoException {
                if (UmlTabbedView.this.activePanel != null) {
                    UmlTabbedView.this.activePanel.saveDiagramLayout();
                }
            }
        }, ApplicationWantsCloseEvent.class);
    }

    private void initScrollBar(Component tab) {
        if (tab instanceof JScrollPane) {
            JScrollPane pane = (JScrollPane)tab;
            pane.getHorizontalScrollBar().setValue(0);
            pane.getVerticalScrollBar().setValue(0);
        }
    }

    private void setSelectedTab() {
        if (this.commitTabSelection && this.tabs.getSelectedComponent() != null) {
            this.commitTabSelection = false;
            this.selectDiagram((DiagramPanel)this.tabs.getSelectedComponent());
            this.tabSelected();
            this.commitTabSelection = true;
        }
    }

    private void tabSelected() {
        Component component = this.tabs.getSelectedComponent();
        if (component != null && this.activePanel != null) {
            this.activePanel.setActive(false);
            this.setActivePanel((DiagramPanel)component);
            this.activePanel.setTestcase(this.testcase);
            this.activePanel.setActive(true);
            this.activePanel.showDiagram();
        }
    }

    private void insertMain(DiagramPanel panel) {
        if (panel != null) {
            if (this.tabs.getTabCount() == 0 || !this.tabs.getComponentAt(0).equals(panel)) {
                this.tabs.insertTab(this.module.getTranslation("uml.view.main.panel.name"), null, panel, null, 0);
            }
            this.setSelectedPanel(panel);
        }
    }

    private void addWatch(URL url) {
        try {
            if (this.tabs.getTabCount() > 0) {
                this.watchView.addWatch(url, this.tabs.getTitleAt(this.tabs.getSelectedIndex()));
            }
        }
        catch (FlowNotInspectedException e) {
            MessageDisplay.getInstance(this.module).showTestcaseFlowNotInspectedMessage(e.getFlow());
        }
    }

    private void removeUmlPanel(DiagramPanel panel) {
        this.panels.remove(panel.getDiagramName());
        this.module.removeProjectListener(panel);
    }

    private void openActivityDiagram(Query query) {
        String uniqueName = query.getParameter("activity");
        if (uniqueName != null) {
            this.selectFlow(uniqueName, true);
        }
    }

    private void openStateDiagram(Query query) {
        String uniqueName = query.getParameter("state");
        if (uniqueName != null) {
            this.selectState(uniqueName, true);
        }
    }

    private void openActionScriptViewer(Query query) {
        if (this.actionScriptWatch == null) {
            this.actionScriptWatch = new ActionScriptWatch(this.module);
        }
        this.actionScriptWatch.setTestcase(this.testcase);
        String scriptId = query.getParameter("script");
        String actionScript = scriptId == null ? null : this.testcase.getActionScript(scriptId);
        this.actionScriptWatch.setActionScript(actionScript);
        this.actionScriptWatch.showDialog();
    }

    private void selectDiagram(DiagramPanel diagramPanel) {
        if (diagramPanel instanceof SequenceDiagramPanel) {
            if (this.testcase != null) {
                EventController.fire((EventObject)new SelectUmlObjectEvent(this, this.testcase, null, false));
            }
        } else if (diagramPanel instanceof ActivityDiagramPanel) {
            this.selectFlow(diagramPanel.getDiagramName(), false);
        } else if (diagramPanel instanceof StateDiagramPanel) {
            this.selectState(diagramPanel.getDiagramName(), false);
        }
    }

    private void selectFlow(String uniqueName, boolean changeDisplay) {
        if (this.testcase == null || this.testcase.getUmlTree() == null) {
            String msg = this.testcase == null ? "testcase is null" : "UML tree is null";
            Logging.logger.info("UmlTabbedView.selectFlow(" + uniqueName + ", " + changeDisplay + "): " + msg);
        }
        if (this.testcase != null && this.testcase.getUmlTree() != null) {
            IOUmlObject object = (IOUmlObject)this.testcase.getUmlTree().findChild(uniqueName);
            if (object == null) {
                Logging.logger.info("UmlTabbedView.selectFlow(" + uniqueName + ", " + changeDisplay + "): no flow found");
                Preprocessor pre = (Preprocessor)this.testcase.getUmlTree().findChild("preprocessor");
                String msg = pre != null && pre.yieldsError() ? "tracer.operation.prevented.by.preprocessor" : "tracer.operation.no.information.from.server";
                String name = "???";
                try {
                    Method m = this.testcase.getClass().getMethod("getSoapAction", new Class[0]);
                    name = m.invoke((Object)this.testcase, new Object[0]).toString();
                    if (name.isEmpty()) {
                        name = "???";
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                msg = StringTools.replaceProperty((String)this.module.getTranslation(msg, msg), (String)"name", (String)name);
                MessageDisplay.getInstance(this.module).showInfoMessage(new String[]{"", "", ""}, msg);
            } else {
                EventController.fire((EventObject)new SelectUmlObjectEvent(this, this.testcase, (UmlObject)object, changeDisplay));
            }
        }
    }

    private void selectState(String uniqueName, boolean changeDisplay) {
        if (this.testcase != null && this.testcase.getUmlTree() != null) {
            State state = (State)this.testcase.getUmlTree().findChild(uniqueName);
            EventController.fire((EventObject)new SelectUmlObjectEvent(this, this.testcase, (UmlObject)state, changeDisplay));
        }
    }

    private void setSelectedPanel(DiagramPanel panel) {
        this.tabs.setSelectedComponent(panel);
        this.setActivePanel(panel);
    }

    private void setActivePanel(DiagramPanel panel) {
        if (this.activePanel == null || this.activePanel != panel) {
            if (this.activePanel != null) {
                this.activePanel.setActive(false);
                this.activePanel.saveDiagramLayout();
            }
            panel.setActive(true);
            this.activePanel = panel;
        }
    }

    private DiagramPanel openUmlView(TreePath path) {
        DiagramPanel diagramPanel = null;
        Object[] p = path.getPath();
        for (int i = p.length - 1; diagramPanel == null && i > -1; --i) {
            if (!(p[i] instanceof UmlObjectWithDiagram) || !((UmlObjectWithDiagram)p[i]).hasDiagram()) continue;
            diagramPanel = this.openUmlView((UmlObjectWithDiagram)p[i]);
        }
        return diagramPanel;
    }

    private DiagramPanel openUmlView(UmlObjectWithDiagram o) {
        DiagramPanel diagramPanel = null;
        if (o instanceof IOUmlObject) {
            diagramPanel = this.openUmlView((IOUmlObject)o);
        } else if (o instanceof Testcase && ((Testcase)o).getType() == 40) {
            this.insertMain(this.mainPanel);
            diagramPanel = this.mainPanel;
        } else if (o instanceof State) {
            diagramPanel = this.openUmlView((State)o);
        }
        return diagramPanel;
    }

    private DiagramPanel openUmlView(IOUmlObject activityDiagram) {
        DiagramPanel panel = null;
        if (!(activityDiagram instanceof TransformerFlow) && !(activityDiagram instanceof IteratorFlow)) {
            String uniqueName = activityDiagram.getFilename();
            panel = this.panels.get(uniqueName);
            if (panel == null) {
                panel = new ActivityDiagramPanel(this.module, uniqueName);
                this.module.addProjectListener(panel);
                panel.setTestcase(this.testcase);
                this.panels.put(uniqueName, panel);
            }
            if (this.tabs.indexOfComponent(panel) == -1) {
                this.tabs.addTab(activityDiagram.getIndicatedName(), panel);
            }
            this.setSelectedPanel(panel);
        }
        return panel;
    }

    private DiagramPanel openUmlView(State stateDiagram) {
        DiagramPanel panel = null;
        String uniqueName = stateDiagram.getFilename();
        File diagramFile = new File(this.testcase.getTraceFolder(), uniqueName + ".xml");
        if (diagramFile.exists()) {
            panel = this.panels.get(uniqueName);
            if (panel == null) {
                panel = new StateDiagramPanel(this.module, uniqueName);
                panel.setTestcase(this.testcase);
                this.panels.put(uniqueName, panel);
            }
            if (this.tabs.indexOfComponent(panel) == -1) {
                this.tabs.addTab(stateDiagram.getIndicatedName(), panel);
            }
            this.setSelectedPanel(panel);
        }
        return panel;
    }

    private DiagramPanel getSequencePanel() {
        if (this.sequencePanel == null) {
            this.sequencePanel = new SequenceDiagramPanel(this.module);
        }
        return this.sequencePanel;
    }

    private DiagramPanel getStatePanel() {
        if (this.statePanel == null) {
            this.statePanel = new StateDiagramPanel(this.module);
        }
        return this.statePanel;
    }
}

