/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.gui.E2EBuilderInfoDialog;
import ch.e2e.builder.base.gui.NewPropertyDialog;
import ch.e2e.builder.base.gui.Property;
import ch.e2e.builder.base.gui.ResourceTableModel;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.testcase.Logging;
import ch.e2e.builder.trace.gui.testcase.MockBackendsPanel;
import ch.e2e.builder.trace.gui.testcase.TracePanel;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.AbstractTestcaseFolder;
import ch.e2e.builder.trace.testcase.AdapterOutputContainer;
import ch.e2e.builder.trace.testcase.AdapterOutputContainerList;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.uml.Adapter;
import ch.e2e.builder.trace.tools.AuthorizationPropertyDialog;
import ch.e2e.builder.trace.tree.RefreshSynchronousTreeEvent;
import ch.e2e.builder.trace.tree.TreeNodeChangedEvent;
import ch.e2e.event.EventController;
import ch.e2e.resource.Properties;
import ch.e2e.swing.IntegerSpinner;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;

public class Preferences
extends E2EBuilderDialog {
    private JFormattedTextField testcaseName;
    private JTextArea descriptionText;
    private JRadioButton systemButton;
    private JTextField systemLocation;
    private JRadioButton customButton;
    private JFormattedTextField customLocation;
    private IntegerSpinner requestTimeout;
    private ResourceTableModel resourceTableModel;
    private JTable resourceTable;
    private JButton removeHeaderField;
    private TracePanel tracePanel;
    private AbstractSynchronousTestcase testcase;
    private final E2EBuilderModule traceViewer;
    private JideTabbedPane tabbedPane;
    private MockBackendsPanel mockBackendsPanel;
    private JCheckBox useOAuth2;
    private JFormattedTextField oAuth2Username;
    private JPasswordField oAuth2Password;

    public Preferences(E2EBuilderModule traceViewer, boolean showTraceProperties) {
        super(traceViewer.getTranslation("testcase.preferences.title"), traceViewer.getTranslation("testcase.preferences.internaltitle"), traceViewer.getTranslation("testcase.preferences.title"), 3);
        this.traceViewer = traceViewer;
        this.createGui(showTraceProperties);
    }

    public void editPreferences(AbstractSynchronousTestcase testcase) {
        this.editPreferences(testcase, null, null);
    }

    public void editPreferences(AbstractSynchronousTestcase testcase, AdapterOutputContainerList adapterOutputContainers, Adapter adapter) {
        Properties httpHeaders = this.setupDialog(testcase, adapterOutputContainers, adapter);
        if (this.showDialog() == 1) {
            this.fillChanges(testcase, httpHeaders);
        }
    }

    private boolean fillChanges(AbstractSynchronousTestcase testcase, Properties httpHeaders) {
        boolean changed = false;
        if (this.tracePanel != null) {
            changed = this.tracePanel.fillTestcase((Testcase)testcase);
        }
        if (this.tabbedPane.indexOfComponent((Component)this.mockBackendsPanel) != -1) {
            changed |= this.mockBackendsPanel.fillTestcase((Testcase)testcase);
        }
        testcase.setDescription(this.descriptionText.getText());
        changed |= this.systemButton.isSelected() ? testcase.isUseCustomLocation() : !this.customLocation.getText().equals(testcase.getLocation());
        testcase.setUseCustomLocation(!this.systemButton.isSelected());
        testcase.setCustomLocation(this.customLocation.getText());
        changed |= testcase.setOAuth2Info(new AbstractSynchronousTestcase.OAuth2Info(this.useOAuth2.isSelected(), this.oAuth2Username.getText(), this.oAuth2Password.getText()));
        testcase.setTimeout(((Integer)this.requestTimeout.getValue()).intValue());
        this.stopResourceTableEditing();
        if (changed |= this.saveProperties(httpHeaders)) {
            testcase.setStatus(7);
            EventController.fire((EventObject)new TreeNodeChangedEvent((Object)this, (TestcaseObject)testcase));
        }
        testcase.saveProperties();
        if (this.testcaseName.getText().length() > 0 && !testcase.getName().equals(this.testcaseName.getText())) {
            this.renameTestcase(testcase);
        }
        return changed;
    }

    private Properties setupDialog(AbstractSynchronousTestcase testcase, AdapterOutputContainerList adapterOutputContainers) {
        return this.setupDialog(testcase, adapterOutputContainers, null);
    }

    private Properties setupDialog(AbstractSynchronousTestcase testcase, AdapterOutputContainerList adapterOutputContainers, Adapter adapter) {
        this.testcase = testcase;
        this.testcaseName.setText(testcase.getName());
        this.descriptionText.setText(testcase.getDescription());
        this.systemLocation.setText(testcase.getDefaultLocation());
        this.customLocation.setText(testcase.getCustomLocation());
        this.setLocationType(testcase.isUseCustomLocation());
        this.useOAuth2.setSelected(testcase.getOAuth2Info().isUse());
        this.oAuth2Username.setText(testcase.getOAuth2Info().getUsername());
        this.oAuth2Password.setText(testcase.getOAuth2Info().getPassword());
        this.requestTimeout.setValue((Object)testcase.getTimeout());
        Properties httpHeaders = testcase.getHttpHeaders();
        this.resourceTableModel.setProperties((Map)httpHeaders);
        if (this.tracePanel != null) {
            this.tracePanel.setTestcase((Testcase)testcase);
        }
        this.setupMockBackendsPanel(adapterOutputContainers, adapter);
        return httpHeaders;
    }

    private void setupMockBackendsPanel(AdapterOutputContainerList adapterOutputContainers, Adapter adapter) {
        if (this.testcase.hasAdapterTemplates()) {
            this.mockBackendsPanel.setTestcase(this.testcase);
            this.mockBackendsPanel.setAdapterOutputContainers(adapterOutputContainers == null ? new AdapterOutputContainerList(this.testcase) : adapterOutputContainers);
            int index = this.tabbedPane.indexOfComponent((Component)this.mockBackendsPanel);
            if (index == -1) {
                this.tabbedPane.add(this.traceViewer.getTranslation("testcase.preferences.tab.mock.backends"), (Component)this.mockBackendsPanel);
            }
            if (adapterOutputContainers != null) {
                if (adapter != null) {
                    for (AdapterOutputContainer container : adapterOutputContainers) {
                        if (!container.getAdapterName().equals(adapter.getOriginalName())) continue;
                        this.mockBackendsPanel.select(container);
                        break;
                    }
                }
                if (this.tabbedPane.getSelectedComponent() != this.mockBackendsPanel) {
                    this.tabbedPane.setSelectedComponent((Component)this.mockBackendsPanel);
                }
            }
        } else if (adapter == null) {
            this.tabbedPane.remove((Component)this.mockBackendsPanel);
        } else {
            this.mockBackendsPanel.setTestcase((AbstractSynchronousTestcase)null);
            int index = this.tabbedPane.indexOfComponent((Component)this.mockBackendsPanel);
            if (index == -1) {
                this.tabbedPane.add(this.traceViewer.getTranslation("testcase.preferences.tab.mock.backends"), (Component)this.mockBackendsPanel);
            }
            if (this.tabbedPane.getSelectedComponent() != this.mockBackendsPanel) {
                this.tabbedPane.setSelectedComponent((Component)this.mockBackendsPanel);
            }
        }
    }

    private void renameTestcase(AbstractSynchronousTestcase testcase) {
        AbstractTestcaseFolder testcaseFolder = (AbstractTestcaseFolder)testcase.getParent();
        testcaseFolder.renameTestcase(testcase, this.testcaseName.getText());
        EventController.fire((EventObject)new RefreshSynchronousTreeEvent((Object)this, (TestcaseObject)testcase));
    }

    protected boolean doOnOk() {
        boolean ok = true;
        TestcaseContainer testcaseContainer = this.testcase.getParent();
        String newTestcaseName = this.testcaseName.getText();
        if (!this.testcase.getName().equals(newTestcaseName) && testcaseContainer.exists(newTestcaseName)) {
            ok = false;
            this.showRenameError();
        }
        return ok;
    }

    private void showRenameError() {
        String message = this.traceViewer.getTranslation("testcase.rename.error.exists.message");
        String title = this.traceViewer.getTranslation("testcase.rename.error.exists.title");
        String subtitle = this.traceViewer.getTranslation("testcase.rename.error.exists.internaltitle");
        String internaltitle = this.traceViewer.getTranslation("testcase.rename.error.exists.subtitle");
        E2EBuilderInfoDialog.error((String)title, (String)internaltitle, (String)subtitle, (String)message);
    }

    private void setLocationType(boolean customLocation) {
        if (customLocation) {
            this.customButton.setSelected(true);
        } else {
            this.systemButton.setSelected(true);
        }
        this.customLocation.setEditable(customLocation);
        this.customLocation.setOpaque(customLocation);
    }

    private void createGui(boolean showTraceProperties) {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JideTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.add(this.traceViewer.getTranslation("testcase.preferences.tab.general"), (Component)this.createGeneralPanel(this.traceViewer));
        if (showTraceProperties) {
            this.tracePanel = new TracePanel(this.traceViewer);
            this.tabbedPane.add(this.traceViewer.getTranslation("testcase.preferences.tab.trace"), (Component)this.tracePanel);
        }
        this.tabbedPane.add(this.traceViewer.getTranslation("testcase.preferences.tab.http.header"), (Component)this.createHeaderPanel(this.traceViewer));
        this.mockBackendsPanel = this.createMockBackendsPanel(this.traceViewer);
    }

    private JPanel createGeneralPanel(E2EBuilderModule traceViewer) {
        JPanel general = new JPanel(new GridBagLayout());
        GridBagConstraints c = this.setupGeneralPanelConstraints();
        this.createNamePanel(general, c);
        this.createDescriptionPanel(traceViewer, general, c);
        this.createLocationPanel(traceViewer, general, c);
        this.createTimeoutPanel(traceViewer, general, c);
        return general;
    }

    private GridBagConstraints setupGeneralPanelConstraints() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        return c;
    }

    private void createNamePanel(JPanel general, GridBagConstraints c) {
        JPanel name = new JPanel(new GridBagLayout());
        name.setBorder(BorderFactory.createCompoundBorder(new TitledBorder("Name"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        general.add((Component)name, c);
        this.testcaseName = new JFormattedTextField(new Trimmer());
        this.removeInputMapEvents(this.testcaseName);
        name.add((Component)this.testcaseName, c);
    }

    private void createDescriptionPanel(E2EBuilderModule traceViewer, JPanel general, GridBagConstraints c) {
        JPanel description = new JPanel(new GridBagLayout());
        description.setBorder(BorderFactory.createCompoundBorder(traceViewer.createTitledBorder("testcase.preferences.border.description"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        general.add((Component)description, c);
        this.descriptionText = new JTextArea();
        this.descriptionText.setRows(5);
        JScrollPane descriptionScrollPane = new JScrollPane(this.descriptionText);
        c.insets = new Insets(0, 0, 0, 0);
        description.add((Component)descriptionScrollPane, c);
    }

    private void createLocationPanel(E2EBuilderModule traceViewer, JPanel general, GridBagConstraints c) {
        JPanel location = new JPanel(new GridBagLayout());
        location.setBorder(BorderFactory.createCompoundBorder(traceViewer.createTitledBorder("testcase.preferences.border.locations"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        c.insets = new Insets(0, 0, 0, 0);
        general.add((Component)location, c);
        this.createSystemLocation(traceViewer, c, location);
        this.createCustomLocation(traceViewer, c, location);
        this.createOAuth2Panel(traceViewer, c, location);
        ButtonGroup group = new ButtonGroup();
        group.add(this.systemButton);
        group.add(this.customButton);
    }

    private void createSystemLocation(E2EBuilderModule traceViewer, GridBagConstraints c, JPanel location) {
        this.systemButton = traceViewer.createRadioButton("testcase.preferences.radio.location.wsdl");
        c.insets = new Insets(0, 0, 0, 0);
        location.add((Component)this.systemButton, c);
        this.systemLocation = new JTextField(40);
        this.systemLocation.setEditable(false);
        this.systemLocation.setOpaque(false);
        c.insets = new Insets(0, 15, 0, 0);
        location.add((Component)this.systemLocation, c);
    }

    private void createCustomLocation(E2EBuilderModule traceViewer, GridBagConstraints c, JPanel location) {
        this.customButton = traceViewer.createRadioButton("testcase.preferences.radio.location.custom");
        this.customButton.setSelected(false);
        this.customButton.addItemListener(e -> {
            boolean selected = e.getStateChange() == 1;
            this.customLocation.setEditable(selected);
            this.customLocation.setOpaque(selected);
            if (selected && this.customLocation.getText().isEmpty()) {
                this.customLocation.setText(this.systemLocation.getText());
            }
        });
        c.insets = new Insets(0, 0, 0, 0);
        location.add((Component)this.customButton, c);
        this.customLocation = new JFormattedTextField(new Trimmer());
        this.removeInputMapEvents(this.customLocation);
        this.customLocation.setColumns(40);
        this.customLocation.setEditable(false);
        this.customLocation.setOpaque(false);
        c.insets = new Insets(0, 15, 0, 0);
        location.add((Component)this.customLocation, c);
    }

    private void createOAuth2Panel(E2EBuilderModule traceViewer, GridBagConstraints c, JPanel locationPanel) {
        JPanel oAuth2Panel = new JPanel(new FlowLayout(3));
        this.useOAuth2 = traceViewer.createCheckBox("testcase.preferences.checkbox.use.oauth2");
        oAuth2Panel.add(this.useOAuth2);
        oAuth2Panel.add(traceViewer.createLabel("testcase.preferences.label.oauth2.user"));
        this.oAuth2Username = new JFormattedTextField(new Trimmer());
        this.oAuth2Username.setColumns(10);
        oAuth2Panel.add(this.oAuth2Username);
        oAuth2Panel.add(traceViewer.createLabel("testcase.preferences.label.oauth2.password"));
        this.oAuth2Password = new JPasswordField(10);
        oAuth2Panel.add(this.oAuth2Password);
        c.insets = new Insets(0, 15, 0, 0);
        locationPanel.add((Component)oAuth2Panel, c);
    }

    private void createTimeoutPanel(E2EBuilderModule traceViewer, JPanel general, GridBagConstraints c) {
        JPanel timeout = new JPanel(new GridBagLayout());
        timeout.setBorder(BorderFactory.createCompoundBorder(traceViewer.createTitledBorder("testcase.preferences.border.timeout"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        c.insets = new Insets(0, 0, 0, 0);
        c.weighty = 1.0;
        general.add((Component)timeout, c);
        SpinnerNumberModel inputModel = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 10);
        this.requestTimeout = new IntegerSpinner(inputModel);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 18;
        timeout.add((Component)this.requestTimeout, c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 8, 0, 0);
        c.anchor = 17;
        timeout.add((Component)traceViewer.createLabel("testcase.preferences.label.timeout.unit"), c);
    }

    private void removeInputMapEvents(JFormattedTextField formattedTextField) {
        formattedTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "none");
        formattedTextField.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "none");
    }

    private JPanel createHeaderPanel(E2EBuilderModule traceViewer) {
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.resourceTableModel = new ResourceTableModel();
        this.resourceTable = new JTable((TableModel)this.resourceTableModel);
        this.resourceTable.getSelectionModel().addListSelectionListener(e -> this.checkRemoveButton());
        headerPanel.add((Component)new JScrollPane(this.resourceTable), "Center");
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 5, 0, 0);
        c.fill = 2;
        c.anchor = 11;
        c.gridwidth = 0;
        c.weighty = 0.0;
        JButton add = ComponentFactory.createButton((String)"testcase.preferences.http.header.button.add", (E2EBuilderModule)traceViewer);
        add.addActionListener(e -> this.addProperty());
        buttonPanel.add((Component)add, c);
        this.removeHeaderField = ComponentFactory.createButton((String)"testcase.preferences.http.header.button.remove", (E2EBuilderModule)traceViewer);
        this.removeHeaderField.addActionListener(e -> this.removeProperty());
        c.weighty = 1.0;
        buttonPanel.add((Component)this.removeHeaderField, c);
        JButton modifyAuthorization = ComponentFactory.createButton((String)"testcase.preferences.http.header.button.modify", (E2EBuilderModule)traceViewer);
        modifyAuthorization.addActionListener(e -> this.modifyAuthorizationProperty(traceViewer));
        c.weighty = 2.0;
        buttonPanel.add((Component)modifyAuthorization, c);
        headerPanel.add((Component)buttonPanel, "East");
        return headerPanel;
    }

    private MockBackendsPanel createMockBackendsPanel(E2EBuilderModule traceViewer) {
        return new MockBackendsPanel(traceViewer);
    }

    private void checkRemoveButton() {
        int[] selectedRows = this.resourceTable.getSelectedRows();
        boolean enabled = selectedRows.length > 0;
        this.removeHeaderField.setEnabled(enabled);
    }

    private void removeProperty() {
        int[] selectedRows;
        for (int selectedRow : selectedRows = this.resourceTable.getSelectedRows()) {
            this.resourceTableModel.removeRow(selectedRow);
        }
    }

    private void addProperty() {
        Property property = NewPropertyDialog.createNewProperty();
        if (property != null) {
            this.resourceTableModel.addProperty(property);
        }
    }

    private void modifyAuthorizationProperty(E2EBuilderModule traceViewer) {
        Property property = AuthorizationPropertyDialog.edit(this.resourceTableModel.getProperties(), traceViewer);
        if (property != null) {
            int index = AuthorizationPropertyDialog.findAuthorizationProperty(this.resourceTableModel.getProperties());
            if (index != -1) {
                this.resourceTableModel.removeRow(index);
            }
            this.resourceTableModel.addProperty(property);
        }
    }

    private void stopResourceTableEditing() {
        if (this.resourceTable.isEditing()) {
            this.resourceTable.getCellEditor().stopCellEditing();
        }
    }

    private boolean saveProperties(Properties properties) {
        boolean changed = false;
        try {
            List propertyList = this.resourceTableModel.getProperties();
            ArrayList<String> names = new ArrayList<String>(propertyList.size());
            for (Object o : properties.keySet()) {
                names.add((String)o);
            }
            for (Property property : propertyList) {
                String key = property.getKey();
                String value = property.getValue();
                changed |= !value.equals(properties.get((Object)key));
                properties.setProperty(key, value);
                names.remove(key);
            }
            for (String key : names) {
                properties.removeProperty(key);
                changed = true;
            }
            properties.write(false);
        }
        catch (IOException e) {
            Logging.logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            Logging.logger.throwing(((Object)((Object)this)).getClass().getName(), "saveProperties", e);
        }
        return changed;
    }

    private static class Trimmer
    extends JFormattedTextField.AbstractFormatter {
        private Trimmer() {
        }

        @Override
        public Object stringToValue(String text) {
            return text.trim();
        }

        @Override
        public String valueToString(Object value) {
            return value == null ? null : value.toString();
        }
    }
}

