/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.base.project.event.ProjectEvent;
import ch.e2e.builder.trace.E2ETraceModule;
import ch.e2e.builder.trace.gui.testcase.DiagramPanel;
import ch.e2e.builder.trace.gui.uml.UmlCell;
import ch.e2e.builder.trace.gui.uml.UmlGraph;
import ch.e2e.builder.trace.gui.uml.UmlGraphFileCorruptException;
import ch.e2e.builder.trace.gui.uml.activity.ActivityGraphBuilder;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.uml.Activity;
import ch.e2e.builder.trace.testcase.uml.GenericFlow;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.tree.TreePath;

public class ActivityDiagramPanel
extends DiagramPanel {
    private boolean ignoreCaughtErrors;

    public ActivityDiagramPanel(E2ETraceModule module, String diagramName) {
        super(module, diagramName);
        this.ignoreCaughtErrors = module.getGenericProjectProperty("ignore.caught.errors", false);
    }

    @Override
    protected UmlGraph createGraph() {
        UmlGraph graph;
        block10: {
            Testcase testcase = this.getTestcase();
            graph = null;
            if (testcase != null) {
                UmlTree umlTree = testcase.getUmlTree();
                if (umlTree != null) {
                    File targetFolder = testcase.getGraphFolder();
                    File target = new File(targetFolder, this.getDiagramName());
                    UmlObject umlObject = umlTree.findChild(this.getDiagramName());
                    if (umlObject != null) {
                        ActivityGraphBuilder activityGraphBuilder = new ActivityGraphBuilder(testcase, umlObject, this.getModule());
                        graph = activityGraphBuilder.getGraph();
                        try {
                            if (target.exists()) {
                                try {
                                    graph.readLayout(target);
                                }
                                catch (UmlGraphFileCorruptException e) {
                                    graph.saveLayout(target);
                                }
                                break block10;
                            }
                            targetFolder.mkdirs();
                            graph.saveLayout(target);
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    } else {
                        logger.info("ActivityDiagramPanel.createGraph(): no diagram for name '" + this.getDiagramName() + "'");
                    }
                } else {
                    logger.info("ActivityDiagramPanel.createGraph(): no UML tree");
                }
            }
        }
        return graph;
    }

    @Override
    protected Object getCell(Object root) {
        Object o;
        UmlCell result = null;
        if (root instanceof TreePath && !((o = ((TreePath)root).getLastPathComponent()) instanceof GenericFlow)) {
            Object[] cells;
            UmlGraph graph;
            Object[] p = ((TreePath)root).getPath();
            for (int i = p.length - 1; i > -1; --i) {
                if (!(p[i] instanceof Activity)) continue;
                o = p[i];
                break;
            }
            if ((graph = this.getGraph()) != null && (cells = graph.getCells()) != null) {
                for (Object cellObject : cells) {
                    UmlObject umlObject;
                    UmlCell cell;
                    Object userObject;
                    if (!(cellObject instanceof UmlCell) || !((userObject = (cell = (UmlCell)((Object)cellObject)).getUserObject()) instanceof UmlObject) || !o.equals(umlObject = ((UmlObject)userObject).getParent())) continue;
                    result = cell;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public void projectSettingsChange(ProjectEvent event) {
        boolean ignore = event.getProject().getGenericValue("ignore.caught.errors", false);
        if (this.ignoreCaughtErrors != ignore) {
            this.setDirty(true);
            this.showDiagram();
            this.ignoreCaughtErrors = ignore;
        }
    }
}

