/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.InvalidPropertyValueException;
import ch.e2e.builder.compiler.uml.NoSuchPropertyException;
import ch.e2e.builder.compiler.uml.Property;
import ch.e2e.builder.compiler.uml.PropertyDefinition;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class UmlProperties
extends TreeMap<String, Property> {
    public UmlProperties() {
        super(new PropertyComparator());
    }

    public UmlProperties(Property[] properties) {
        for (Property property : properties) {
            this.addProperty(property);
        }
    }

    public UmlProperties(PropertyDefinition[] definitions) {
        for (PropertyDefinition d : definitions) {
            this.addProperty(new Property(d));
        }
    }

    public void addProperty(Property property) {
        this.put(property.getName(), property);
    }

    public Property getProperty(String propertyName) throws NoSuchPropertyException {
        Property p = (Property)this.get(propertyName);
        if (p == null) {
            throw new NoSuchPropertyException(propertyName);
        }
        return p;
    }

    public boolean hasProperty(String propertyName) {
        return this.containsKey(propertyName);
    }

    public Object getPropertyValue(String propertyName) throws NoSuchPropertyException {
        return this.getProperty(propertyName).getValue();
    }

    public void setPropertyValue(String propertyName, Object value) throws NoSuchPropertyException, InvalidPropertyValueException {
        Property p = this.getProperty(propertyName);
        p.setValue(value);
    }

    public void setPropertyValues(Map<String, ?> valueMap) {
        for (Map.Entry<String, ?> entry : valueMap.entrySet()) {
            try {
                this.setPropertyValue(entry.getKey(), entry.getValue());
            }
            catch (Exception e) {
                System.out.println("No such property: " + entry.getKey());
            }
        }
    }

    public List<Property> getVisibleProperties() {
        ArrayList<Property> result = new ArrayList<Property>();
        for (Property property : this.values()) {
            if (property.findVisibleValue(this.values()) == null) continue;
            result.add(property);
        }
        return result;
    }

    public void checkDependencies() {
        for (Property property : this.values()) {
            ArrayList<String> dependencies = property.getDefinition().getDependencies();
            for (String dependency : dependencies) {
                if (!this.hasProperty(dependency)) continue;
                try {
                    property.setDependencyValue(dependency, this.getProperty(dependency).getValue());
                }
                catch (NoSuchPropertyException noSuchPropertyException) {}
            }
        }
    }

    @Override
    public Object clone() {
        UmlProperties clone = new UmlProperties();
        for (String s : this.keySet()) {
            try {
                clone.put(s, (Property)((Property)this.get(s)).clone());
            }
            catch (CloneNotSupportedException e) {
                clone.put(s, this.get(s));
            }
        }
        return clone;
    }

    private static class PropertyComparator
    implements Comparator<String> {
        private PropertyComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }
}

