/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.BridgeDependency;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.DependencyEvent;
import ch.e2e.builder.compiler.uml.DependencyList;
import ch.e2e.builder.compiler.uml.DependencyListener;
import ch.e2e.builder.compiler.uml.DependencySupplier;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Helpers;
import java.util.ArrayList;

public class DependencyClient
extends DeploymentElement {
    private DeploymentElement client;
    private ArrayList<DependencySupplier> suppliers;
    private DependencyListener dependencyListener;

    public DependencyClient(DeploymentElement client, ArrayList<DependencySupplier> suppliers, Helpers helpers) {
        super(client.getName(), new Comment("", helpers), helpers);
        this.client = client;
        this.suppliers = suppliers;
    }

    public DeploymentElement getClient() {
        return this.client;
    }

    public ArrayList<DependencySupplier> getSuppliers() {
        ArrayList<DependencySupplier> suppliers = new ArrayList<DependencySupplier>();
        for (DependencySupplier supplier : this.suppliers) {
            boolean add = true;
            int length = this.client.getBridgeDependencies().size();
            for (int i = 0; i < length && add; ++i) {
                BridgeDependency dependency = this.client.getBridgeDependencies().get(i);
                add = !dependency.getSupplier().equals(supplier.getSupplierElement());
            }
            if (!add) continue;
            suppliers.add(supplier);
        }
        return suppliers;
    }

    public ArrayList<DependencySupplier> getUseableSuppliers() {
        ArrayList<DependencySupplier> suppliers = new ArrayList<DependencySupplier>();
        for (DependencySupplier supplier : this.suppliers) {
            boolean add = true;
            int length = this.client.getBridgeDependencies().size();
            for (int i = 0; i < length && add; ++i) {
                BridgeDependency dependency = this.client.getBridgeDependencies().get(i);
                add = dependency.multipleInstancesAllowed() || !dependency.getSupplier().equals(supplier.getSupplierElement());
            }
            if (!add) continue;
            suppliers.add(supplier);
        }
        return suppliers;
    }

    @Override
    public DependencyList getBridgeDependencies() {
        return this.client.getBridgeDependencies();
    }

    @Override
    public void addDependency(BridgeDependency dependency) {
        this.client.addDependency(dependency);
        if (this.dependencyListener != null) {
            this.dependencyListener.dependencyAdded(new DependencyEvent(this, dependency));
        }
    }

    @Override
    public BridgeStereotype getStereotype() {
        return this.client.getStereotype();
    }

    public boolean hasRequiredDependency() {
        boolean result = false;
        ArrayList<BridgeStereotype> dependencyTypes = this.client.getStereotype().getCustomization().getRequiredBridgeDependencies();
        for (BridgeStereotype dependencyType : dependencyTypes) {
            result = !this.client.getBridgeDependencies().containsDependencyType(dependencyType);
        }
        return result;
    }

    public void setDependencyListener(DependencyListener dependencyListener) {
        this.dependencyListener = dependencyListener;
    }
}

