/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.idoc;

import ch.e2e.builder.compiler.document.importer.idoc.FieldMeta;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.Logging;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.swing.text.html.HTMLEditorKit;

public class DocumentationParser
extends HTMLEditorKit.ParserCallback
implements Logging {
    private File htmlDocuFile;
    private Hashtable fieldMetas = new Hashtable();

    public DocumentationParser(File htmlDocuFile) {
        this.htmlDocuFile = htmlDocuFile;
    }

    public void parse() throws FileNotFoundException, IOException {
        String withoutSegmentDocu;
        String[] segStructParts;
        String contents = this.readFile(this.htmlDocuFile);
        String[] segDocParts = contents.split("Segment documentation");
        if (segDocParts.length == 1) {
            segDocParts = contents.split("Segment-Dokumentationen");
        }
        if ((segStructParts = (withoutSegmentDocu = new String(segDocParts[0])).split("Segment-Strukturen")).length == 1) {
            segStructParts = withoutSegmentDocu.split("Segment structures");
        }
        if (segStructParts.length > 1) {
            String data = new String(segStructParts[1]);
            data = data.replaceAll("\\r\\n", "");
            String[] parts = data.split("\\<li\\>");
            String currentSegment = "";
            for (int i = 1; i < parts.length; ++i) {
                if (parts[i].startsWith("<b>")) continue;
                if (parts[i].startsWith("<h2>")) {
                    String[] releasedSplit;
                    String[] sa = parts[i].split("<p>");
                    if ((sa = sa[1].split(" "))[0].equalsIgnoreCase("Segmentdefinition")) {
                        releasedSplit = sa[1].split("freigegebe");
                        currentSegment = releasedSplit[0];
                        continue;
                    }
                    if (!sa[0].equalsIgnoreCase("Segment")) continue;
                    releasedSplit = sa[2].split("Release");
                    currentSegment = releasedSplit[0];
                    continue;
                }
                if (parts[i].startsWith("<HTML>")) continue;
                String meta = parts[i].split("\\</ol\\>")[0];
                if (meta.length() == 0) {
                    logger.warning("Problem when splitting FieldMeta information out of HTML string: length is 0");
                    continue;
                }
                FieldMeta fm = new FieldMeta(meta);
                if (fm == null) {
                    logger.warning("Created FieldMeta object is null - cannot use that");
                    continue;
                }
                if (fm.name == null || fm.name.length() == 0) {
                    logger.warning("Created FieldMeta's name is empty - cannot use that");
                    continue;
                }
                fm.segmentName = currentSegment;
                this.fieldMetas.put(currentSegment + ":" + fm.name, fm);
            }
        }
    }

    public FieldMeta getFieldMeta(String segmentName, String fieldName) {
        return (FieldMeta)this.fieldMetas.get(segmentName + ":" + fieldName);
    }

    private String readFile(File f) throws FileNotFoundException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtilities.copy((InputStream)new FileInputStream(f), (OutputStream)baos);
        return baos.toString();
    }
}

