/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.source;

import ch.e2e.builder.compiler.Properties;
import ch.e2e.builder.compiler.build.tasks.source.InputStreamSource;
import java.io.InputStream;
import java.net.URL;

public class JavaResourceSource
implements InputStreamSource {
    public static String resourceIdPrefix = "resource:";
    private final String id;
    private String hash;

    public static String resourcePathWithoutPrefix(String id) {
        return id.substring(resourceIdPrefix.length());
    }

    public static URL getResource(String id) {
        return JavaResourceSource.class.getClassLoader().getResource(JavaResourceSource.resourcePathWithoutPrefix(id));
    }

    JavaResourceSource(String id) {
        this.id = id;
    }

    @Override
    public InputStream getInputStream() {
        return JavaResourceSource.class.getClassLoader().getResourceAsStream(JavaResourceSource.resourcePathWithoutPrefix(this.id));
    }

    @Override
    public String getHash() {
        if (this.hash == null) {
            try {
                this.hash = new Properties().getProperty("version");
            }
            catch (Exception e) {
                this.hash = "";
            }
        }
        return this.hash;
    }
}

