/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2angular.procode;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.AngularNpmTask;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.library.LibraryAngularPackage;
import ch.e2e.builder.compiler.document.json.library.LibraryDescriptor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class AngularInstallProCodeDependencyTask
extends AngularNpmTask {
    public static Boolean select(String id) {
        return id.endsWith(".install.npm");
    }

    public AngularInstallProCodeDependencyTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".install.npm";
    }

    @Override
    protected Set<String> getDestinationFiles() {
        HashSet<String> result = new HashSet<String>();
        result.add(ch.e2e.builder.compiler.build.tasks.constants.Files.angular_node_modules_PACKAGE__package_json(this.getPackage().getName()));
        return result;
    }

    private LibraryAngularPackage getPackage() {
        return ((JsonDocumentSource)this.getSourceManager().getSource(this.getLibraryDescriptor())).getJsonDocument(LibraryDescriptor.class).getContent().getAngular().getPackage();
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add(this.getLibraryDescriptor());
        return result;
    }

    @Override
    protected String getNpmArguments() {
        LibraryAngularPackage aPackage = this.getPackage();
        String dependency = Objects.nonNull(aPackage.getFile()) ? String.format("file:%s", Paths.get("libraries", new String[0]).resolve(aPackage.getFile())) : String.format("%s@%s", aPackage.getName(), aPackage.getVersion());
        return "install " + dependency + " --no-save --force";
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        Path nodeModules = this.getSourceManager().getWorkFolder().toPath().resolve("angular/node_modules");
        if (!Files.exists(nodeModules, new LinkOption[0])) {
            try {
                Files.createDirectories(nodeModules, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.executeTask(dependencyLevel);
    }

    private String getLibraryDescriptor() {
        return ch.e2e.builder.compiler.build.tasks.constants.Files.libs_LIBRARY__library_descriptor_xml(this.getDestinationFileNameWithoutExtension());
    }
}

