/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CompileConfigurationTask;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.build.types.ModulesTabfile;
import ch.e2e.builder.compiler.build.types.TabfileMerge;
import ch.e2e.builder.compiler.build.types.TabfileMergeContainer;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.Composite;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.descriptor.Library;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.builder.compiler.error.DefaultCompilerError;
import ch.e2e.dom.DomUtilities;
import ch.e2e.logging.PerformanceLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TabfileMergeTask
extends CompileConfigurationTask
implements Logging {
    private static final String COMPILER_ID = "tabfile.merge";

    public TabfileMergeTask() {
        super(new CompileControl[0]);
    }

    private TabfileMerge getTabfileMerge(CompilableObject compilableObject) {
        if (compilableObject instanceof Library) {
            return new TabfileMerge(this.getUmlDocument(), true);
        }
        return new TabfileMerge(this.getUmlDocument(), false);
    }

    @Override
    public void executeTask(int dependencyLevel) throws BuildException {
        File descriptorFolder = new File(this.getUmlDocument().getDocumentWorkingFolder(), "descriptor");
        for (CompilableObject compilableObject : this.getCompilableObjects()) {
            TabfileMerge tabfileMerge = this.getTabfileMerge(compilableObject);
            for (Deployment deployment : compilableObject.getDeployments()) {
                TabfileMergeContainer mergedTabfiles = tabfileMerge.getTargetFile(deployment.getName());
                try {
                    Element configurationElement = this.getConfigurationElement(deployment, compilableObject.getName(), descriptorFolder);
                    this.mergeLibraries(compilableObject, mergedTabfiles, configurationElement);
                    ModulesTabfile modules = (ModulesTabfile)mergedTabfiles.getTabfile("modules", "modules", "modules");
                    if (compilableObject instanceof Composite) {
                        modules.setCurrentModule(compilableObject.getName(), compilableObject.getUmlDocument().getOriginalFile().getName(), ((Composite)compilableObject).getComponentVersion());
                    } else if (compilableObject instanceof Library) {
                        modules.setCurrentModule(compilableObject.getName(), compilableObject.getUmlDocument().getOriginalFile().getName(), ((Library)compilableObject).getComponentVersion());
                    }
                    ArrayList<File> tabfileContainerList = tabfileMerge.getAllSrcFiles();
                    for (File tabfileContainer : tabfileContainerList) {
                        if (tabfileContainer == null || !tabfileContainer.exists()) {
                            this.getErrorHandler().error((AbstractBuilderError)new DefaultCompilerError("Could not find tabfiles '" + (tabfileContainer == null ? "unknown file" : tabfileContainer.getAbsolutePath()) + "' for deployment '" + deployment.getName() + "'", new HashMap<String, String>()));
                            continue;
                        }
                        try {
                            this.merge(tabfileContainer, mergedTabfiles, configurationElement, compilableObject);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new BuildException("Exception merging tabfiles from " + tabfileContainer + ".", e);
                        }
                    }
                    if (!mergedTabfiles.checkLibraryVersions()) continue;
                    mergedTabfiles.printTabfiles(compilableObject instanceof Composite);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BuildException("Exception merging tabfiles from " + deployment.getName() + ".", e);
                }
                finally {
                    mergedTabfiles.getErrorHandler().addTo(this.getErrorHandler());
                }
            }
        }
    }

    protected void mergeLibraries(CompilableObject compilableObject, TabfileMergeContainer mergedTabfiles, Element configurationElement) {
        for (LibraryService library : compilableObject.getLibraries()) {
            if (compilableObject instanceof Library) {
                mergedTabfiles.appendLibraryVersion(library, configurationElement, compilableObject);
                continue;
            }
            mergedTabfiles.appendLibrary(library, configurationElement, compilableObject);
        }
    }

    private void merge(File tabfileContainer, TabfileMergeContainer mergedTabfiles, Element configurationElement, CompilableObject compilableObject) throws IOException, ParserConfigurationException, SAXException {
        long start = PerformanceLogger.start((String)this.getCompilerId(), (String)this.getUmlDocument().toString());
        Document tables = DomUtilities.parse((File)tabfileContainer, (boolean)false, (boolean)false);
        mergedTabfiles.appendTables(tables, configurationElement, compilableObject);
        PerformanceLogger.stop((String)this.getCompilerId(), (String)this.getUmlDocument().toString(), (long)start);
    }

    @Override
    protected String getCompilerId() {
        return COMPILER_ID;
    }

    @Override
    public boolean isUpToDate() {
        for (CompilableObject compilableObject : this.getCompilableObjects()) {
            if (this.getTabfileMerge(compilableObject).isUpToDate(compilableObject)) continue;
            return false;
        }
        return true;
    }
}

