/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.error.BuilderFatalError;
import ch.e2e.builder.compiler.Properties;
import ch.e2e.builder.compiler.build.tasks.Task;
import ch.e2e.builder.compiler.build.tasks.cache.ResultCache;
import ch.e2e.builder.compiler.build.tasks.cache.SourceCache;
import ch.e2e.builder.compiler.build.tasks.error.TaskErrorHandler;
import ch.e2e.builder.compiler.build.tasks.error.TaskFatalError;
import ch.e2e.builder.compiler.build.tasks.source.FileSource;
import ch.e2e.builder.compiler.build.tasks.source.Source;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public abstract class CacheAbleTask
extends Task
implements FileSource {
    private final String id;
    protected final SourceManager sourceManager;
    private AbstractErrorHandler errorHandler;
    private final String compilerVersion;
    private String hash = null;
    private Map<String, Source> beforeSourceMap;
    private Map<String, Source> sourceMap = new HashMap<String, Source>();
    private ResultCache resultCache;
    private Map<String, Source> sourcesToCheckMap;

    public CacheAbleTask(SourceManager sourceManager, String id) {
        super(sourceManager.getCompileControls());
        this.sourceManager = sourceManager;
        this.compilerVersion = this.getCompilerVersion();
        this.id = id;
        this.getTaskInfo().setId(this.getName());
    }

    @Override
    public String getName() {
        return super.getName() + ":" + this.getId();
    }

    protected SourceManager getSourceManager() {
        return this.sourceManager;
    }

    protected String getCompilerVersion() {
        return new Properties().getProperty("version");
    }

    protected final String getId() {
        return this.id;
    }

    public File getDestinationFile() {
        return new File(this.sourceManager.getWorkFolder(), this.getId());
    }

    protected String getDestinationFileName() {
        return this.getDestinationFile().getName();
    }

    protected String getDestinationFileExtension() {
        return "";
    }

    protected String getDestinationFileNameWithoutExtension() {
        String name = this.getDestinationFileName();
        return name.substring(0, name.length() - this.getDestinationFileExtension().length());
    }

    protected String getDestinationFilePathWithoutExtension() {
        String path = this.getId();
        return path.substring(0, path.length() - this.getDestinationFileExtension().length());
    }

    protected String getDestinationFolder() {
        return this.getId().substring(0, this.getId().lastIndexOf("/"));
    }

    @Override
    public File getFile() {
        return this.getDestinationFile();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.getFile());
    }

    protected String getErrorHash() {
        return this.getHash(this.getErrorHandler().getLogfile().toPath());
    }

    protected String getOutputHash() {
        return this.getHash(this.getDestinationFile().toPath());
    }

    protected String getHash(Path id) {
        try {
            if (Files.isSymbolicLink(id)) {
                return "symLink";
            }
            byte[] b = Files.readAllBytes(id);
            byte[] hashB = MessageDigest.getInstance("MD5").digest(b);
            return DatatypeConverter.printHexBinary((byte[])hashB);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getHash() {
        if (this.hash == null) {
            String errorHash;
            this.hash = this.getOutputHash();
            if (this.hash == null) {
                this.hash = "";
            }
            if ((errorHash = this.getErrorHash()) != null && !errorHash.equals("")) {
                this.hash = this.hash + "-" + errorHash;
            }
        }
        return this.hash;
    }

    @Override
    public AbstractErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = new TaskErrorHandler(this.getId(), new File(this.getDestinationFile().getParentFile(), this.getDestinationFile().getName() + ".errors")){};
        }
        return this.errorHandler;
    }

    protected Set<String> getBeforeSourceSet() {
        HashSet<String> result = new HashSet<String>();
        this.sourceManager.getTaskSourceSetFactoryStream(this.id).forEach(f -> result.addAll(f.getBeforeSourceSet(this.getSourceManager())));
        return result;
    }

    private Map<String, Source> getBeforeSourceMap() {
        if (this.beforeSourceMap == null) {
            this.beforeSourceMap = new HashMap<String, Source>();
            for (String id : this.getBeforeSourceSet()) {
                Source source = this.sourceManager.getSource(id);
                if (source == null) continue;
                this.beforeSourceMap.put(id, source);
            }
        }
        return this.beforeSourceMap;
    }

    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        this.sourceManager.getTaskSourceSetFactoryStream(this.id).forEach(f -> result.addAll(f.getSourceSet(this.getSourceManager())));
        return result;
    }

    private Map<String, Source> getSourceMap() {
        return this.sourceMap;
    }

    protected final Source getSource(String id) {
        Source source = this.getSourceMap().get(id);
        if (source == null) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("id", id);
            this.getErrorHandler().fatalError((BuilderFatalError)new TaskFatalError("FTASK0001", parameters));
        }
        return this.getSourceMap().get(id);
    }

    @Override
    protected void afterExecute() {
        this.hash = null;
        this.saveResultCache();
    }

    @Override
    public boolean isUpToDate() {
        String hash;
        ResultCache resultCache = this.getResultCache();
        if (!resultCache.compilerVersion.equals(this.compilerVersion)) {
            return false;
        }
        if (this.getSourceMap().size() != resultCache.sourceHashsMap.size()) {
            return false;
        }
        if (!(this.getDestinationFile().exists() && resultCache.lastModified != 0L && this.getDestinationFile().lastModified() == resultCache.lastModified || (hash = this.getHash()) != null && !hash.equals("") && resultCache.hash != null && !resultCache.hash.equals("") && resultCache.hash.equals(hash))) {
            return false;
        }
        for (Map.Entry<String, Source> source : this.getSourceMap().entrySet()) {
            String sourceHash;
            SourceCache sourceCache = resultCache.sourceHashsMap.get(source.getKey());
            if (source.getValue() == null || sourceCache == null) {
                return false;
            }
            if (source.getValue() instanceof FileSource && sourceCache.lastModified != 0L && ((FileSource)source.getValue()).getFile().lastModified() == sourceCache.lastModified || (sourceHash = source.getValue().getHash()) != null && !sourceHash.equals("") && sourceCache.hash != null && !sourceCache.hash.equals("") && sourceHash.equals(sourceCache.hash)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected AbstractErrorHandler executeDependsOnTasks(int dependencyLevel) {
        AbstractErrorHandler errorHandler = super.executeDependsOnTasks(dependencyLevel);
        try {
            Task task;
            for (Source source : this.getBeforeSourceMap().values()) {
                if (!(source instanceof Task)) continue;
                task = (Task)((Object)source);
                if (!task.isExecuted()) {
                    task.execute(dependencyLevel + 1);
                }
                task.getErrorHandler().addTo(errorHandler);
            }
            if (errorHandler.hasErrors()) {
                return errorHandler;
            }
            this.sourceMap = this.getBeforeSourceMap();
            for (String id : this.getSourceSet()) {
                Source source = this.sourceManager.getSource(id);
                this.sourceMap.put(id, source);
                if (source != null) continue;
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("id", id);
                errorHandler.fatalError((BuilderFatalError)new TaskFatalError("FTASK0001", parameters));
            }
            for (Source source : this.getSourcesToCheckMap().values()) {
                if (!(source instanceof Task)) continue;
                task = (Task)((Object)source);
                if (!task.isExecuted()) {
                    task.execute(dependencyLevel + 1);
                }
                task.getErrorHandler().addTo(errorHandler);
            }
        }
        catch (Exception e) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("id", this.id);
            errorHandler.error((Throwable)e);
            errorHandler.fatalError((BuilderFatalError)new TaskFatalError("FTASK0002", parameters));
        }
        return errorHandler;
    }

    private File getResultCacheFile() {
        return new File(this.sourceManager.getWorkFolder(), this.getId() + ".hash");
    }

    private ResultCache getResultCache() {
        if (this.resultCache == null) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ResultCache.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                this.resultCache = (ResultCache)jaxbUnmarshaller.unmarshal(this.getResultCacheFile());
            }
            catch (Exception e) {
                this.resultCache = new ResultCache();
            }
        }
        return this.resultCache;
    }

    protected SourceCache createSourceCache(Source source) {
        SourceCache sourceCache = new SourceCache();
        sourceCache.hash = source.getHash();
        if (source instanceof FileSource) {
            sourceCache.lastModified = ((FileSource)source).getFile().lastModified();
        }
        return sourceCache;
    }

    protected void addLastModified(ResultCache resultCache) {
        if (this.getDestinationFile().exists()) {
            resultCache.lastModified = this.getDestinationFile().lastModified();
        }
    }

    protected void saveResultCache() {
        ResultCache resultCache = new ResultCache();
        resultCache.compilerVersion = this.compilerVersion;
        resultCache.hash = this.getHash();
        this.addLastModified(resultCache);
        ArrayList<Map.Entry<String, Source>> beforeSources = new ArrayList<Map.Entry<String, Source>>(this.getBeforeSourceMap().entrySet());
        beforeSources.sort(Comparator.comparing(Map.Entry::getKey));
        for (Map.Entry entry : beforeSources) {
            if (entry.getValue() == null) continue;
            resultCache.sourceHashsMap.put((String)entry.getKey(), this.createSourceCache((Source)entry.getValue()));
        }
        ArrayList<Map.Entry<String, Source>> sources = new ArrayList<Map.Entry<String, Source>>(this.getSourceMap().entrySet());
        sources.sort(Comparator.comparing(Map.Entry::getKey));
        for (Map.Entry entry : sources) {
            if (entry.getValue() == null) continue;
            resultCache.sourceHashsMap.put((String)entry.getKey(), this.createSourceCache((Source)entry.getValue()));
        }
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{ResultCache.class});
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            File file = this.getResultCacheFile();
            file.getParentFile().mkdirs();
            marshaller.marshal((Object)resultCache, file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void marshalXmlToFile(Object xmlData, File file) {
        try {
            Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
            Marshaller jaxbMarshaller = JAXBContext.newInstance((Class[])new Class[]{xmlData.getClass()}).createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            jaxbMarshaller.marshal(xmlData, file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void propagateErrors() {
        this.getErrorHandler().serialize(false);
    }

    @Override
    public String getTaskSourceName() {
        return "";
    }

    protected Set<String> getSourcesToCheck() {
        HashSet<String> result = new HashSet<String>();
        this.sourceManager.getTaskSourceSetFactoryStream(this.id).forEach(f -> result.addAll(f.getSourcesToCheck(this.getSourceManager())));
        return result;
    }

    private Map<String, Source> getSourcesToCheckMap() {
        if (this.sourcesToCheckMap == null) {
            this.sourcesToCheckMap = this.getSourceMap();
            for (String id : this.getSourcesToCheck()) {
                Source source = this.sourceManager.getSource(id);
                if (source == null) continue;
                this.sourcesToCheckMap.put(id, source);
            }
        }
        return this.sourcesToCheckMap;
    }
}

