/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.action;

import ch.e2e.builder.base.xsltinterface.XSLTAction;
import ch.e2e.builder.compiler.build.BuildConstants;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.document.UmlDocument;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class BuildAction
implements BuildConstants,
XSLTAction {
    private CompilableObject compilableObject;
    private ArrayList<UmlDocument> umlDocuments;
    private String buildSource;

    public BuildAction() {
    }

    public BuildAction(CompilableObject compilableObject) {
        this(new ArrayList<UmlDocument>(Arrays.asList(compilableObject.getUmlDocument())));
        this.compilableObject = compilableObject;
        this.buildSource = compilableObject.getName();
    }

    public BuildAction(ArrayList<UmlDocument> umlDocuments) {
        this.umlDocuments = umlDocuments;
        this.buildSource = this.createBuildSource(umlDocuments);
    }

    public abstract String getAction();

    public ArrayList<UmlDocument> getUmlDocuments() {
        return this.umlDocuments;
    }

    public void setUmlDocuments(ArrayList<UmlDocument> umlDocuments) {
        this.umlDocuments = umlDocuments;
    }

    public CompilableObject getCompilableObject() {
        return this.compilableObject;
    }

    public void setCompilableObject(CompilableObject compilableObject) throws Exception {
        this.compilableObject = compilableObject;
    }

    public String getBuildSource() {
        return this.buildSource;
    }

    public void setBuildSource(String buildSource) {
        this.buildSource = buildSource;
    }

    public Class getMessageGroupType() {
        return this.getClass();
    }

    public String getName() {
        ArrayList<UmlDocument> documents = this.getUmlDocuments();
        StringBuilder message = new StringBuilder("Compiling ");
        for (UmlDocument umlDocument : documents) {
            message.append(umlDocument).append(", ");
        }
        return message.substring(0, message.length() - 2);
    }

    private String createBuildSource(ArrayList<UmlDocument> umlDocuments) {
        return umlDocuments.toString();
    }
}

