/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.models;

import ch.e2e.builder.compiler.models.EBMAppliedStereotype;
import ch.e2e.builder.compiler.models.EBMElementInterface;
import ch.e2e.builder.compiler.models.EBMHelper;
import ch.e2e.builder.compiler.models.EBMStereotype;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode;

@XmlDiscriminatorNode(value="@_javaType")
public class EBMElement
implements EBMElementInterface {
    static final String NAMESPACE_EBM = "http://e2e.ch/bridge/models";
    static final String NAMESPACE_XMI = "http://schema.omg.org/spec/XMI";
    @XmlAttribute
    private String name;
    @XmlAttribute(namespace="http://e2e.ch/bridge/models", name="id")
    private String ebmId;
    @XmlAttribute
    private Boolean isFinalSpecialization;
    @XmlAttribute(namespace="http://schema.omg.org/spec/XMI", name="id")
    private String xmiId;
    @XmlAttribute(namespace="http://schema.omg.org/spec/XMI", name="idref")
    private String xmiIdref;
    @XmlAttribute
    private String href;
    @XmlElement(name="appliedStereotype", namespace="http://e2e.ch/bridge/models")
    private List<EBMAppliedStereotype> appliedStereotypes = new ArrayList<EBMAppliedStereotype>();
    @XmlTransient
    EBMElement parent;
    @XmlTransient
    private String qualifiedName;

    @Override
    public Boolean isFinalSpecialization() {
        return this.isFinalSpecialization;
    }

    @Override
    public EBMElement getParent() {
        return this.parent;
    }

    void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (parent instanceof EBMElement) {
            this.parent = (EBMElement)parent;
        }
        if (this.ebmId != null) {
            EBMHelper.putElement(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEbmId() {
        return this.ebmId;
    }

    protected String getTypeName() {
        return this.getClass().getSimpleName().substring(3);
    }

    @Override
    public String getXmiId() {
        if (this.xmiId == null) {
            this.xmiId = this.ebmId != null ? "e2e_bridge_profile__" + this.ebmId : this.getParent().getXmiId() + "_" + this.getTypeName() + (this.getName() != null ? "_" + this.getName() : "");
        }
        return this.xmiId;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    public String getXmiIdref() {
        return this.xmiIdref;
    }

    @Override
    public List<EBMStereotype> getAppliedStereotypesInstances() {
        ArrayList<EBMStereotype> list = new ArrayList<EBMStereotype>();
        for (EBMAppliedStereotype appliedStereotype : this.getAppliedStereotypes()) {
            EBMStereotype stereotype = EBMHelper.getStereotype(appliedStereotype.getHref());
            if (stereotype == null) continue;
            list.add(stereotype);
        }
        return list;
    }

    @Override
    public List<EBMAppliedStereotype> getAppliedStereotypes() {
        return this.appliedStereotypes;
    }

    @Override
    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.getName();
            for (EBMElement parent = this.getParent(); parent != null && parent.getName() != null; parent = parent.getParent()) {
                this.qualifiedName = parent.getName() + "::" + this.qualifiedName;
            }
            this.qualifiedName = "Data::" + this.qualifiedName;
        }
        return this.qualifiedName;
    }
}

