/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.resource;

import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.resource.ImageLoader;
import ch.e2e.resource.Properties;
import java.awt.Color;
import javax.swing.Icon;

public class MessageType {
    public static final String APPLICATION_ERROR = E2EBuilderTranslator.getTranslation((String)"application_error", (String)"application_error");
    private static Color defaultBackground = Color.white;
    private static Color defaultForeground = Color.black;
    private static Color defaultSelectedBackground = new Color(0, 0, 128);
    private static Color defaultSelectedForeground = Color.white;
    private boolean defaultType = true;
    private Color background;
    private Color selectedBackground;
    private Color foreground;
    private Color selectedForeground;
    private Icon icon;

    public MessageType(String type, Properties properties, Properties defaultProperties) {
        this.background = this.createColor(properties, type, "_background", defaultBackground, defaultProperties);
        this.selectedBackground = this.createColor(properties, type, "_background_selected", defaultBackground, defaultProperties);
        this.foreground = this.createColor(properties, type, "_foreground", defaultBackground, defaultProperties);
        this.selectedForeground = this.createColor(properties, type, "_foreground_selected", defaultBackground, defaultProperties);
        if (properties != null) {
            this.icon = ImageLoader.loadIcon((String)properties.getString(type + "_icon"), (boolean)false, (ClassLoader)this.getClass().getClassLoader());
        }
        if (this.icon == null) {
            this.icon = ImageLoader.loadIcon((String)defaultProperties.getString(type + "_icon"), (boolean)false, (ClassLoader)this.getClass().getClassLoader());
        } else {
            this.defaultType = false;
        }
    }

    boolean isDefaultType() {
        return this.defaultType;
    }

    private Color createColor(Properties properties, String type, String colorType, Color defaultColor, Properties defaultProperties) {
        try {
            String color = null;
            try {
                color = properties.getString(type + colorType);
                this.defaultType = false;
            }
            catch (Exception ex) {
                color = defaultProperties.getString(type + colorType);
            }
            return new Color(Integer.parseInt(color.substring(1), 16));
        }
        catch (Exception ex) {
            return defaultColor;
        }
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }
}

