/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.io;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.io.E2EBuilderFileChooser;
import ch.e2e.builder.base.io.E2EFileFilter;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.swing.QuestionDialog;
import ch.e2e.util.StringTools;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.JTextComponent;

public class E2EBuilderSaveFileChooser
extends E2EBuilderFileChooser {
    private QuestionDialog overwriteDialog;

    public E2EBuilderSaveFileChooser(JFrame parent, String internalTitle, String subtitle) {
        super(parent, E2EBuilderTranslator.getTranslation((String)"save.file.chooser.title"), internalTitle, subtitle);
        this.addEventHandler();
        this.fileChooser.setDialogType(1);
    }

    public E2EBuilderSaveFileChooser(JDialog parent, String internalTitle, String subtitle) {
        super(parent, E2EBuilderTranslator.getTranslation((String)"save.file.chooser.title"), internalTitle, subtitle);
        this.addEventHandler();
        this.fileChooser.setDialogType(1);
    }

    protected E2EBuilderSaveFileChooser(File root, FileSystemView fileSystemView, Frame parent, String title, String internalTitle, String subtitle) {
        super(root, fileSystemView, parent, title, internalTitle, subtitle);
    }

    protected E2EBuilderSaveFileChooser(File root, FileSystemView fileSystemView, JDialog parent, String title, String internalTitle, String subtitle) {
        super(root, fileSystemView, parent, title, internalTitle, subtitle);
    }

    public File saveFile(File selectedFile, boolean includeAllFiles) {
        File result = null;
        try {
            this.fileChooser.setCurrentDirectory(selectedFile.getParentFile());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fileChooser.setAcceptAllFileFilterUsed(includeAllFiles);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setDialogType(1);
        this.fileChooser.setSelectedFile(selectedFile);
        FileFilter selectedFileFilter = null;
        FileFilter[] choosableFileFilters = this.fileChooser.getChoosableFileFilters();
        for (int i = 0; i < choosableFileFilters.length && selectedFileFilter == null; ++i) {
            if (!choosableFileFilters[i].accept(selectedFile)) continue;
            selectedFileFilter = choosableFileFilters[i];
        }
        if (selectedFileFilter != null) {
            this.fileChooser.setFileFilter(selectedFileFilter);
        }
        if (this.showDialog() == 1) {
            result = this.fileChooser.getSelectedFile();
        }
        return result;
    }

    public static E2EBuilderSaveFileChooser createSaveFileChooser(File root, FileSystemView fileSystemView, String title, String internalTitle, String subtitle) {
        Window parent = E2EBuilder.getInstance().getDialogParent();
        E2EBuilderSaveFileChooser result = parent instanceof Frame ? new E2EBuilderSaveFileChooser(root, fileSystemView, (Frame)parent, title, internalTitle, subtitle) : new E2EBuilderSaveFileChooser(root, fileSystemView, (JDialog)parent, title, internalTitle, subtitle);
        return result;
    }

    protected boolean doOnOk() {
        boolean result = false;
        JTextComponent filenameField = this.findTextComponent(this.fileChooser.getComponents());
        String filename = filenameField.getText();
        File selectedFile = filename == null ? this.fileChooser.getSelectedFile() : new File(this.fileChooser.getCurrentDirectory(), filename);
        if (selectedFile != null) {
            selectedFile = this.checkFileExtension(selectedFile);
            this.fileChooser.setSelectedFile(selectedFile);
            if (selectedFile.exists()) {
                String question = E2EBuilderTranslator.getTranslation((String)"overwrite.question");
                question = StringTools.replaceProperty((String)question, (String)"absolute path", (String)selectedFile.getAbsolutePath());
                result = this.getOverwriteDialog().doQuestion(question);
            } else {
                result = true;
            }
        }
        return result;
    }

    @Override
    protected void setOkButtonEnabled() {
        File file = this.fileChooser.getSelectedFile();
        boolean enabled = false;
        if (file != null) {
            if (this.fileFilter == null) {
                enabled = this.fileChooser.getFileSelectionMode() != 0 || file.isFile() || !file.exists();
            } else {
                for (int i = 0; i < this.fileFilter.length && !enabled; ++i) {
                    enabled = this.fileFilter[i].accept(file) && (this.fileChooser.getFileSelectionMode() != 0 || file.isFile()) || !file.exists();
                }
            }
        }
        this.setOkButtonEnabled(enabled);
    }

    private File checkFileExtension(File selectedFile) {
        E2EFileFilter filter;
        String absolutePath = selectedFile.getAbsolutePath();
        FileFilter selectedFilter = this.fileChooser.getFileFilter();
        if (selectedFilter instanceof E2EFileFilter && (filter = (E2EFileFilter)selectedFilter).getDefaultExtension() != null && !absolutePath.toLowerCase().endsWith(filter.getDefaultExtension().toLowerCase())) {
            absolutePath = absolutePath + filter.getDefaultExtension();
            selectedFile = new File(absolutePath);
        }
        return selectedFile;
    }

    private QuestionDialog getOverwriteDialog() {
        if (this.overwriteDialog == null) {
            this.overwriteDialog = new QuestionDialog((JDialog)((Object)this), E2EBuilderTranslator.getTranslation((String)"overwrite.title"), E2EBuilderTranslator.getTranslation((String)"overwrite.internaltitle"), E2EBuilderTranslator.getTranslation((String)"overwrite.subtitle"), 0, null);
            this.overwriteDialog.setLocale(Locale.ENGLISH);
        }
        return this.overwriteDialog;
    }

    private void addEventHandler() {
        this.fileChooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                E2EBuilderSaveFileChooser.this.fileFilterChanged(evt.getOldValue(), evt.getNewValue());
            }
        });
        this.fileChooser.addPropertyChangeListener("directoryChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                E2EBuilderSaveFileChooser.this.setOkButtonEnabled(E2EBuilderSaveFileChooser.this.findTextComponent(E2EBuilderSaveFileChooser.this.fileChooser.getComponents()).getText().length() > 0);
            }
        });
        this.fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    private JTextComponent findTextComponent(Component[] children) {
        JTextComponent result = null;
        for (int i = 0; i < children.length && result == null; ++i) {
            if (children[i] instanceof JTextComponent) {
                result = (JTextComponent)children[i];
                continue;
            }
            if (!(children[i] instanceof Container)) continue;
            result = this.findTextComponent(((Container)children[i]).getComponents());
        }
        return result;
    }

    private void fileFilterChanged(Object oldValue, Object newValue) {
        File selectedFile = this.getSelectedFile();
        if (selectedFile != null) {
            int index;
            int n = index = oldValue instanceof E2EFileFilter ? selectedFile.getName().indexOf(((E2EFileFilter)oldValue).getDefaultExtension()) : -1;
            String filename = index == -1 ? ((index = selectedFile.getName().lastIndexOf(46)) == -1 ? selectedFile.getName() : selectedFile.getName().substring(0, index)) : selectedFile.getName().substring(0, index);
            String newExtension = newValue instanceof E2EFileFilter ? ((E2EFileFilter)newValue).getDefaultExtension() : "";
            this.fileChooser.setSelectedFile(new File(selectedFile.getParentFile(), filename + newExtension));
        }
    }
}

