/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.resource.DialogStrings;
import ch.e2e.builder.base.resource.E2EBuilderIcons;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.swing.QuestionDialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class E2EBuilderQuestionDialog
extends QuestionDialog
implements E2EBuilderIcons,
DialogStrings {
    private static HashMap<Window, E2EBuilderQuestionDialog> questionDialogs = new HashMap();

    private E2EBuilderQuestionDialog(JFrame parent) {
        super(parent, E2EBuilderTranslator.getTranslation((String)"dialog.question.title"), 3, DIALOG_QUESTION_ICON);
        this.setLocale(Locale.ENGLISH);
    }

    private E2EBuilderQuestionDialog(JDialog parent) {
        super(parent, E2EBuilderTranslator.getTranslation((String)"dialog.question.title"), 3, DIALOG_QUESTION_ICON);
        this.setLocale(Locale.ENGLISH);
    }

    private E2EBuilderQuestionDialog(E2EBuilderDialog owner) {
        super((JDialog)((Object)owner), E2EBuilderTranslator.getTranslation((String)"dialog.question.title"), 3, DIALOG_QUESTION_ICON);
        this.setLocale(Locale.ENGLISH);
    }

    public static E2EBuilderQuestionDialog getInstance() {
        return E2EBuilderQuestionDialog.getQuestionDialog();
    }

    public static E2EBuilderQuestionDialog newInstance() {
        Window parent = E2EBuilder.getInstance().getDialogParent();
        E2EBuilderQuestionDialog questionDialog = parent instanceof JFrame ? new E2EBuilderQuestionDialog((JFrame)parent) : new E2EBuilderQuestionDialog((JDialog)parent);
        questionDialog.setLocale(Locale.ENGLISH);
        return questionDialog;
    }

    public static E2EBuilderQuestionDialog newInstance(E2EBuilderDialog owner) {
        return new E2EBuilderQuestionDialog(owner);
    }

    public static boolean doOkCancelQuestion(String title, String subtitle, String question) {
        Frame parentFrame = E2EBuilder.getInstance().getParentFrame();
        E2EBuilderQuestionDialog.getQuestionDialog().setType(3);
        boolean result = E2EBuilderQuestionDialog.getQuestionDialog().doQuestion(title, subtitle, question);
        E2EBuilder.getInstance().setParentFrame(parentFrame);
        return result;
    }

    public static boolean doYesNoQuestion(String title, String subtitle, String question) {
        Frame parentFrame = E2EBuilder.getInstance().getParentFrame();
        E2EBuilderQuestionDialog.getQuestionDialog().setType(0);
        boolean result = E2EBuilderQuestionDialog.getQuestionDialog().doQuestion(title, subtitle, question);
        E2EBuilder.getInstance().setParentFrame(parentFrame);
        return result;
    }

    public static E2EBuilderQuestionDialog getQuestionDialog() {
        Window parent = E2EBuilder.getInstance().getDialogParent();
        E2EBuilderQuestionDialog questionDialog = questionDialogs.get(parent);
        if (questionDialog == null) {
            questionDialog = parent instanceof JFrame ? new E2EBuilderQuestionDialog((JFrame)parent) : new E2EBuilderQuestionDialog((JDialog)parent);
            questionDialogs.put(parent, questionDialog);
        }
        return questionDialog;
    }

    public int getMaximumWidth() {
        return 450;
    }

    public void validate() {
        try {
            super.validate();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }
}

