/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.testcase;

import ch.e2e.builder.base.io.UniqueIdService;
import ch.e2e.builder.base.io.WrongIDFileVersionException;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.tools.TraceTools;
import ch.e2e.builder.traceviewer.testcase.AbstractAsyncTestcaseFolder;
import ch.e2e.builder.traceviewer.testcase.AsynchronousClass;
import ch.e2e.builder.traceviewer.testcase.AsynchronousTestcaseFolder;
import ch.e2e.builder.traceviewer.testcase.AsynchronousTestcaseTemplate;
import ch.e2e.builder.traceviewer.testcase.PersistentStateTestcaseFolder;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.FilesNotDeletedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AsynchronousFolder
extends TestcaseContainer {
    private static final String INFO_FILENAME = ".info";
    private static final String PROPERTY_SERVICE_NAME = "serviceName";
    private File home;
    private File idFile;
    private String serviceName;
    private Map<String, String> uniqueIds;
    private ArrayList<PersistentStateTestcaseFolder> persitentStates;

    public AsynchronousFolder(String name, File home, String serviceName) {
        this(name, home, new File(home, ".asynchronous.id"), serviceName);
        this.saveInfo();
    }

    private void saveInfo() {
        OutputStreamWriter writer = null;
        try {
            Properties info = new Properties();
            info.setProperty(PROPERTY_SERVICE_NAME, this.serviceName);
            writer = new FileWriter(new File(this.home, INFO_FILENAME));
            info.store(writer, null);
        }
        catch (IOException iOException) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public AsynchronousFolder(String name, File home, File idFile) {
        this(name, home, idFile, AsynchronousFolder.getServiceName(home));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getServiceName(File home) {
        InputStreamReader reader = null;
        try {
            reader = new FileReader(new File(home, INFO_FILENAME));
            Properties info = new Properties();
            info.load(reader);
            String string = info.getProperty(PROPERTY_SERVICE_NAME);
            return string;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private AsynchronousFolder(String name, File home, File idFile, String serviceName) {
        super(name, 20);
        this.home = home;
        this.idFile = idFile;
        this.serviceName = serviceName;
        try {
            this.uniqueIds = UniqueIdService.loadUniqueIds((File)idFile);
        }
        catch (WrongIDFileVersionException e) {
            idFile.delete();
        }
        this.persitentStates = new ArrayList();
        this.loadChildren();
    }

    public String getServiceName() {
        return this.serviceName == null || this.serviceName.isEmpty() ? this.getName() : this.serviceName;
    }

    public void setServiceName(String serviceName) {
        if (!(this.serviceName == serviceName || this.serviceName != null && this.serviceName.equals(serviceName))) {
            this.serviceName = serviceName;
            this.saveInfo();
        }
    }

    public void setTestcaseFolders(NodeList nodes) throws IOException, TransformerException {
        this.persitentStates.clear();
        this.getChildren().clear();
        TreeSet<String> foldernames = new TreeSet<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            foldernames.add(this.createTestcaseFolder((Element)nodes.item(i)));
        }
        ArrayList<String> obsoleteNames = new ArrayList<String>();
        for (String name : this.uniqueIds.keySet()) {
            if (foldernames.contains(name)) continue;
            obsoleteNames.add(name);
        }
        for (String name : obsoleteNames) {
            FileUtilities.silentDeleteDirectory((File)new File(this.home, this.uniqueIds.get(name)));
            this.uniqueIds.remove(name);
        }
        UniqueIdService.saveIds(this.uniqueIds, (File)this.idFile);
    }

    public boolean hasPersitentStates() {
        return this.persitentStates.size() > 0;
    }

    public ArrayList<PersistentStateTestcaseFolder> getPersitentStates() {
        return this.persitentStates;
    }

    protected void delete() throws FilesNotDeletedException {
        File[] dirs;
        ArrayList<File> undeletedFiles = new ArrayList<File>();
        for (int i = this.getChildCount() - 1; i > -1; --i) {
            try {
                this.delete((TestcaseObject)this.getChild(i));
                continue;
            }
            catch (FilesNotDeletedException e) {
                undeletedFiles.addAll(e.getFiles());
            }
        }
        for (String dirName : this.uniqueIds.values()) {
            File dir = new File(this.home, dirName);
            try {
                FileUtilities.deleteDirectory((File)dir);
            }
            catch (FilesNotDeletedException e) {
                undeletedFiles.addAll(e.getFiles());
            }
        }
        if (!this.idFile.delete()) {
            undeletedFiles.add(this.idFile);
        }
        if ((dirs = FileUtilities.getAllDirectories((File)this.home)).length == 0) {
            try {
                FileUtilities.deleteDirectory((File)this.home);
            }
            catch (FilesNotDeletedException e) {
                undeletedFiles.addAll(e.getFiles());
            }
        }
        if (!undeletedFiles.isEmpty()) {
            throw new FilesNotDeletedException(undeletedFiles);
        }
    }

    public boolean rename(String newName) {
        File newHome = new File(this.home.getParentFile(), newName);
        this.getParent().getChildren().remove(this.getName());
        this.setName(newName);
        this.home = newHome;
        this.idFile = new File(newHome, this.idFile.getName());
        this.getParent().getChildren().put(newName, this);
        this.setChildrensHome(this, newHome);
        return true;
    }

    private void setChildrensHome(TestcaseContainer parent, File newHome) {
        for (Object o : parent.getChildren().values()) {
            if (o instanceof AbstractAsyncTestcaseFolder) {
                AbstractAsyncTestcaseFolder folder = (AbstractAsyncTestcaseFolder)((Object)o);
                folder.setHome(newHome);
                continue;
            }
            if (!(o instanceof TestcaseContainer)) continue;
            this.setChildrensHome((TestcaseContainer)o, newHome);
        }
    }

    private String createTestcaseFolder(Element element) throws TransformerException, IOException {
        AsynchronousTestcaseTemplate template = new AsynchronousTestcaseTemplate(element);
        String folderName = template.getLocation() + "/" + template.getFullQualifiedName();
        String uniqueId = this.uniqueIds.get(folderName);
        if (uniqueId == null) {
            uniqueId = UniqueIdService.createUniqueId((String)folderName, (String)("as_" + TraceTools.createPrefix((String)folderName)), this.uniqueIds);
        }
        File testcaseFolder = new File(this.home, uniqueId);
        testcaseFolder.mkdirs();
        template.write(new File(testcaseFolder, "template.xml"), element);
        this.loadTemplateEntries(template, testcaseFolder, new File(this.home, ".testcase.id"));
        return folderName;
    }

    private void loadChildren() {
        ArrayList<String> pathsToBeRemoved = new ArrayList<String>();
        for (String key : this.uniqueIds.keySet()) {
            File folder = new File(this.home, this.uniqueIds.get(key));
            if (folder.exists()) {
                File templateFile = new File(folder, "template.xml");
                File idFile = new File(folder, ".testcase.id");
                if (!templateFile.exists()) continue;
                this.loadTemplateEntries(new AsynchronousTestcaseTemplate(templateFile), folder, idFile);
                continue;
            }
            pathsToBeRemoved.add(key);
        }
        if (!pathsToBeRemoved.isEmpty()) {
            for (String path : pathsToBeRemoved) {
                this.uniqueIds.remove(path);
            }
            UniqueIdService.saveIds(this.uniqueIds, (File)this.idFile);
        }
    }

    private void loadTemplateEntries(AsynchronousTestcaseTemplate template, File folder, File idFile) {
        if (template.isPersistentState()) {
            try {
                PersistentStateTestcaseFolder testcaseFolder = new PersistentStateTestcaseFolder(template, folder, idFile);
                this.persitentStates.add(testcaseFolder);
                this.add((TestcaseObject)testcaseFolder);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else if (template.getService() != null) {
            TestcaseContainer service = this.getContainer(template.getService(), true, 3);
            this.add((TestcaseObject)service);
            String name = template.getAsynchronousClass();
            TestcaseContainer asyncClass = (TestcaseContainer)service.get(name);
            if (asyncClass == null) {
                asyncClass = new AsynchronousClass(name, template.getClassStereotype());
                service.add((TestcaseObject)asyncClass);
            }
            try {
                AsynchronousTestcaseFolder testcaseFolder = new AsynchronousTestcaseFolder(template, folder, idFile);
                asyncClass.add((TestcaseObject)testcaseFolder);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }
}

