/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.swing.tree;

import ch.e2e.builder.trace.testcase.uml.IOUmlObject;
import ch.e2e.builder.trace.testcase.uml.InspectionObject;
import ch.e2e.resource.ImageLoader;
import ch.e2e.resource.Properties;
import ch.e2e.swing.renderer.RendererPreferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreeCellRenderer;

public class TestcaseTreeRenderer
extends JPanel
implements TreeCellRenderer {
    private JLabel iconLabel;
    private JLabel nameLabel;
    private JLabel runtimeLabel;
    private JLabel inspectionLabel;
    private RendererPreferences preferences;
    private JPanel labelPanel;
    private Color unselectedBackground;
    private Color selectedBackground;
    private Color selectedBorder;
    private Color selectedForeground;
    private Color unselectedForeground;

    public TestcaseTreeRenderer(RendererPreferences preferences) {
        super(new BorderLayout());
        this.preferences = preferences;
        this.createGui(preferences.getProperties());
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        int type = this.preferences.getType(value);
        if (type != -1) {
            this.setIcon(type, leaf, expanded, selected);
            if (selected) {
                this.setSelectedColors(type, hasFocus);
            } else {
                this.setColor(type, leaf, expanded);
            }
        }
        if (value instanceof InspectionObject) {
            this.inspectionLabel.setVisible(((InspectionObject)value).isInspected());
        } else {
            this.inspectionLabel.setVisible(false);
        }
        if (value instanceof IOUmlObject) {
            this.runtimeLabel.setVisible(true);
            this.runtimeLabel.setText(" (" + ((IOUmlObject)value).getRuntime() + "ms)");
        } else {
            this.runtimeLabel.setVisible(false);
        }
        this.nameLabel.setText(this.preferences.toString(value));
        tree.setToolTipText(this.preferences.getTooltip(value));
        return this;
    }

    private void setIcon(int type, boolean leaf, boolean expanded, boolean selected) {
        Icon[] icons = this.preferences.getIcons(type, leaf, expanded, selected);
        if (icons[0] != null) {
            this.iconLabel.setIcon(icons[0]);
            this.iconLabel.setDisabledIcon(icons[1]);
        }
    }

    private void setColor(int type, boolean leaf, boolean expanded) {
        Color color = this.preferences.getColor(type, leaf, expanded);
        this.labelPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.labelPanel.setBackground(this.unselectedBackground);
        this.nameLabel.setBackground(this.unselectedBackground);
        this.inspectionLabel.setBackground(this.unselectedBackground);
        this.runtimeLabel.setBackground(this.unselectedBackground);
        if (color == null) {
            this.nameLabel.setForeground(this.unselectedForeground);
        } else {
            this.nameLabel.setForeground(color);
        }
        color = this.preferences.getColor(99999, leaf, expanded);
        this.runtimeLabel.setForeground(color);
    }

    private void setSelectedColors(int type, boolean hasFocus) {
        Color[] colors = this.preferences.getSelectedColors(type);
        if (colors[0] == null) {
            this.labelPanel.setBackground(this.selectedBackground);
            this.nameLabel.setBackground(this.selectedBackground);
            this.inspectionLabel.setBackground(this.selectedBackground);
        } else {
            this.labelPanel.setBackground(colors[0]);
            this.nameLabel.setBackground(colors[0]);
            this.inspectionLabel.setBackground(colors[0]);
        }
        if (colors[1] == null) {
            this.nameLabel.setForeground(this.selectedForeground);
        } else {
            this.nameLabel.setForeground(colors[1]);
        }
        colors = this.preferences.getSelectedColors(99999);
        if (colors[0] == null) {
            this.runtimeLabel.setBackground(this.selectedBackground);
        } else {
            this.runtimeLabel.setBackground(colors[0]);
        }
        if (colors[1] == null) {
            this.runtimeLabel.setForeground(this.selectedForeground);
        } else {
            this.runtimeLabel.setForeground(colors[1]);
        }
        if (hasFocus) {
            this.labelPanel.setBorder(new LineBorder(this.selectedBorder, 1));
        } else {
            this.labelPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
    }

    private void createGui(Properties properties) {
        this.unselectedForeground = UIManager.getColor("Tree.textForeground");
        this.unselectedBackground = UIManager.getColor("Tree.textBackground");
        this.selectedForeground = this.preferences.getDefaultSelectedForeground();
        if (this.selectedForeground == null) {
            this.selectedForeground = UIManager.getColor("Tree.selectionForeground");
        }
        this.selectedBackground = this.preferences.getDefaultSelectedBackground();
        if (this.selectedBackground == null) {
            this.selectedBackground = UIManager.getColor("Tree.selectionBackground");
        }
        this.selectedBorder = UIManager.getColor("Tree.selectionBorderColor");
        this.setBackground(this.unselectedBackground);
        this.setOpaque(true);
        this.labelPanel = new JPanel(new BorderLayout());
        this.labelPanel.setOpaque(true);
        this.iconLabel = this.createLabel("");
        this.iconLabel.setBackground(Color.WHITE);
        this.iconLabel.setBorder(new EmptyBorder(0, 0, 0, 3));
        this.nameLabel = this.createLabel("");
        this.runtimeLabel = this.createLabel("");
        this.inspectionLabel = this.createLabel("");
        this.inspectionLabel.setBorder(new EmptyBorder(0, 0, 0, 3));
        String iconName = properties.getString("testcase.tree.inspection.icon");
        this.inspectionLabel.setIcon(ImageLoader.loadIcon((String)iconName, (boolean)true));
        this.add((Component)this.iconLabel, "West");
        JPanel runtimeAndInspection = new JPanel(new BorderLayout());
        runtimeAndInspection.add((Component)this.inspectionLabel, "West");
        runtimeAndInspection.add((Component)this.nameLabel, "Center");
        runtimeAndInspection.add((Component)this.runtimeLabel, "East");
        this.labelPanel.add((Component)runtimeAndInspection, "Center");
        this.add((Component)this.labelPanel, "Center");
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setOpaque(true);
        return label;
    }
}

