/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.renderer;

import ch.e2e.swing.Tree;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.swing.renderer.CellRenderer;
import ch.e2e.swing.renderer.Logging;
import ch.e2e.swing.renderer.RendererPreferences;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class AbstractTreeCellRenderer
extends DefaultTreeCellEditor
implements TreeCellRenderer,
Logging {
    private AbstractTreeModel treeModel;
    private Object selectedNode;
    private RendererPreferences rendererPreferences;

    public AbstractTreeCellRenderer(Tree tree, AbstractTreeModel treeModel) {
        super(tree, new CellRenderer(new RendererPreferences(treeModel)));
        this.treeModel = treeModel;
        this.rendererPreferences = new RendererPreferences(treeModel);
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        value = this.treeModel.toString(value);
        Component editor = super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        this.editingIcon = this.rendererPreferences.getEditingIcon(value, expanded, leaf);
        return editor;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        try {
            return this.renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        catch (Exception ex) {
            System.out.println("caught exception in getTreeCellRendererComponent");
            ex.printStackTrace();
            return new JLabel(value.toString());
        }
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        boolean result = false;
        if (super.isCellEditable(event)) {
            MouseEvent e;
            TreePath path;
            if (event instanceof MouseEvent && (path = this.tree.getPathForLocation((e = (MouseEvent)event).getX(), e.getY())) != null) {
                this.selectedNode = path.getLastPathComponent();
            }
            if (this.treeModel.isEditable(this.selectedNode)) {
                result = true;
            }
        }
        return result;
    }
}

