/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.util.StringTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class MultiLineLabel
extends JComponent {
    private String separator;
    private ArrayList labels = new ArrayList();
    private int horizontalAlignment = 0;
    private int verticalAlignment = 0;
    private List lines = new ArrayList();
    private int maximumLineWidth = 700;
    private int lineHeight;
    private Insets borderInsets;
    private Dimension preferredSize = new Dimension();

    public MultiLineLabel(String text) {
        this(text, "\n", 700);
    }

    public MultiLineLabel(String text, String separator) {
        this(text, separator, 700);
    }

    public MultiLineLabel(String text, String separator, int maximumLineWidth) {
        this.setSeparator(separator);
        this.maximumLineWidth = maximumLineWidth;
        this.lines = StringTools.splitString((String)text, (String)separator);
    }

    public MultiLineLabel(String[] lines) {
        this.setText(lines);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.checkLineLengths();
        this.buildGrid();
        this.createPreferredSize();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.labels != null) {
            for (Object label : this.labels) {
                ((JLabel)label).setFont(font);
            }
            this.invalidate();
            this.validate();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int height = this.preferredSize.height * this.labels.size();
        if (this.borderInsets != null) {
            height += this.borderInsets.top + this.borderInsets.bottom;
        }
        return new Dimension(this.preferredSize.width, height);
    }

    @Override
    public void setSize(int width, int height) {
        this.checkMaximumLineWidth(width);
        super.setSize(width, height);
    }

    @Override
    public void setSize(Dimension d) {
        int width = d.width;
        this.checkMaximumLineWidth(width);
        super.setSize(d);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.checkMaximumLineWidth(width);
        super.setBounds(x, y, width, height);
    }

    @Override
    public void setBounds(Rectangle r) {
        int width = r.width;
        this.checkMaximumLineWidth(width);
        super.setBounds(r);
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.borderInsets = this.getBorder().getBorderInsets(this);
    }

    private void checkMaximumLineWidth(int width) {
        if (this.lines != null && this.lines.size() > 0 && (width = this.borderInsets == null ? Math.max(width - 10, 0) : width - this.borderInsets.left - this.borderInsets.right - 10) != this.maximumLineWidth) {
            this.setMaximumLineWidth(width);
        }
    }

    public void setText(String[] lines) {
        this.lines.clear();
        for (int i = 0; i < lines.length; ++i) {
            this.lines.add(lines[i]);
        }
        this.rebuildGui();
    }

    private void rebuildGui() {
        if (this.getFont() != null) {
            this.checkLineLengths();
            this.buildGrid();
            this.createPreferredSize();
            this.invalidate();
            this.validate();
            this.doLayout();
        }
    }

    public void setText(String text) {
        text = text == null ? "" : text;
        this.lines = StringTools.splitString((String)text, (String)this.separator);
        this.rebuildGui();
    }

    public String getText() {
        StringBuffer text = new StringBuffer();
        if (this.lines.size() > 0) {
            text.append(this.lines.get(0));
            for (int i = 1; i < this.lines.size(); ++i) {
                text.append(this.separator).append(this.lines.get(i));
            }
        }
        return text.toString();
    }

    public String[] getTextArray() {
        String[] text = new String[this.labels.size()];
        for (int i = 0; i < this.labels.size(); ++i) {
            text[i] = ((JLabel)this.labels.get(i)).getText();
        }
        return text;
    }

    public void setSeparator(String separator) {
        if (separator == null || separator.equals("")) {
            separator = "\n";
        }
        this.separator = separator;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        Iterator it = this.labels.iterator();
        this.horizontalAlignment = horizontalAlignment;
        while (it.hasNext()) {
            ((JLabel)it.next()).setHorizontalAlignment(horizontalAlignment);
        }
    }

    public void setVerticalAlignment(int verticalAlignment) {
        Iterator it = this.labels.iterator();
        this.verticalAlignment = verticalAlignment;
        while (it.hasNext()) {
            ((JLabel)it.next()).setVerticalAlignment(verticalAlignment);
        }
    }

    @Override
    public void setBackground(Color background) {
        super.setBackground(background);
        if (this.labels != null) {
            Iterator it = this.labels.iterator();
            while (it.hasNext()) {
                ((JLabel)it.next()).setBackground(background);
            }
        }
    }

    @Override
    public void setForeground(Color foreground) {
        super.setForeground(foreground);
        if (this.labels != null) {
            Iterator it = this.labels.iterator();
            while (it.hasNext()) {
                ((JLabel)it.next()).setForeground(foreground);
            }
        }
    }

    @Override
    public void setOpaque(boolean opaque) {
        super.setOpaque(opaque);
        if (this.labels != null) {
            Iterator it = this.labels.iterator();
            while (it.hasNext()) {
                ((JLabel)it.next()).setOpaque(opaque);
            }
        }
    }

    public int getMaximumLineWidth() {
        return this.maximumLineWidth;
    }

    public void setMaximumLineWidth(int maximumLineWidth) {
        this.maximumLineWidth = maximumLineWidth;
        this.checkLineLengths();
        this.buildGrid();
    }

    public void setLineHeight(int lineHeight) {
        this.lineHeight = lineHeight;
    }

    private void buildGrid() {
        this.removeAll();
        if (this.labels.size() > 0) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.anchor = 18;
            c.fill = 2;
            c.gridwidth = 0;
            int length = this.labels.size() - 1;
            for (int i = 0; i < length; ++i) {
                this.add((Component)((JLabel)this.labels.get(i)), c);
            }
            c.weighty = 1.0;
            this.add((Component)((JLabel)this.labels.get(length)), c);
        }
        this.invalidate();
        this.validate();
    }

    private void createPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int width = 0;
        int length = this.lines.size();
        for (int i = 0; i < length; ++i) {
            String s = (String)this.lines.get(i);
            width = Math.max(width, fm.stringWidth(s) + 10);
        }
        this.preferredSize = new Dimension(width, fm.getHeight() + 2);
    }

    private void checkLineLengths() {
        int i;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int borderOffset = this.lineHeight > fm.getHeight() ? (this.lineHeight - fm.getHeight()) / 2 : 0;
        EmptyBorder labelBorder = new EmptyBorder(borderOffset, 0, borderOffset, 0);
        String[][] linesArray = new String[this.lines.size()][];
        for (i = 0; i < this.lines.size(); ++i) {
            linesArray[i] = this.checkLine((String)this.lines.get(i), fm);
        }
        this.labels.clear();
        for (i = 0; i < linesArray.length; ++i) {
            for (int j = 0; j < linesArray[i].length; ++j) {
                JLabel l = new JLabel(linesArray[i][j], this.horizontalAlignment);
                this.labels.add(l);
                l.setForeground(this.getForeground());
                l.setBackground(this.getBackground());
                l.setFont(this.getFont());
                l.setBorder(labelBorder);
                l.setVerticalAlignment(this.verticalAlignment);
            }
        }
    }

    private String[] checkLine(String line, FontMetrics fm) {
        int stringWidth = fm.stringWidth(line);
        if (stringWidth > this.maximumLineWidth) {
            ArrayList<String> lineStrings = new ArrayList<String>();
            Iterator tokens = StringTools.splitString((String)line, (String)" ").iterator();
            StringBuffer string = new StringBuffer();
            while (tokens.hasNext()) {
                String buffer = (String)tokens.next();
                int width = string.length() > 0 ? fm.stringWidth(string.toString() + ' ' + buffer) : fm.stringWidth(buffer);
                if (width < this.maximumLineWidth) {
                    if (string.length() == 0) {
                        string.append(buffer);
                        continue;
                    }
                    string.append(' ').append(buffer);
                    continue;
                }
                if (string.length() == 0) {
                    string.append(buffer);
                    lineStrings.add(string.toString());
                    string = new StringBuffer();
                    continue;
                }
                lineStrings.add(string.toString());
                string = new StringBuffer(buffer);
            }
            if (string.length() > 0) {
                lineStrings.add(string.toString());
            }
            String[] lines = new String[lineStrings.size()];
            lineStrings.toArray(lines);
            return lines;
        }
        return new String[]{line};
    }
}

