/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.print;

import ch.e2e.print.TextPanePrintView;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JTextPane;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.View;

public class TextPanePrinter
implements Printable {
    private static TextPanePrinter printer = new TextPanePrinter();
    private Document document;
    private TextPanePrintView printView;
    private JTextPane textPane;

    private TextPanePrinter() {
    }

    public static Printable getTextPanePrinter(JTextPane textPane) {
        TextPanePrinter.printer.textPane = textPane;
        TextPanePrinter.printer.document = textPane.getDocument();
        return printer;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        int pageWidth = (int)pageFormat.getImageableWidth() - (int)pageFormat.getImageableX();
        int pageHeight = (int)pageFormat.getImageableHeight() - (int)pageFormat.getImageableY();
        graphics.setClip(0, 0, pageWidth, pageHeight);
        if (this.printView == null) {
            BasicTextUI btui = (BasicTextUI)this.textPane.getUI();
            View root = btui.getRootView(this.textPane);
            this.printView = new TextPanePrintView(this.document.getDefaultRootElement(), root, pageWidth, pageHeight);
        }
        boolean pageExists = this.printView.paintPage(graphics, pageHeight, pageIndex);
        System.gc();
        if (pageExists) {
            return 0;
        }
        this.printView = null;
        this.textPane.setDocument(new DefaultStyledDocument());
        this.textPane.setDocument(this.document);
        return 1;
    }
}

