/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.StringTokenizer;
import java.util.Vector;

public class MultiLineLabel
extends Canvas {
    private Dimension size = new Dimension(0, 0);
    private int maximumWidth = 400;
    private String text;
    private int alignment = 1;
    private Image image;

    public MultiLineLabel(String text) {
        this.text = text;
    }

    public MultiLineLabel(String text, int maximumWidth) {
        this.text = text;
        this.maximumWidth = maximumWidth;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.createGui();
    }

    @Override
    public void paint(Graphics g) {
        int xPos = (this.getSize().width - this.size.width) / 2;
        int yPos = (this.getSize().height - this.size.height) / 2;
        g.drawImage(this.image, xPos, yPos, this);
    }

    public void setText(String text) {
        this.text = text;
        this.createGui();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    private void createGui() {
        if (this.getFont() != null) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            String[] lines = this.checkLineLengths(this.createLines(), fm);
            int width = this.getWidth(lines, fm);
            int height = lines.length * fm.getHeight() + 10;
            this.size = new Dimension(width, height);
            this.image = this.createImage(width, height);
            if (this.image != null) {
                Graphics g = this.image.getGraphics();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, width, height);
                g.setColor(this.getForeground());
                switch (this.alignment) {
                    case 0: {
                        this.drawLeftAlignedStrings(lines, g, fm);
                        break;
                    }
                    case 2: {
                        this.drawRightAlignedStrings(lines, g, fm);
                        break;
                    }
                    case 1: {
                        this.drawCenterAlignedStrings(lines, g, fm);
                    }
                }
            }
        }
    }

    private String[] checkLineLengths(String[] originLines, FontMetrics fm) {
        String[][] linesArray = new String[originLines.length][];
        int lineCount = 0;
        for (int i = 0; i < linesArray.length; ++i) {
            linesArray[i] = this.getSizedLines(originLines[i], fm, this.maximumWidth);
            lineCount += linesArray[i].length;
        }
        String[] lines = new String[lineCount];
        lineCount = 0;
        for (int i = 0; i < linesArray.length; ++i) {
            for (int j = 0; j < linesArray[i].length; ++j) {
                lines[lineCount++] = linesArray[i][j];
            }
        }
        return lines;
    }

    private String[] createLines() {
        Vector<String> lineVector = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.text, "\n", true);
        boolean ignoreSeparator = false;
        while (tokenizer.hasMoreElements()) {
            String line = tokenizer.nextToken();
            if (line.length() == 1 && line.charAt(0) == '\n') {
                if (!ignoreSeparator) {
                    line = "";
                } else {
                    ignoreSeparator = false;
                    continue;
                }
            }
            if (line.length() > 0) {
                ignoreSeparator = true;
            }
            lineVector.addElement(line);
        }
        Object[] lines = new String[lineVector.size()];
        lineVector.copyInto(lines);
        return lines;
    }

    private int getWidth(String[] lines, FontMetrics fm) {
        int width = 0;
        for (int i = 0; i < lines.length; ++i) {
            int dummy = fm.stringWidth(lines[i]);
            if (dummy <= width) continue;
            width = dummy;
        }
        return width + 10;
    }

    private void drawLeftAlignedStrings(String[] lines, Graphics g, FontMetrics fm) {
        int lineHeight = fm.getHeight();
        for (int i = 0; i < lines.length; ++i) {
            g.drawString(lines[i], 5, lineHeight * (i + 1));
        }
    }

    private void drawRightAlignedStrings(String[] lines, Graphics g, FontMetrics fm) {
        int lineHeight = fm.getHeight();
        for (int i = 0; i < lines.length; ++i) {
            int xPos = this.size.width - 5 - fm.stringWidth(lines[i]);
            g.drawString(lines[i], xPos, 5 + lineHeight * (i + 1));
        }
    }

    private void drawCenterAlignedStrings(String[] lines, Graphics g, FontMetrics fm) {
        int lineHeight = fm.getHeight();
        for (int i = 0; i < lines.length; ++i) {
            int xPos = (this.size.width - fm.stringWidth(lines[i])) / 2;
            g.drawString(lines[i], xPos, 5 + lineHeight * (i + 1));
        }
    }

    private String[] getSizedLines(String line, FontMetrics fm, int maximumLineWidth) {
        int stringWidth = fm.stringWidth(line);
        if (stringWidth > maximumLineWidth) {
            int lines = stringWidth / maximumLineWidth;
            if (stringWidth % maximumLineWidth != 0) {
                ++lines;
            }
            int average = stringWidth / lines;
            String[] lineStrings = new String[lines];
            for (int i = 0; i < lines; ++i) {
                lineStrings[i] = "";
            }
            StringTokenizer tokenizer = new StringTokenizer(line, " ");
            int i = 0;
            String buffer = "";
            while (tokenizer.hasMoreTokens()) {
                String nextToken = tokenizer.nextToken();
                if (buffer.length() > 0) {
                    buffer = buffer + " ";
                }
                buffer = buffer + nextToken;
                if (fm.stringWidth(lineStrings[i]) > average) {
                    buffer = nextToken;
                    ++i;
                }
                lineStrings[i] = buffer;
            }
            return lineStrings;
        }
        return new String[]{line};
    }
}

