/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.testsuite;

import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.regtest.event.LibraryChangedEvent;
import ch.e2e.builder.regtest.event.LibraryObserver;
import ch.e2e.builder.regtest.testsuite.ImportTestcaseContainer;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.LibraryChildSuite;
import ch.e2e.builder.regtest.testsuite.Testcase;
import ch.e2e.builder.regtest.testsuite.TraceTestcase;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.FilesNotDeletedException;
import ch.e2e.test.E2ETestSuite;
import ch.e2e.test.E2ETestSuiteTemplate;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.Testable;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;

public class Library
extends TreeTestSuite
implements Comparable<Library> {
    public Library(String name, LibrariesRoot libraries) throws Exception {
        super(name, true);
        this.setTreeParent(libraries);
        File testSuiteFile = new File(LibrariesRoot.getLibrariesFolder(), name);
        testSuiteFile = new File(testSuiteFile, "library.xml");
        this.setTestSuiteFile(testSuiteFile);
        this.serializeTestSuiteDocument(this.createTestSuiteDocument(name), testSuiteFile);
    }

    public Library(Document document, File testSuiteFile) throws Exception {
        super(document, testSuiteFile);
        this.getProperties().put("project.folder", E2EBuilderProject.getProjectFolderName());
        this.getProperties().put("library.output.folder", this.createLibraryOutputPath());
    }

    public Library(E2ETestSuiteTemplate template, E2ETestSuite parent, boolean inLibrary) throws Exception {
        super(template, parent, inLibrary);
        this.getProperties().put("project.folder", E2EBuilderProject.getProjectFolderName());
        this.getProperties().put("library.output.folder", this.createLibraryOutputPath());
    }

    protected Library(Document document, File testSuiteFile, E2ETestSuite parent, boolean inLibrary) throws Exception {
        super(document, testSuiteFile, parent, inLibrary);
    }

    Library(String name, boolean library) {
        super(name, library);
    }

    Library(ImportTestcaseContainer testcaseContainer, File testSuiteFile, TreeTestSuite parent) throws Exception {
        super(testcaseContainer, testSuiteFile, parent);
    }

    public Library getLibrary() {
        return this;
    }

    public boolean isLibrary() {
        return true;
    }

    public boolean isInLibrary() {
        return false;
    }

    public LibraryChildSuite createChildSuite(String name) {
        return new LibraryChildSuite(name, this);
    }

    @Override
    public void insertTestcase(Testcase testcase, int index) throws Exception {
        super.insertTestcase(testcase, index);
        this.fireLibraryChanged(this);
    }

    @Override
    public void importTestcase(TraceTestcase traceTestcase, int index, boolean overrideReferenceData) throws Exception {
        super.importTestcase(traceTestcase, index, overrideReferenceData);
        this.fireLibraryChanged(this);
    }

    @Override
    public void removeTestcase(Testcase test) {
        super.removeTestcase(test);
        this.fireLibraryChanged(this);
    }

    @Override
    public void move(Testable test, int index) {
        super.move(test, index);
        this.fireLibraryChanged(this);
    }

    @Override
    public TreeTestSuite createNewTestsuite(String name, int index) throws Exception {
        TreeTestSuite result = super.createNewTestsuite(name, index);
        this.fireLibraryChanged(this);
        return result;
    }

    @Override
    protected TreeTestSuite createNewTestSuite(String name) {
        return new LibraryChildSuite(name, this);
    }

    @Override
    protected TreeTestSuite createTestSuite(ImportTestcaseContainer testcaseContainer, File testSuiteFile) throws Exception {
        return new LibraryChildSuite(testcaseContainer, testSuiteFile, this, (TreeTestSuite)this);
    }

    @Override
    public void insertTestSuite(TreeTestSuite testSuite, int index) throws Exception {
        super.insertTestSuite(testSuite, index);
        this.fireLibraryChanged(this);
    }

    @Override
    public void removeTestSuite(TreeTestSuite test) {
        super.removeTestSuite(test);
        this.fireLibraryChanged(this);
    }

    @Override
    public TreeTestSuite importTestSuite(ImportTestcaseContainer testcaseContainer, int index, boolean overrideReferenceData) throws Exception {
        TreeTestSuite result = super.importTestSuite(testcaseContainer, index, overrideReferenceData);
        this.fireLibraryChanged(this);
        return result;
    }

    @Override
    public boolean rename(String newName) {
        LibraryChangedEvent event = new LibraryChangedEvent(this, this);
        event.setOldId(this.getId());
        boolean result = super.rename(newName);
        if (result) {
            this.fireRenameEvent(event);
        }
        return result;
    }

    @Override
    public void persist(Testcase testcase, String oldName) {
        super.persist(testcase, oldName);
        this.fireLibraryChanged(this);
    }

    @Override
    public void persistOptions(OptionContainer options) throws Exception {
        super.persistOptions(options);
        this.fireLibraryChanged(this);
    }

    @Override
    public void removeOptions(OptionContainer options) throws Exception {
        super.removeOptions(options);
        this.fireLibraryChanged(this);
    }

    @Override
    public void persist() throws TransformerException, IOException, XPathExpressionException {
        super.persist();
        this.fireLibraryChanged(this);
    }

    public void persistNoNotification() throws TransformerException, IOException, XPathExpressionException {
        super.persist();
    }

    @Override
    public void deleteTestcase(Testcase test) {
        super.deleteTestcase(test);
        LibraryChangedEvent event = new LibraryChangedEvent(this, this);
        String testPath = test.getFullQualifiedName();
        if (testPath.startsWith("libraries/")) {
            testPath = testPath.substring(10);
        }
        event.setTestPath(testPath);
        this.fireTestRemovedEvent(event);
    }

    @Override
    public void deleteTestSuite(TreeTestSuite test) {
        super.deleteTestSuite(test);
        this.fireLibraryChanged(this);
    }

    public void delete() {
        try {
            FileUtilities.deleteDirectory((File)this.getTestSuiteFile().getParentFile());
        }
        catch (FilesNotDeletedException e) {
            System.err.print("Unable to delete directory '" + this.getTestSuiteFile().getParentFile() + "'.");
        }
        this.deleteInternal(this);
        this.fireLibraryChanged(this);
    }

    private void deleteInternal(TreeTestSuite testSuite) {
        for (Testable testable : testSuite.getTestcases()) {
            if (testable instanceof TreeTestSuite) {
                this.deleteInternal((TreeTestSuite)testable);
                continue;
            }
            if (!(testable instanceof Testcase) || ((Testcase)testable).getTest() == null) continue;
            ((Testcase)testable).getTest().removeReferenceAndSource();
        }
    }

    protected void fireRenameEvent(LibraryChangedEvent event) {
        LibraryObserver.getInstance().nameChanged(event);
    }

    protected void fireTestRemovedEvent(LibraryChangedEvent event) {
        LibraryObserver.getInstance().testRemoved(event);
    }

    @Override
    public LibraryChildSuite createTestSuite(E2ETestSuiteTemplate template, boolean inLibrary) throws Exception {
        return new LibraryChildSuite(template, this, (TreeTestSuite)this);
    }

    protected void fireLibraryChanged(TreeTestSuite changedTestSuite) {
        LibraryChangedEvent event = new LibraryChangedEvent(this, this);
        String testPath = changedTestSuite.getPath();
        testPath = testPath.replace("libraries/", "");
        event.setTestPath(testPath);
        LibraryObserver.getInstance().libraryChanged(event);
    }

    @Override
    protected String createPath() {
        return "libraries/" + super.createPath();
    }

    @Override
    public int compareTo(Library o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }
}

