/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.axiom;

import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.option.axiom.AxiomParentNodeWrapper;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.PrependAxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.UntypedAtomicValue;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;

public class AxiomAttributeWrapper
implements NodeInfo,
VirtualNode,
SiblingCountingNode {
    protected OMAttribute node;
    private AxiomParentNodeWrapper parent;
    protected int index;

    protected AxiomAttributeWrapper(OMAttribute node, AxiomParentNodeWrapper parent, int index) {
        this.node = node;
        this.parent = parent;
        this.index = index;
    }

    @Override
    public TreeInfo getTreeInfo() {
        return this.parent.getTreeInfo();
    }

    @Override
    public Configuration getConfiguration() {
        return this.parent.getConfiguration();
    }

    public OMAttribute getUnderlyingNode() {
        return this.node;
    }

    public OMAttribute getRealNode() {
        return this.getUnderlyingNode();
    }

    @Override
    public int getFingerprint() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasFingerprint() {
        return false;
    }

    @Override
    public int getNodeKind() {
        return 2;
    }

    @Override
    public AtomicSequence atomize() {
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    @Override
    public SchemaType getSchemaType() {
        return BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof AxiomAttributeWrapper && this.node == ((AxiomAttributeWrapper)other).node;
    }

    @Override
    public int hashCode() {
        return this.node.hashCode();
    }

    @Override
    public String getSystemId() {
        return this.parent.getBaseURI();
    }

    @Override
    public void setSystemId(String uri) {
    }

    @Override
    public String getBaseURI() {
        return this.getParent().getBaseURI();
    }

    @Override
    public Location saveLocation() {
        return this;
    }

    @Override
    public int compareOrder(NodeInfo other) {
        if (other instanceof AxiomAttributeWrapper) {
            AxiomAttributeWrapper otherAtt = (AxiomAttributeWrapper)other;
            if (this.node == otherAtt.node) {
                return 0;
            }
            if (this.parent.equals(otherAtt.parent)) {
                return this.getSiblingPosition() > otherAtt.getSiblingPosition() ? 1 : -1;
            }
            return this.parent.compareOrder(otherAtt.parent);
        }
        if (other.getNodeKind() == 13 && this.parent.equals(other.getParent())) {
            return 1;
        }
        if (other.equals(this.parent)) {
            return 1;
        }
        return this.parent.compareOrder(other);
    }

    @Override
    public String getStringValue() {
        return this.node.getAttributeValue();
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.node.getAttributeValue();
    }

    @Override
    public String getLocalPart() {
        return this.node.getLocalName();
    }

    @Override
    public String getPrefix() {
        String prefix = this.node.getPrefix();
        return prefix == null ? "" : prefix;
    }

    @Override
    public String getURI() {
        String uri = this.node.getNamespaceURI();
        return uri == null ? "" : uri;
    }

    @Override
    public String getDisplayName() {
        String prefix = this.getPrefix();
        String local = this.getLocalPart();
        if (prefix.isEmpty()) {
            return local;
        }
        return prefix + ":" + local;
    }

    @Override
    public NodeInfo getParent() {
        return this.parent;
    }

    @Override
    public int getSiblingPosition() {
        if (this.index == -1) {
            OMElement elem = this.node.getOwner();
            int ix = 0;
            Iterator iter = elem.getAllAttributes();
            while (iter.hasNext()) {
                if (iter.next() == this.node) {
                    this.index = ix;
                    return this.index;
                }
                ++ix;
            }
            throw new IllegalStateException("parent/attribute mismatch");
        }
        return this.index;
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 0: {
                return this.parent.iterateAxis((byte)1, nodeTest);
            }
            case 1: {
                if (nodeTest.matchesNode(this)) {
                    return new PrependAxisIterator(this, this.parent.iterateAxis((byte)1, nodeTest));
                }
                return this.parent.iterateAxis((byte)1, nodeTest);
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
            case 6: {
                return new Navigator.AxisFilter(new Navigator.FollowingEnumeration(this), nodeTest);
            }
            case 9: {
                return Navigator.filteredSingleton(this.parent, nodeTest);
            }
            case 10: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, false), nodeTest);
            }
            case 5: 
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, true), nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    @Override
    public String getAttributeValue(String uri, String local) {
        return null;
    }

    @Override
    public NodeInfo getRoot() {
        return this.parent.getRoot();
    }

    @Override
    public boolean hasChildNodes() {
        return this.node instanceof OMContainer && ((OMContainer)this.node).getFirstOMChild() != null;
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        Navigator.appendSequentialKey(this, buffer, true);
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return null;
    }

    @Override
    public boolean isId() {
        return "ID".equals(this.node.getAttributeType());
    }

    @Override
    public boolean isIdref() {
        String type = this.node.getAttributeType();
        return "IDREF".equals(type) || "IDREFS".equals(type);
    }
}

