/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn.style;

import com.saxonica.xsltextn.instruct.DeepUpdate;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;

public class SaxonDeepUpdate
extends StyleElement {
    private Expression root;
    private Expression select;
    private Expression action;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("root")) {
                String rootAtt = atts.getValue(a);
                this.root = this.makeExpression(rootAtt, a);
                continue;
            }
            if (f.equals("select")) {
                String selectAtt = atts.getValue(a);
                this.select = this.makeExpression(selectAtt, a);
                continue;
            }
            if (f.equals("action")) {
                String actionAtt = atts.getValue(a);
                this.action = this.makeExpression(actionAtt, a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (this.root == null) {
            this.reportAbsence("root");
        }
        if (this.select == null) {
            this.reportAbsence("select");
        }
        if (this.action == null) {
            this.reportAbsence("action");
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.getConfiguration().checkLicensedFeature(8, "saxon:deep-update", this.getPackageData().getLocalLicenseId());
        this.root = this.typeCheck("root", this.root);
        this.select = this.typeCheck("select", this.select);
        this.action = this.typeCheck("action", this.action);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        return new DeepUpdate(this.root, this.select, this.action);
    }
}

