/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TreeObject;
import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.Branches;
import ch.e2e.builder.trace.testcase.uml.DoAction;
import ch.e2e.builder.trace.testcase.uml.Error;
import ch.e2e.builder.trace.testcase.uml.ErrorContainer;
import ch.e2e.builder.trace.testcase.uml.Flow;
import ch.e2e.builder.trace.testcase.uml.ParentState;
import ch.e2e.builder.trace.testcase.uml.Postprocessor;
import ch.e2e.builder.trace.testcase.uml.Preprocessor;
import ch.e2e.builder.trace.testcase.uml.Processor;
import ch.e2e.builder.trace.testcase.uml.RootObject;
import ch.e2e.builder.trace.testcase.uml.State;
import ch.e2e.builder.trace.testcase.uml.StateTransition;
import ch.e2e.builder.trace.testcase.uml.TraceError;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.trace.testcase.uml.UmlObjectFactory;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UmlTree
extends UmlObject {
    Map<String, ParentState> parentStates;
    ErrorContainer errorContainer = null;
    private boolean traceError;
    private Testcase owner;

    public UmlTree(File traceFolder) throws IOException, ParserConfigurationException, SAXException {
        super("ROOT");
        File traceErrors;
        File postProcessor;
        File mainDiagram;
        File preProcessor = new File(traceFolder, "preprocessor.xml");
        if (preProcessor.exists()) {
            Document document = DomUtilities.parse((File)preProcessor, (boolean)false, (boolean)false);
            this.addChild(new Preprocessor(document.getDocumentElement(), traceFolder));
        }
        if ((mainDiagram = new File(traceFolder, "main.activity.xml")).exists()) {
            Document document = DomUtilities.parse((File)mainDiagram, (boolean)false, (boolean)false);
            this.addChild(new RootObject(document.getDocumentElement(), traceFolder));
        }
        if ((postProcessor = new File(traceFolder, "postprocessor.xml")).exists()) {
            Document document = DomUtilities.parse((File)postProcessor, (boolean)false, (boolean)false);
            this.addChild(new Postprocessor(document.getDocumentElement(), traceFolder));
        }
        if ((traceErrors = new File(traceFolder, "trace.errors")).exists()) {
            this.addTraceErrors(DomUtilities.parse((File)traceErrors, (boolean)false, (boolean)false), traceFolder);
        }
    }

    public UmlTree(Element element, TraceContainer traceContainer) {
        super(element, traceContainer);
    }

    public UmlTree(Element element, File traceFolder) {
        super(element, traceFolder);
    }

    public Testcase getOwner() {
        return this.owner;
    }

    public void setOwner(Testcase owner) {
        this.owner = owner;
    }

    public boolean hasTraceError() {
        return this.traceError;
    }

    public TraceError getTraceError() {
        TraceError result = null;
        int length = this.getChildCount();
        for (int i = 0; i < length; ++i) {
            if (!(this.getChild(i) instanceof TraceError)) continue;
            result = (TraceError)this.getChild(i);
        }
        return result;
    }

    @Override
    public void addChild(UmlObject child) {
        if (child instanceof Error) {
            this.addChild((Error)child);
        } else {
            if (child instanceof TraceError) {
                this.traceError = true;
            } else if (child instanceof Processor) {
                Flow flow = ((Processor)child).getRealFlow();
                for (int i = 0; i < flow.getChildCount(); ++i) {
                    child.addChild((UmlObject)flow.getChild(i));
                }
            }
            super.addChild(child);
        }
    }

    private void addChild(Error error) {
        this.getErrorContainer().addChild(error);
    }

    private ErrorContainer getErrorContainer() {
        if (this.errorContainer == null) {
            this.errorContainer = new ErrorContainer();
            this.addChild(this.errorContainer);
        }
        return this.errorContainer;
    }

    @Override
    protected void addChild(Element child, File documentFolder) {
        String nodeName = child.getNodeName();
        if (!nodeName.equals("stateTransition") || child.getElementsByTagName("parentState").getLength() == 0) {
            super.addChild(child, documentFolder);
        }
    }

    @Override
    protected void addChild(Element child, TraceContainer traceContainer) {
        String name = child.getNodeName();
        if (name.equals("genericFlow")) {
            super.addChild(traceContainer.createRootObject(child));
        } else if (name.equals("stateTransition")) {
            if (child.getElementsByTagName("parentState").getLength() == 0) {
                super.addChild(child, traceContainer);
            } else {
                if (this.parentStates == null) {
                    this.parentStates = new HashMap<String, ParentState>();
                }
                StateTransition transition = (StateTransition)UmlObjectFactory.createUmlObject(child, traceContainer);
                this.parentStates.put(transition.getTargetState().getOriginalName(), transition.getParentState());
            }
        } else if (name.equals("doAction")) {
            DoAction doAction = (DoAction)UmlObjectFactory.createUmlObject(child, traceContainer);
            ParentState parentState = this.parentStates == null ? null : this.parentStates.get(doAction.getState().getOriginalName());
            traceContainer.addElement(parentState, child);
            if (parentState == null) {
                super.addChild(doAction);
            }
        } else if (name.equals("branches")) {
            Branches branches = (Branches)UmlObjectFactory.createUmlObject(child, traceContainer);
            State state = branches.getState();
            if (state != null) {
                ParentState parentState = this.parentStates == null ? null : this.parentStates.get(state.getOriginalName());
                traceContainer.addElement(parentState, child);
                if (parentState == null) {
                    super.addChild(branches);
                }
            }
        } else {
            super.addChild(child, traceContainer);
        }
    }

    private void addTraceErrors(Document document, File documentFolder) {
        NodeList traceErrors = document.getDocumentElement().getChildNodes();
        int length = traceErrors.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = traceErrors.item(i);
            if (!(child instanceof Element)) continue;
            this.addChild((Element)child, documentFolder);
        }
    }

    @Override
    public TreeObject getTreeParent() {
        return this.getOwner();
    }

    public Iterator<UmlObject> getDepthFirstIterator() {
        return new PreorderIterator(this);
    }

    public Iterator<UmlObject> children(UmlObject root) {
        return new ChildIterator(root);
    }

    private static class EmptyIterator
    implements Iterator<UmlObject> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public UmlObject next() {
            throw new NoSuchElementException("No more elements");
        }

        @Override
        public void remove() {
        }
    }

    final class ChildIterator
    implements Iterator<UmlObject> {
        private UmlObject root;
        private int childCount;
        private int index;

        public ChildIterator(UmlObject root) {
            this.root = root;
            this.childCount = root.getChildCount();
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.childCount;
        }

        @Override
        public UmlObject next() {
            return (UmlObject)this.root.getChild(this.index++);
        }

        @Override
        public void remove() {
        }
    }

    final class PostorderIterator
    implements Iterator<UmlObject> {
        protected UmlObject root;
        protected Iterator<UmlObject> children;
        protected Iterator<UmlObject> subtree;

        public PostorderIterator(UmlObject root) {
            this.root = root;
            this.children = UmlTree.this.children(root);
            this.subtree = new EmptyIterator();
        }

        @Override
        public boolean hasNext() {
            return this.root != null;
        }

        @Override
        public UmlObject next() {
            UmlObject retval;
            if (this.subtree.hasNext()) {
                retval = this.subtree.next();
            } else if (this.children.hasNext()) {
                this.subtree = new PostorderIterator(this.children.next());
                retval = this.subtree.next();
            } else {
                retval = this.root;
                this.root = null;
            }
            return retval;
        }

        @Override
        public void remove() {
        }
    }

    final class PreorderIterator
    implements Iterator<UmlObject> {
        protected Stack<Iterator<UmlObject>> stack;

        public PreorderIterator(UmlObject root) {
            ArrayList<UmlObject> list = new ArrayList<UmlObject>(1);
            list.add(root);
            this.stack = new Stack();
            this.stack.push(list.iterator());
        }

        @Override
        public boolean hasNext() {
            return !this.stack.empty() && this.stack.peek().hasNext();
        }

        @Override
        public UmlObject next() {
            Iterator<UmlObject> iterator = this.stack.peek();
            UmlObject node = iterator.next();
            Iterator<UmlObject> children = UmlTree.this.children(node);
            if (!iterator.hasNext()) {
                this.stack.pop();
            }
            if (children.hasNext()) {
                this.stack.push(children);
            }
            return node;
        }

        @Override
        public void remove() {
        }
    }
}

