/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.Event;
import ch.e2e.builder.trace.testcase.uml.IOUmlObject;
import ch.e2e.builder.trace.testcase.uml.ParentState;
import ch.e2e.builder.trace.testcase.uml.SourceStateParent;
import ch.e2e.builder.trace.testcase.uml.State;
import ch.e2e.builder.trace.testcase.uml.TargetState;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.trace.testcase.uml.UmlObjectFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class StateTransition
extends IOUmlObject {
    private static final Pattern PREFIXES_TO_REMOVE = Pattern.compile("^(\\QNESTED \\E)");

    public StateTransition(Element element, File documentFolder) {
        super(element, documentFolder);
        this.name = PREFIXES_TO_REMOVE.matcher(this.name).replaceFirst("");
    }

    public StateTransition(Element element, TraceContainer traceContainer) {
        super(element, traceContainer);
        traceContainer.addElement(this.getParentState(), element);
        this.name = PREFIXES_TO_REMOVE.matcher(this.name).replaceFirst("");
    }

    public StateTransition(String name) {
        super(PREFIXES_TO_REMOVE.matcher(name).replaceFirst(""));
    }

    @Override
    protected void addChild(Element child, File documentFolder) {
        String nodeName = child.getNodeName();
        if (!nodeName.equals("timestamp")) {
            if (nodeName.equals("parentState") || nodeName.equals("sourceStateParent") || nodeName.equals("targetStateParent")) {
                UmlObject obj = UmlObjectFactory.createUmlObject(child, documentFolder);
                super.addChild(obj);
            } else if (nodeName.equals("sourceState") || nodeName.equals("targetState")) {
                UmlObject obj = UmlObjectFactory.createUmlObject(child, documentFolder);
                if (obj instanceof State) {
                    File oldDiagramFile = new File(documentFolder, obj.getFilename());
                    File diagramFile = new File(documentFolder, obj.getFilename() + ".xml");
                    if (oldDiagramFile.exists()) {
                        oldDiagramFile.renameTo(diagramFile);
                    }
                    if (diagramFile.exists()) {
                        UmlObject stateDiagram = UmlObjectFactory.createUmlObject(diagramFile);
                        for (int i = 0; i < stateDiagram.getChildCount(); ++i) {
                            UmlObject childs = (UmlObject)stateDiagram.getChild(i);
                            obj.addChild(childs);
                        }
                    }
                }
                super.addChild(obj);
            } else {
                super.addChild(child, documentFolder);
            }
        }
    }

    @Override
    protected void addChild(Element child, TraceContainer traceContainer) {
        if (!child.getNodeName().equals("timestamp")) {
            super.addChild(child, traceContainer);
        }
    }

    @Override
    public int internalGetType() {
        return 10022;
    }

    @Override
    public String toString() {
        String name = this.getNameFromEvent();
        return name == null || name.length() == 0 ? super.toString() : name;
    }

    private String getNameFromEvent() {
        String name = null;
        Event event = this.findEvent();
        if (event != null && this.useEventName(event)) {
            name = event.toString();
        }
        return name;
    }

    private Event findEvent() {
        Event event = null;
        int childCount = this.getChildCount();
        for (int i = 0; event == null && i < childCount; ++i) {
            Object child = this.getChild(i);
            if (!(child instanceof Event)) continue;
            event = (Event)child;
        }
        return event;
    }

    private boolean useEventName(Event event) {
        Event.Type eventType = event.getSubType();
        return eventType == Event.Type.SIGNAL || eventType == Event.Type.TIMEOUT;
    }

    public TargetState getTargetState() {
        return this.getFirstChild(TargetState.class);
    }

    public SourceStateParent getSourceStateParent() {
        return this.getFirstChild(SourceStateParent.class);
    }

    public ParentState getParentState() {
        return this.getFirstChild(ParentState.class);
    }

    public ArrayList<State> getStates() {
        ArrayList<State> states = new ArrayList<State>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            UmlObject child = (UmlObject)this.getChild(i);
            if (!(child instanceof State)) continue;
            states.add((State)child);
            states.addAll(child.getStates());
        }
        return states;
    }
}

