/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.IOUmlObject;
import ch.e2e.builder.trace.testcase.uml.IterationUmlObject;
import ch.e2e.builder.trace.testcase.uml.UmlObjectWithDiagram;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Flow
extends IOUmlObject
implements UmlObjectWithDiagram,
IterationUmlObject {
    private int id = -1;
    private boolean generated;

    public Flow(String name) {
        super(name);
        this.setupGenerated();
    }

    public Flow(Element element, File documentFolder) {
        super(element, documentFolder);
        this.setupGenerated();
        if (element.hasAttribute("id")) {
            this.id = Integer.parseInt(element.getAttribute("id"));
        }
    }

    public Flow(Element element, TraceContainer traceContainer) {
        super(element, traceContainer);
        this.setupGenerated();
    }

    public Flow(Element element, TraceContainer traceContainer, boolean addToContainer) {
        super(element, traceContainer);
        this.setupGenerated();
        if (addToContainer) {
            this.removeContainerElements(element, traceContainer);
            traceContainer.addIterationElement(this, element);
            if (this.id > 0) {
                int i;
                ArrayList<Node> childsToRemove = new ArrayList<Node>();
                NodeList children = element.getChildNodes();
                int length = children.getLength();
                for (i = 0; i < length; ++i) {
                    Node child = children.item(i);
                    if (child.getNodeName().equals("input") || child.getNodeName().equals("output")) continue;
                    childsToRemove.add(child);
                }
                length = childsToRemove.size();
                for (i = 0; i < length; ++i) {
                    element.removeChild((Node)childsToRemove.get(i));
                }
            }
        }
    }

    protected void removeContainerElements(Element element, TraceContainer traceContainer) {
    }

    @Override
    public int internalGetType() {
        return 10001;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getOriginalName() {
        String result = this.id == -1 ? super.getOriginalName() : super.getOriginalName() + '_' + this.id;
        return result;
    }

    @Override
    public boolean isGenerated() {
        return this.generated;
    }

    private void setupGenerated() {
        this.generated = super.getOriginalName().contains("$GENERATED$");
    }

    @Override
    public boolean hasDiagram() {
        return true;
    }
}

