/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase;

import ch.e2e.builder.base.io.UniqueIdService;
import ch.e2e.builder.base.io.WrongIDFileVersionException;
import ch.e2e.builder.base.message.SendWarningEvent;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.AbstractTestcaseFolder;
import ch.e2e.builder.trace.testcase.SynchronousTestcaseTemplate;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.TestcaseRoot;
import ch.e2e.builder.trace.tools.TraceTools;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.FilesNotDeletedException;
import ch.e2e.io.ZipUtilities;
import ch.e2e.xuml.template.TemplateConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractWSDLFolder
extends TestcaseContainer {
    private File home;
    private File idFile;
    private Map<String, String> uniqueIds;
    private Map<String, AbstractTestcaseFolder> operation2folder = new HashMap<String, AbstractTestcaseFolder>();
    private String controlUrl;

    public AbstractWSDLFolder(String name, File home) {
        super(name, 2);
        this.home = home;
        this.idFile = new File(home, ".synchronous.id");
    }

    public AbstractWSDLFolder(String name, File home, File idFile) {
        super(name, 2);
        this.home = home;
        this.idFile = idFile;
        try {
            this.uniqueIds = UniqueIdService.loadUniqueIds((File)idFile);
        }
        catch (WrongIDFileVersionException e) {
            idFile.delete();
        }
        this.loadChildren(idFile);
    }

    public abstract AbstractTestcaseFolder createTestcaseFolder(SynchronousTestcaseTemplate var1, File var2);

    public abstract String getModuleName();

    public abstract String getMessageView();

    public File getHome() {
        return this.home;
    }

    public AbstractTestcaseFolder getTestcaseFolder(String qualifiedOperationName) {
        return this.operation2folder.get(qualifiedOperationName);
    }

    public String getControlUrl() {
        return this.controlUrl;
    }

    public void setControlUrl(String controlUrl) {
        this.controlUrl = controlUrl;
    }

    public void setTestcases(Document testcasesDocument, InputStream adapterTemplates, InputStream inspections, boolean merge) throws TransformerException, IOException {
        if (!this.home.exists() && !this.home.mkdirs()) {
            throw new IOException("Creation of directory '" + this.home + "' failed.");
        }
        if (adapterTemplates != null) {
            this.createAdapterTemplatesFile(adapterTemplates);
        }
        if (inspections != null) {
            this.createInspectionsFile(inspections);
        }
        ArrayList<TestcaseObject> oldServices = new ArrayList<TestcaseObject>(this.getChildren().values());
        ArrayList<TestcaseContainer> newServices = new ArrayList<TestcaseContainer>();
        NodeList testcases = testcasesDocument.getElementsByTagName("Testcase");
        ArrayList<String> templates = new ArrayList<String>();
        int length = testcases.getLength();
        for (int i = 0; i < length; ++i) {
            Element testcaseTemplate = (Element)testcases.item(i);
            this.testcaseTemplateSetControlUrl(testcaseTemplate, testcasesDocument);
            AbstractTestcaseFolder testcaseFolder = this.addTemplate(testcaseTemplate, merge);
            newServices.add(testcaseFolder.getParent().getParent());
            templates.add(testcaseFolder.getTemplate().getFullQualifiedName());
        }
        for (TestcaseObject oldService : oldServices) {
            if (newServices.contains(oldService)) continue;
            this.delete(oldService);
        }
        ArrayList<String> namesToBeRemoved = new ArrayList<String>();
        for (String name : this.uniqueIds.keySet()) {
            if (templates.contains(name)) continue;
            namesToBeRemoved.add(name);
        }
        for (String name : namesToBeRemoved) {
            FileUtilities.silentDeleteDirectory((File)new File(this.home, this.uniqueIds.get(name)));
            this.uniqueIds.remove(name);
            TestcaseObject o = this.find(name);
            if (o == null) continue;
            TestcaseContainer parent = o.getParent();
            parent.delete(o);
            if (parent.getChildCount() != 0) continue;
            parent.getParent().delete(parent);
        }
        UniqueIdService.saveIds(this.uniqueIds, (File)this.idFile);
    }

    private void createAdapterTemplatesFile(InputStream adapterTemplates) throws IOException {
        File templatesFile = new File(this.home, "adapter.templates.zip");
        FileUtilities.copy((InputStream)adapterTemplates, (OutputStream)new FileOutputStream(templatesFile));
        ZipFile templates = new ZipFile(templatesFile);
        try {
            Document document = ZipUtilities.getZippedDocumentFromFile((ZipFile)templates, (String)"adapter.template.ids");
            if (document != null && document.getDocumentElement().hasChildNodes()) {
                DomUtilities.serialize((File)new File(this.home, "adapter.template.ids"), (Document)document, (boolean)true);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        templates.close();
    }

    private void createInspectionsFile(InputStream inspections) throws IOException {
        FileUtilities.copy((InputStream)inspections, (OutputStream)new FileOutputStream(new File(this.home, "inspection.list")));
    }

    private void testcaseTemplateSetControlUrl(Element testcaseTemplate, Document testcasesDocument) {
        Element system = (Element)testcaseTemplate.getElementsByTagName("System").item(0);
        Element control = testcasesDocument.createElement("control");
        control.setTextContent(this.getControlUrl());
        system.appendChild(control);
    }

    public boolean rename(String newName) {
        boolean result;
        if (this.getParent().exists(newName)) {
            result = false;
        } else {
            TestcaseRoot parent = (TestcaseRoot)this.getParent();
            Map<String, String> ids = parent.getWSDLFolderIds();
            String newFolder = parent.findNewId(newName, ids);
            File newHome = new File(this.home.getParentFile(), newFolder);
            result = this.home.renameTo(newHome);
            if (result) {
                this.getParent().getChildren().remove(this.getName());
                ids.remove(this.getName());
                this.setName(newName);
                this.home = newHome;
                this.getParent().getChildren().put(newName, this);
                this.setIdFileHome(newHome);
                this.setChildrensHome(this, newHome);
                parent.saveWSDLFolderIds(ids);
            }
        }
        return result;
    }

    public List<AbstractSynchronousTestcase> createDefaultTestcases() throws IOException {
        ArrayList<AbstractSynchronousTestcase> result = new ArrayList<AbstractSynchronousTestcase>(this.operation2folder.size());
        for (AbstractTestcaseFolder testcaseFolder : this.operation2folder.values()) {
            String defaultTestcaseName;
            AbstractSynchronousTestcase testcase = (AbstractSynchronousTestcase)testcaseFolder.get(defaultTestcaseName = testcaseFolder.getTemplate().getOperation());
            if (testcase == null) {
                result.add(testcaseFolder.createDefaultTestcase());
                continue;
            }
            result.add(testcase);
        }
        return result;
    }

    private void setIdFileHome(File newHome) {
        this.idFile = new File(newHome, this.idFile.getName());
    }

    private void setChildrensHome(TestcaseContainer parent, File newHome) {
        for (TestcaseObject o : parent.getChildren().values()) {
            if (o instanceof AbstractTestcaseFolder) {
                AbstractTestcaseFolder folder = (AbstractTestcaseFolder)o;
                folder.setHome(newHome);
                continue;
            }
            if (!(o instanceof TestcaseContainer)) continue;
            this.setChildrensHome((TestcaseContainer)o, newHome);
        }
    }

    private AbstractTestcaseFolder addTemplate(Element testcaseTemplate, boolean merge) throws TransformerException, IOException {
        File templateFolder;
        SynchronousTestcaseTemplate template = new SynchronousTestcaseTemplate(testcaseTemplate);
        String name = template.getFullQualifiedName();
        String uniqueId = this.uniqueIds.get(name);
        if (uniqueId == null) {
            uniqueId = UniqueIdService.createUniqueId((String)name, (String)TraceTools.createPrefix(name), this.uniqueIds);
        }
        if (!(templateFolder = new File(this.home, uniqueId)).exists() && !templateFolder.mkdirs()) {
            throw new IOException("Creation of directory '" + templateFolder + "' failed.");
        }
        template.getRequestTemplate().getNamespacesManager().save(templateFolder);
        AbstractTestcaseFolder testcaseFolder = this.loadTemplateEntries(template, templateFolder);
        if (merge) {
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("testcasefolder", testcaseFolder.getName());
            boolean templateRPCEncoding = template.isRPCEncoding();
            boolean folderTemplateRpcEncoding = testcaseFolder.getTemplate().isRPCEncoding();
            if (templateRPCEncoding && !folderTemplateRpcEncoding) {
                EventController.fire((EventObject)new SendWarningEvent((Object)this, "wsdl.import.merge.warning.document2rpc.encoding", parameter, this.getModuleName(), this.getMessageView()));
                testcaseFolder.deleteTestCases();
            } else if (!templateRPCEncoding && folderTemplateRpcEncoding) {
                EventController.fire((EventObject)new SendWarningEvent((Object)this, "wsdl.import.merge.warning.rpc2document.encoding", parameter, this.getModuleName(), this.getMessageView()));
                testcaseFolder.deleteTestCases();
            }
            this.writeAndMark(testcaseTemplate, template, templateFolder, testcaseFolder);
            if (templateRPCEncoding || folderTemplateRpcEncoding) {
                testcaseFolder.mergeTestcases(template);
            }
        } else {
            this.writeAndMark(testcaseTemplate, template, templateFolder, testcaseFolder);
        }
        this.operation2folder.put(testcaseFolder.getQualifiedOperationName(), testcaseFolder);
        return testcaseFolder;
    }

    private void writeAndMark(Element testcaseTemplate, SynchronousTestcaseTemplate template, File templateFolder, AbstractTestcaseFolder testcaseFolder) throws IOException, TransformerException {
        String oldTemplate = this.fileToString(new File(templateFolder, "template.xml"));
        template.write(new File(templateFolder, "template.xml"), testcaseTemplate);
        String newTemplate = this.fileToString(new File(templateFolder, "template.xml"));
        this.markOutdated(oldTemplate, newTemplate, testcaseFolder);
    }

    private void markOutdated(String oldTemplate, String newTemplate, AbstractTestcaseFolder testcaseFolder) {
        boolean identical = false;
        if (oldTemplate != null) {
            Exception exception = null;
            try {
                identical = XMLUnit.compareXML((String)oldTemplate, (String)newTemplate).identical();
            }
            catch (SAXException e) {
                exception = e;
            }
            catch (IOException e) {
                exception = e;
            }
            if (exception != null) {
                logger.severe("Caught a " + exception.getClass().getName() + ": " + exception.getMessage());
                logger.throwing(this.getClass().getName(), "saveProperties", exception);
            }
        }
        if (!identical) {
            ArrayList<Testcase> testcases = testcaseFolder.getAllTestcases();
            for (Testcase testcase : testcases) {
                ((AbstractSynchronousTestcase)testcase).setOutdated(true);
            }
        }
    }

    private String fileToString(File file) {
        if (!file.canRead()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        IOException exception = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), TemplateConstants.UTF_8_CHARSET));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            exception = e;
        }
        if (exception != null) {
            logger.severe("Caught a " + exception.getClass().getName() + ": " + exception.getMessage());
            logger.throwing(this.getClass().getName(), "saveProperties", exception);
        }
        return sb.toString();
    }

    @Override
    protected void delete() throws FilesNotDeletedException {
        File[] dirs;
        ArrayList<File> undeletedFiles = new ArrayList<File>();
        for (int i = this.getChildCount() - 1; i > -1; --i) {
            try {
                this.delete((TestcaseObject)this.getChild(i));
                continue;
            }
            catch (FilesNotDeletedException e) {
                undeletedFiles.addAll(e.getFiles());
            }
        }
        for (String dirName : this.uniqueIds.values()) {
            File dir = new File(this.home, dirName);
            try {
                FileUtilities.deleteDirectory((File)dir);
            }
            catch (FilesNotDeletedException e) {
                undeletedFiles.addAll(e.getFiles());
            }
        }
        if (this.idFile.exists() && !this.idFile.delete()) {
            undeletedFiles.add(this.idFile);
        }
        if ((dirs = FileUtilities.getAllDirectories((File)this.home)).length == 0) {
            try {
                FileUtilities.deleteDirectory((File)this.home);
            }
            catch (FilesNotDeletedException e) {
                undeletedFiles.addAll(e.getFiles());
            }
        }
        if (!undeletedFiles.isEmpty()) {
            throw new FilesNotDeletedException(undeletedFiles);
        }
    }

    private void loadChildren(File idFile) {
        ArrayList<String> pathsToRemove = new ArrayList<String>();
        for (String path : this.uniqueIds.keySet()) {
            File folder = new File(this.home, this.uniqueIds.get(path));
            if (folder.exists()) {
                File templateFile = new File(folder, "template.xml");
                if (!templateFile.exists()) continue;
                this.loadTemplateEntries(new SynchronousTestcaseTemplate(templateFile), folder);
                continue;
            }
            pathsToRemove.add(path);
        }
        if (pathsToRemove.size() > 0) {
            for (String path : pathsToRemove) {
                this.uniqueIds.remove(path);
            }
            UniqueIdService.saveIds(this.uniqueIds, (File)idFile);
        }
    }

    public void reloadChildren(File idFile) throws FilesNotDeletedException {
        try {
            HashMap ids = UniqueIdService.loadUniqueIds((File)idFile);
            for (Map.Entry entry : ids.entrySet()) {
                File templateFile;
                File file;
                if (this.uniqueIds.containsKey(entry.getKey()) || !(file = new File(this.home, (String)entry.getValue())).exists() || !(templateFile = new File(file, "template.xml")).exists()) continue;
                this.loadTemplateEntries(new SynchronousTestcaseTemplate(templateFile), file);
                this.uniqueIds.put((String)entry.getKey(), (String)entry.getValue());
            }
            ArrayList toBeRemoved = new ArrayList();
            for (Map.Entry entry : this.uniqueIds.entrySet()) {
                if (ids.containsKey(entry.getKey())) continue;
                toBeRemoved.add(entry.getKey());
            }
            ArrayList undeletedFiles = new ArrayList();
            for (String s : toBeRemoved) {
                File dir = new File(this.home, this.uniqueIds.get(s));
                try {
                    FileUtilities.deleteDirectory((File)dir);
                }
                catch (FilesNotDeletedException e) {
                    undeletedFiles.addAll(e.getFiles());
                }
                this.uniqueIds.remove(s);
                TestcaseObject testcaseObject = this.find(s);
                if (testcaseObject == null) continue;
                try {
                    testcaseObject.getParent().delete(testcaseObject);
                }
                catch (FilesNotDeletedException e) {
                    undeletedFiles.addAll(e.getFiles());
                }
            }
            if (!undeletedFiles.isEmpty()) {
                throw new FilesNotDeletedException(undeletedFiles);
            }
        }
        catch (WrongIDFileVersionException wrongIDFileVersionException) {
            // empty catch block
        }
    }

    private AbstractTestcaseFolder loadTemplateEntries(SynchronousTestcaseTemplate template, File templateFolder) {
        TestcaseContainer service = this.getContainer(template.getService(), true, 3);
        TestcaseContainer porttype = service.getContainer(template.getPorttype(), true, 4);
        AbstractTestcaseFolder operation = (AbstractTestcaseFolder)porttype.get(template.getOperation());
        if (operation == null) {
            operation = this.createTestcaseFolder(template, templateFolder);
            porttype.add(operation);
            this.operation2folder.put(operation.getQualifiedOperationName(), operation);
        }
        return operation;
    }
}

