/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.request;

import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.builder.base.message.SendStatusEvent;
import ch.e2e.builder.trace.request.BearerTokenCredentials;
import ch.e2e.builder.trace.request.Logging;
import ch.e2e.builder.trace.request.RequestException;
import ch.e2e.builder.trace.request.ResponseException;
import ch.e2e.builder.trace.request.SOAPFault;
import ch.e2e.builder.trace.tools.SkipXmlPrologReader;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.io.LoggingReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Properties;
import java.util.stream.Stream;
import javax.swing.JFileChooser;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class RequestExecuter {
    public static final String HTTP_01 = "HTTP_01";
    public static final String HTTP_02 = "HTTP_02";
    public static final String HTTP_03 = "HTTP_03";
    public static final String HTTP_04 = "HTTP_04";
    public static final String HTTP_05 = "HTTP_05";
    public static final String HTTP_09 = "HTTP_09";
    private static final String CONTENT_TYPE = "Content-Type";
    public static final String APPLICATION_XML_CONTENT_TYPE = "application/xml";
    public static final String TEXT_XML_CONTENT_TYPE = "text/xml";
    public static final String SOAP_V11_CONTENT_TYPE = "text/xml";
    public static final String SOAP_V12_CONTENT_TYPE = "application/soap+xml";
    private static final String RECEIVED_UNHANDLED_CONTENT_TYPE = "Received unhandled content type '";
    private static final String RECEIVED_UNHANDLED_RESPONSE = "Received unhandled response '";
    private static final String UNKNOWN_ERROR = "UNKNOWN ERROR";
    private static final String ENCODING = "UTF-8";
    private static File debugFile;
    private static boolean chooseDebugFile;
    private PostMethod method;
    private final String[] acceptableResponseContentTypes;

    public RequestExecuter() {
        this("text/xml", SOAP_V12_CONTENT_TYPE);
    }

    public RequestExecuter(String ... acceptableResponseContentTypes) {
        this.acceptableResponseContentTypes = acceptableResponseContentTypes;
    }

    public Document execute(Document request, String location, int timeout) throws RequestException {
        return this.execute(request, location, timeout, null, null, null);
    }

    public Document execute(Document request, String location, Credentials credentials, int timeout) throws RequestException {
        return this.execute(request, location, credentials, timeout, null, null, null);
    }

    public Document execute(Document request, String location, int timeout, String requestId, Properties headerValues, String soapAction) throws RequestException {
        return this.execute(request, location, null, timeout, requestId, headerValues, soapAction);
    }

    public Document execute(Document request, String location, Credentials credentials, int timeout, String requestId, Properties headerValues, String soapAction) throws RequestException {
        Document result;
        if (debugFile == null && !chooseDebugFile) {
            try {
                result = this.doRequest(request, new URL(location), credentials, timeout, requestId, headerValues, soapAction);
            }
            catch (MalformedURLException e) {
                RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.connect.error", "request.transaction.error.dialog.subtitle.bad.request");
                throw new RequestException(location, HTTP_04, e, info);
            }
        } else {
            result = this.getDebugResponse();
        }
        return result;
    }

    public void releaseConnection() {
        if (this.method != null) {
            this.method.releaseConnection();
        }
    }

    protected final Document doRequest(Document request, URL url, Credentials credentials, int timeout, String requestId, Properties headerValues, String soapAction) throws RequestException {
        this.method = this.createMethod(url, requestId, headerValues, soapAction);
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        if (credentials instanceof UsernamePasswordCredentials) {
            AuthScope authScope = new AuthScope(url.getHost(), url.getPort(), AuthScope.ANY_REALM, "BASIC");
            client.getState().setCredentials(authScope, credentials);
        } else if (credentials instanceof BearerTokenCredentials) {
            this.method.setRequestHeader("Authorization", ((BearerTokenCredentials)credentials).requestAuthorizationValue());
        }
        client.getHttpConnectionManager().getParams().setSoTimeout(timeout * 1000);
        return this.doRequest(request, client, url);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Document doRequest(Document request, HttpClient client, URL url) throws RequestException {
        this.method.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(this.getSerializedRequest(request)));
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        replaceMap.put("url", url.toString());
        EventController.fire((EventObject)new SendStatusEvent((Object)this, "http.client.status.connecting", replaceMap));
        int code = this.executeMethod(client);
        String status = this.method.getStatusText();
        if (code > 199 && code < 204) {
            String type = this.method.getResponseHeader(CONTENT_TYPE).getValue();
            if (this.isValidResponseContentType(type)) {
                try {
                    return this.getResponse(new InputStreamReader(this.method.getResponseBodyAsStream(), ENCODING));
                }
                catch (IOException e) {
                    RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.response.processing.error", "request.transaction.error.dialog.subtitle.response.processing.error");
                    throw new RequestException(this.getUri(), HTTP_05, e, info);
                }
            }
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.response.processing.error", "request.transaction.error.dialog.subtitle.content.not.acceptable");
            throw new RequestException(url.toString(), HTTP_04, RECEIVED_UNHANDLED_CONTENT_TYPE + type + "'", info);
        }
        if (code == 401) {
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.request.processing.error", "request.transaction.error.dialog.subtitle.authentication.failed");
            throw new RequestException(url.toString(), HTTP_04, code + ": " + status, info);
        }
        if (code == 403) {
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.request.processing.error", "request.transaction.error.dialog.subtitle.authorization.failed");
            throw new RequestException(url.toString(), HTTP_04, code + ": " + status, info);
        }
        if (code == 404) {
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.connect.error", "request.transaction.error.dialog.subtitle.resource.not.found");
            throw new RequestException(url.toString(), HTTP_04, code + ": " + status, info);
        }
        if (code == 500) {
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.connect.error", "request.transaction.error.dialog.subtitle.connect.error");
            throw new RequestException(url.toString(), HTTP_05, code + ": " + status, info);
        }
        if (code > 203 && code < 306) {
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.unhandled.request", "request.transaction.error.dialog.subtitle.unhandled.request");
            throw new RequestException(url.toString(), HTTP_02, code + ": " + status, info);
        }
        if (code > 399 && code < 506) {
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.unhandled.request", "request.transaction.error.dialog.subtitle.unhandled.request");
            throw new RequestException(url.toString(), HTTP_03, code + ": " + status, info);
        }
        RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.unknown.error", "request.transaction.error.dialog.subtitle.unknown.error");
        throw new RequestException(url.toString(), HTTP_04, UNKNOWN_ERROR, info);
    }

    private int executeMethod(HttpClient client) throws RequestException {
        try {
            return client.executeMethod((HttpMethod)this.method);
        }
        catch (UnknownHostException e) {
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.connect.error", "request.transaction.error.dialog.subtitle.connect.error");
            throw new RequestException(this.getUri(), HTTP_04, e, info);
        }
        catch (ConnectException e) {
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.connect.error", "request.transaction.error.dialog.subtitle.connect.error");
            throw new RequestException(this.getUri(), HTTP_04, e, info);
        }
        catch (Exception e) {
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.connect.error", "request.transaction.error.dialog.subtitle.bad.request");
            throw new RequestException(this.getUri(), HTTP_04, e, info);
        }
    }

    private String getUri() {
        try {
            return this.method.getURI().toString();
        }
        catch (URIException e) {
            return "";
        }
    }

    protected PostMethod getMethod() {
        return this.method;
    }

    private Document getResponse(Reader responseReader) throws RequestException {
        File tempFile = null;
        Reader reader = null;
        Document result = null;
        try {
            tempFile = File.createTempFile("response_", ".log");
            tempFile.deleteOnExit();
            PrintWriter log = new PrintWriter(tempFile, "utf-8");
            if (this.getMethod() != null) {
                for (Header header : this.getMethod().getResponseHeaders()) {
                    log.println(header.getName() + ": " + header.getValue());
                }
            }
            log.println();
            reader = new LoggingReader(responseReader, (Writer)log);
            result = DomUtilities.parse((Reader)reader, (boolean)false, (boolean)false, (boolean)true);
        }
        catch (IOException e) {
            Logging.logger.throwing(this.getClass().getName(), "getResponse", e);
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.response.processing.error", "request.transaction.error.dialog.subtitle.response.processing.error");
            throw new RequestException(this.getUri(), HTTP_09, e, info);
        }
        catch (ParserConfigurationException e) {
            Logging.logger.throwing(this.getClass().getName(), "getResponse", e);
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.response.processing.error", "request.transaction.error.dialog.subtitle.parser.configuration.error");
            throw new RequestException(this.getUri(), HTTP_09, e, info);
        }
        catch (SAXException e) {
            Logging.logger.throwing(this.getClass().getName(), "getResponse", e);
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.response.processing.error", "request.transaction.error.dialog.subtitle.response.processing.error");
            throw new ResponseException(this.getUri(), HTTP_09, e, info, tempFile);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (result != null && tempFile != null) {
                tempFile.delete();
            }
        }
        return result;
    }

    private PostMethod createMethod(URL url, String requestId, Properties headerValues, String soapAction) {
        PostMethod method = new PostMethod(url.toExternalForm());
        method.setFollowRedirects(false);
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
        method.getParams().setVersion(HttpVersion.HTTP_1_1);
        method.getParams().setParameter("http.useragent", (Object)("SOAPTestTool/1.0 (" + System.getProperty("java.vm.name") + "/" + System.getProperty("java.vm.version") + ")"));
        RequestExecuter.prepareHeader(method, headerValues, soapAction, requestId);
        return method;
    }

    private static void prepareHeader(PostMethod method, Properties headerValues, String soapAction, String requestId) {
        if (headerValues != null) {
            Enumeration<Object> keys = headerValues.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                method.addRequestHeader(key, headerValues.getProperty(key));
            }
        }
        method.addRequestHeader("X-Bridge", "NoErrorReturn");
        if (requestId != null) {
            method.addRequestHeader("Request-ID", requestId);
        }
        method.getParams().setContentCharset("text/xml; charset=utf-8");
        if (soapAction != null) {
            method.addRequestHeader("SOAPAction", soapAction);
        }
    }

    private Document getDebugResponse() throws RequestException {
        if (chooseDebugFile) {
            JFileChooser fileChooser;
            if (debugFile == null) {
                fileChooser = new JFileChooser();
            } else {
                fileChooser = new JFileChooser(debugFile.getParentFile());
                fileChooser.setSelectedFile(debugFile);
            }
            fileChooser.showOpenDialog(null);
            debugFile = fileChooser.getSelectedFile();
        }
        try {
            return debugFile == null ? SOAPFault.createSOAPFaultNode("FILE_SYSTEM", "No debug file selected", null) : this.getResponse(new SkipXmlPrologReader(new FileReader(debugFile)));
        }
        catch (FileNotFoundException e) {
            throw new RequestException("", HTTP_09, e);
        }
    }

    private byte[] getSerializedRequest(Document request) {
        byte[] result = null;
        try {
            StringWriter writer = new StringWriter();
            StreamResult streamResult = new StreamResult(writer);
            DomUtilities.serialize((StreamResult)streamResult, (Document)request, (boolean)false);
            result = writer.toString().getBytes(ENCODING);
        }
        catch (Exception e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(HttpClient.class.getName(), "getSerializedRequest", e);
            EventController.fire((EventObject)new SendErrorEvent((Object)request, e.toString()));
        }
        return result;
    }

    private boolean isValidResponseContentType(String contentType) {
        return Stream.of(this.acceptableResponseContentTypes).anyMatch(contentType::startsWith);
    }

    static {
        String responseFile = System.getProperty("ch.e2e.builder.traceviewer.response.log");
        if (responseFile != null) {
            debugFile = new File(responseFile);
        }
        chooseDebugFile = Boolean.getBoolean("ch.e2e.builder.traceviewer.response.log.choose.file");
    }
}

