/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.io;

import ch.e2e.crypto.CryptographyFactory;
import ch.e2e.crypto.Encrypt;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ZipUtilities {
    private static final int DATA_BLOCK_SIZE = 2048;

    private ZipUtilities() {
    }

    public static void extract(File src, File directory) throws IOException {
        ZipUtilities.extract(src, directory, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(File src, File directory, List<String> excludedEntries) throws IOException {
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(src);
            Enumeration<? extends ZipEntry> entries = zipfile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (excludedEntries.contains(entry.getName())) continue;
                File out = new File(directory, entry.getName());
                if (entry.isDirectory()) {
                    out.mkdirs();
                    continue;
                }
                if (!out.getParentFile().exists()) {
                    out.getParentFile().mkdirs();
                }
                FileUtilities.copy(zipfile.getInputStream(entry), new FileOutputStream(out));
            }
        }
        finally {
            try {
                if (zipfile != null) {
                    zipfile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(File src, String path, boolean recursive, File to) throws IOException {
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(src);
            ZipUtilities.extract(zipfile, path, recursive, to, true);
        }
        finally {
            try {
                if (zipfile != null) {
                    zipfile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void extract(ZipFile zipfile, String path, boolean recursive, File to) throws IOException {
        ZipUtilities.extract(zipfile, path, recursive, to, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(ZipFile zipfile, String path, boolean recursive, File to, boolean close) throws IOException {
        try {
            path = path.replace('\\', '/');
            if (path.length() > 0 && !path.endsWith("/")) {
                path = path + '/';
            }
            Enumeration<? extends ZipEntry> entries = zipfile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().replace('\\', '/').startsWith(path) || !recursive && entry.getName().substring(path.length()).indexOf(47) == -1) continue;
                File out = new File(to, entry.getName());
                if (!out.getParentFile().exists()) {
                    out.getParentFile().mkdirs();
                }
                FileUtilities.copy(zipfile.getInputStream(entry), new FileOutputStream(out));
            }
        }
        finally {
            try {
                if (zipfile != null && close) {
                    zipfile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void extractEncrypted(ZipFile zipfile, String path, boolean recursive, File to) throws IOException {
        ZipUtilities.extractEncrypted(zipfile, path, recursive, to, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractEncrypted(ZipFile zipfile, String path, boolean recursive, File to, boolean close) throws IOException {
        try {
            if (path.length() > 0 && !path.endsWith("/")) {
                path = path + '/';
            }
            Enumeration<? extends ZipEntry> entries = zipfile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().startsWith(path) || !recursive && entry.getName().substring(path.length()).indexOf(47) == -1) continue;
                File out = new File(to, entry.getName());
                if (!out.getParentFile().exists()) {
                    out.getParentFile().mkdirs();
                }
                Encrypt encrypt = CryptographyFactory.getEncryption("e2ecrypt01");
                FileUtilities.copy(zipfile.getInputStream(entry), encrypt.getCipherOutputStream(out));
            }
        }
        finally {
            try {
                if (zipfile != null && close) {
                    zipfile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFromZip(File in, File out) throws IOException {
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(in);
            Enumeration<? extends ZipEntry> entries = zipfile.entries();
            if (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                FileUtilities.copy(zipfile.getInputStream(entry), new FileOutputStream(out));
            }
        }
        finally {
            try {
                if (zipfile != null) {
                    zipfile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFromZip(File in, File out, String entryName) throws IOException {
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(in);
            ZipEntry entry = zipfile.getEntry(entryName);
            if (entry == null) {
                throw new FileNotFoundException(entryName + " not found in " + in.getAbsolutePath());
            }
            FileUtilities.copy(zipfile.getInputStream(entry), new FileOutputStream(out));
        }
        finally {
            try {
                if (zipfile != null) {
                    zipfile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void copyToZip(File in, File out, String entryName) throws IOException {
        ZipUtilities.copyToZip(new FileInputStream(in), out, entryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToZip(InputStream in, File out, String entryName) throws IOException {
        ZipOutputStream zipfile = null;
        try {
            zipfile = new ZipOutputStream(new FileOutputStream(out));
            ZipEntry entry = new ZipEntry(entryName);
            zipfile.putNextEntry(entry);
            FileUtilities.copy(in, zipfile);
            try {
                zipfile.closeEntry();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            try {
                if (zipfile != null) {
                    zipfile.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static Document getZippedDocumentFromFile(String zipFilename) throws IOException, ParserConfigurationException, SAXException {
        return ZipUtilities.getZippedDocumentFromFile(zipFilename, false, false);
    }

    public static Document getZippedDocumentFromFile(String zipFilename, boolean validate, boolean schemaValidation) throws IOException, ParserConfigurationException, SAXException {
        return ZipUtilities.getZippedDocumentFromFile(new File(zipFilename), validate, schemaValidation);
    }

    public static Document getZippedDocumentFromFile(File file) throws IOException, ParserConfigurationException, SAXException {
        return ZipUtilities.getZippedDocumentFromFile(file, false, false);
    }

    public static Document getZippedDocumentFromFile(File file, boolean validate, boolean schemaValidation) throws IOException, ParserConfigurationException, SAXException {
        return ZipUtilities.getZippedDocumentFromFile(new ZipFile(file), validate, schemaValidation);
    }

    public static Document getZippedDocumentFromFile(File file, boolean validate, boolean schemaValidation, boolean namespaceAware) throws IOException, ParserConfigurationException, SAXException {
        return ZipUtilities.getZippedDocumentFromFile(new ZipFile(file), validate, schemaValidation, namespaceAware);
    }

    public static Document getZippedDocumentFromFile(ZipFile zipFile) throws IOException, ParserConfigurationException, SAXException {
        return ZipUtilities.getZippedDocumentFromFile(zipFile, false, false);
    }

    public static Document getZippedDocumentFromFile(ZipFile zipFile, boolean validate, boolean schemaValidation) throws IOException, ParserConfigurationException, SAXException {
        return ZipUtilities.getZippedDocumentFromFile(zipFile, validate, schemaValidation, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getZippedDocumentFromFile(ZipFile zipFile, boolean validate, boolean schemaValidation, boolean namespaceAware) throws IOException, ParserConfigurationException, SAXException {
        Document document = null;
        try {
            ZipEntry entry = zipFile.entries().nextElement();
            if (entry != null) {
                document = DomUtilities.parse(zipFile.getInputStream(entry), validate, schemaValidation, namespaceAware);
            }
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Exception exception) {}
        }
        return document;
    }

    public static Document getZippedDocumentFromFile(String zipFilename, String entryName) throws IOException, ParserConfigurationException, SAXException {
        return ZipUtilities.getZippedDocumentFromFile(zipFilename, entryName, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getZippedDocumentFromFile(String zipFilename, String entryName, boolean validate, boolean schemaValidation) throws IOException, ParserConfigurationException, SAXException {
        Document document = null;
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(zipFilename);
            ZipEntry entry = zipfile.getEntry(entryName);
            if (entry != null) {
                document = DomUtilities.parse(zipfile.getInputStream(entry), validate, schemaValidation);
            }
        }
        finally {
            try {
                if (zipfile != null) {
                    zipfile.close();
                }
            }
            catch (Exception exception) {}
        }
        return document;
    }

    public static Document getZippedDocumentFromFile(File file, String entryName) throws IOException, ParserConfigurationException, SAXException {
        return ZipUtilities.getZippedDocumentFromFile(file, entryName, false, false);
    }

    public static Document getZippedDocumentFromFile(File file, String entryName, boolean validate, boolean schemaValidation) throws IOException, ParserConfigurationException, SAXException {
        return ZipUtilities.getZippedDocumentFromFile(new ZipFile(file), entryName, validate, schemaValidation);
    }

    public static Document getZippedDocumentFromFile(ZipFile zipFile, String entryName) throws IOException, ParserConfigurationException, SAXException {
        return ZipUtilities.getZippedDocumentFromFile(zipFile, entryName, false, false);
    }

    public static Document getZippedDocumentFromFile(ZipFile zipFile, String entryName, boolean validate, boolean schemaValidation) throws IOException, ParserConfigurationException, SAXException {
        return ZipUtilities.getZippedDocumentFromFile(zipFile, entryName, validate, schemaValidation, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getZippedDocumentFromFile(ZipFile zipfile, String entryName, boolean validate, boolean schemaValidation, boolean close) throws IOException, ParserConfigurationException, SAXException {
        Document document = null;
        try {
            ZipEntry entry = zipfile.getEntry(entryName);
            if (entry != null) {
                document = DomUtilities.parse(zipfile.getInputStream(entry), validate, schemaValidation);
            }
        }
        finally {
            try {
                if (zipfile != null && close) {
                    zipfile.close();
                }
            }
            catch (Exception exception) {}
        }
        return document;
    }

    public static Document getZippedDocumentFromClasspath(String zipFilename) throws IOException, ParserConfigurationException, SAXException {
        return ZipUtilities.getZippedDocumentFromClasspath(zipFilename, ZipUtilities.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getZippedDocumentFromClasspath(String zipFilename, ClassLoader classLoader) throws IOException, ParserConfigurationException, SAXException {
        Document document = null;
        ZipInputStream zipInput = null;
        try {
            InputStream in = classLoader.getResourceAsStream(zipFilename);
            zipInput = new ZipInputStream(in);
            zipInput.getNextEntry();
            document = DomUtilities.parse(zipInput, false, false);
        }
        finally {
            try {
                if (zipInput != null) {
                    zipInput.close();
                }
            }
            catch (Exception exception) {}
        }
        return document;
    }

    public static Document getZippedDocumentFromClasspath(String zipFilename, String entryName) throws IOException, ParserConfigurationException, SAXException {
        return ZipUtilities.getZippedDocumentFromClasspath(zipFilename, entryName, ZipUtilities.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getZippedDocumentFromClasspath(String zipFilename, String entryName, ClassLoader classLoader) throws IOException, ParserConfigurationException, SAXException {
        Document document = null;
        ZipInputStream zipInput = null;
        try {
            ZipEntry nextEntry;
            zipInput = new ZipInputStream(classLoader.getResourceAsStream(zipFilename));
            while ((nextEntry = zipInput.getNextEntry()) != null && document == null) {
                if (!nextEntry.getName().equals(entryName)) continue;
                document = DomUtilities.parse(new InputStreamReader(zipInput), false, false);
            }
        }
        finally {
            try {
                if (zipInput != null) {
                    zipInput.close();
                }
            }
            catch (Exception exception) {}
        }
        return document;
    }

    public static ZipInputStream getZipStreamFromClasspath(String zipFilename) {
        return new ZipInputStream(ClassLoader.getSystemClassLoader().getResourceAsStream(zipFilename));
    }

    public static Object getZippedObjectFromClasspath(String zipFilename) throws IOException, ClassNotFoundException {
        ZipInputStream inputStream = ZipUtilities.getZipStreamFromClasspath(zipFilename);
        return ZipUtilities.getZippedObjectFromStream(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getZippedObjectFromStream(ZipInputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(inputStream);
            Object object = in.readObject();
            return object;
        }
        finally {
            try {
                inputStream.closeEntry();
            }
            catch (Exception exception) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static Object getZippedObjectFromClasspath(String zipFilename, String entryName) throws IOException, ClassNotFoundException {
        ZipInputStream inputStream = ZipUtilities.getZipStreamFromClasspath(zipFilename);
        return ZipUtilities.getZippedObjectFromStream(inputStream, entryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getZippedObjectFromStream(ZipInputStream inputStream, String entryName) throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        try {
            ZipEntry entry = inputStream.getNextEntry();
            Object result = null;
            while (entry != null) {
                if (entry.getName().equals(entryName)) {
                    in = new ObjectInputStream(inputStream);
                    Object object = result = in.readObject();
                    return object;
                }
                entry = inputStream.getNextEntry();
            }
            Object object = result;
            return object;
        }
        finally {
            try {
                inputStream.closeEntry();
            }
            catch (Exception exception) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static Object getZippedObject(String absolutePath) throws IOException, ClassNotFoundException {
        return ZipUtilities.getZippedObject(new File(absolutePath));
    }

    public static Object getZippedObject(File zipfile) throws IOException, ClassNotFoundException {
        ZipInputStream inputStream = new ZipInputStream(new FileInputStream(zipfile));
        return ZipUtilities.getZippedObjectFromStream(inputStream);
    }

    public static Object getZippedObject(String absolutePath, String entryName) throws IOException, ClassNotFoundException {
        return ZipUtilities.getZippedObject(new File(absolutePath), entryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getZippedObject(File zipfile, String entryName) throws IOException, ClassNotFoundException {
        ZipInputStream inputStream = null;
        try {
            inputStream = new ZipInputStream(new FileInputStream(zipfile));
            Object object = ZipUtilities.getZippedObjectFromStream(inputStream, entryName);
            return object;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void zipFileOrDir(String fileOrDir, String zipfile) throws FileNotFoundException {
        ZipUtilities.zipFileOrDir(fileOrDir, zipfile, true);
    }

    public static void zipFileOrDir(String fileOrDir, String zipfile, boolean closeZipFile) throws FileNotFoundException {
        ZipUtilities.zipFileOrDir(new File(fileOrDir), new File(zipfile), closeZipFile);
    }

    public static void zipFileOrDir(File fileOrDir, File zipfile) throws FileNotFoundException {
        ZipUtilities.zipFileOrDir(fileOrDir, zipfile, true);
    }

    public static void zipFileOrDir(File fileOrDir, File zipfile, boolean closeZipFile) throws FileNotFoundException {
        ZipUtilities.zipFileOrDir(fileOrDir, new ZipOutputStream(new FileOutputStream(zipfile)), closeZipFile);
    }

    public static void zipFileOrDir(File fileOrDir, ZipOutputStream zipStream) throws FileNotFoundException {
        ZipUtilities.zipFileOrDir(fileOrDir, zipStream, true);
    }

    public static void zipFileOrDir(File fileOrDir, ZipOutputStream zipStream, boolean closeZipStream) throws FileNotFoundException {
        ZipUtilities.zipFileOrDir(fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParentFile(), fileOrDir, zipStream, closeZipStream);
    }

    public static void zipFileOrDir(File baseDir, File fileOrDir, ZipOutputStream zipStream, boolean closeZipStream) throws FileNotFoundException {
        if (!baseDir.exists()) {
            throw new FileNotFoundException(baseDir.getPath());
        }
        if (!fileOrDir.exists()) {
            throw new FileNotFoundException(fileOrDir.getPath());
        }
        File[] files = fileOrDir.listFiles();
        if (files == null) {
            ZipUtilities.zipFile(baseDir, fileOrDir, zipStream);
        } else {
            for (File f : files) {
                ZipUtilities.zipFileOrDir(baseDir, f, zipStream, false);
            }
        }
        if (closeZipStream) {
            try {
                zipStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void zipFile(File baseDir, File file, ZipOutputStream zipStream) {
        ZipEntry zipEntry = new ZipEntry(FileUtilities.getRelativePath(file, baseDir));
        try {
            int nBytes;
            FileInputStream inputStream = new FileInputStream(file);
            byte[] bytes = new byte[2048];
            zipStream.putNextEntry(zipEntry);
            while ((nBytes = inputStream.read(bytes)) != -1) {
                zipStream.write(bytes, 0, nBytes);
            }
            zipStream.closeEntry();
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

