/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.net;

import ch.e2e.builder.compiler.net.ParallelRequestTest;
import ch.e2e.dom.DomUtilities;
import ch.e2e.dom.XPathFactory;
import ch.e2e.test.E2ETest;
import ch.e2e.test.options.FileOption;
import ch.e2e.test.options.IntegerOption;
import ch.e2e.test.options.Option;
import ch.e2e.test.options.StringOption;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import junit.extensions.ActiveTestSuite;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParallelRequestsTest
extends E2ETest {
    public static final String KEY_OPTION_HOST = "service.parallel.url.host";
    private static final String KEY_OPTION_LOG_DIR = "service.parallel.log.dir";
    private static final String KEY_OPTION_CONTROL_URL_PROTOCOL = "service.parallel.url.control.protocol";
    private static final String KEY_OPTION_SOAP_URL_PROTOCOL = "service.parallel.url.soap.protocol";
    private static final String KEY_OPTION_CONTROL_PORT = "service.parallel.url.control.port";
    private static final String KEY_OPTION_SOAP_PORT = "service.parallel.url.soap.port";
    private static final String KEY_OPTION_CONTROL_URL_PATH = "service.parallel.url.control.path";
    private static final String KEY_OPTION_SOAP_URL_PATH = "service.parallel.url.soap.path";
    private static final String KEY_OPTION_CONTROL_HEADER_FILE = "service.parallel.url.control.header";
    private static final String KEY_OPTION_SOAP_HEADER_FILE = "service.parallel.url.soap.header";
    private static final String KEY_OPTION_DEFINITION_FILE = "service.parallel.definition";
    private static final String KEY_OPTION_REQUESTS_DIR = "service.parallel.request.dir";
    private static final String KEY_OPTION_CONTROL_DIR = "service.parallel.control.dir";
    private TestSuite suite = null;
    private int testCount = 0;

    public void doTest() {
    }

    public void run(TestResult result) {
        result.addListener((TestListener)this);
        try {
            TestSuite suite = this.getTestSuite();
            suite.run(result);
        }
        catch (Exception e) {
            result.addError((Test)this, (Throwable)e);
        }
        result.removeListener((TestListener)this);
    }

    private TestSuite getTestSuite() throws Exception {
        if (this.suite == null) {
            this.suite = this.readDefinition((File)this.getOptionValue(KEY_OPTION_DEFINITION_FILE));
        }
        return this.suite;
    }

    public String getRecommendedCompareType() {
        return null;
    }

    public void readSources(NodeList sources, boolean inherited) {
        int length = sources.getLength();
        for (int i = 0; i < length; ++i) {
            IntegerOption option;
            Element source = (Element)sources.item(i);
            String name = source.getAttribute("name");
            String valueStr = source.getAttribute("value");
            switch (name) {
                case "service.parallel.url.control.port": 
                case "service.parallel.url.soap.port": {
                    option = this.initializeIntegerOption(name, valueStr);
                    break;
                }
                case "service.parallel.log.dir": 
                case "service.parallel.request.dir": 
                case "service.parallel.control.dir": 
                case "service.parallel.definition": {
                    option = this.initializeFileOption(name, valueStr);
                    break;
                }
                default: {
                    option = this.initializeStringOption(name, valueStr);
                }
            }
            if (option == null) continue;
            option.setInherited(inherited);
        }
    }

    private FileOption initializeFileOption(String optionKey, String valueStr) {
        FileOption fileOption = (FileOption)this.getOption(optionKey);
        File value = fileOption.createValue(valueStr);
        fileOption.setValue((Object)value);
        return fileOption;
    }

    private StringOption initializeStringOption(String optionKey, String valueStr) {
        StringOption stringOption = (StringOption)this.getOption(optionKey);
        String value = stringOption.createValue(valueStr);
        stringOption.setValue((Object)value);
        return stringOption;
    }

    private IntegerOption initializeIntegerOption(String optionKey, String valueStr) {
        IntegerOption portOption = (IntegerOption)this.getOption(optionKey);
        Integer value = portOption.createValue(valueStr);
        portOption.setValue((Object)value);
        return portOption;
    }

    protected void createOptions() {
        int i = 0;
        StringOption host = new StringOption("Host", KEY_OPTION_HOST, ++i);
        host.setRequired(true);
        this.addOption(KEY_OPTION_HOST, (Option)host);
        StringOption controlProtocol = new StringOption("Control URL Protocol", KEY_OPTION_CONTROL_URL_PROTOCOL, "http", ++i);
        this.addOption(KEY_OPTION_CONTROL_URL_PROTOCOL, (Option)controlProtocol);
        IntegerOption controlPort = new IntegerOption("Control Port", KEY_OPTION_CONTROL_PORT, ++i);
        controlPort.setMaxValue(99999);
        controlPort.setMinValue(1);
        controlPort.setRequired(true);
        this.addOption(KEY_OPTION_CONTROL_PORT, (Option)controlPort);
        StringOption controlUrlPath = new StringOption("Control URL Path", KEY_OPTION_CONTROL_URL_PATH, ++i);
        controlUrlPath.setRequired(false);
        this.addOption(KEY_OPTION_CONTROL_URL_PATH, (Option)controlUrlPath);
        FileOption controlHeaderFile = new FileOption("Control HTTP Header File", KEY_OPTION_CONTROL_HEADER_FILE, ++i);
        this.addOption(KEY_OPTION_CONTROL_HEADER_FILE, (Option)controlHeaderFile);
        StringOption soapProtocol = new StringOption("SOAP URL Protocol", KEY_OPTION_SOAP_URL_PROTOCOL, "http", ++i);
        this.addOption(KEY_OPTION_SOAP_URL_PROTOCOL, (Option)soapProtocol);
        IntegerOption soapPort = new IntegerOption("SOAP Port", KEY_OPTION_SOAP_PORT, ++i);
        soapPort.setMaxValue(99999);
        soapPort.setMinValue(1);
        soapPort.setRequired(true);
        this.addOption(KEY_OPTION_SOAP_PORT, (Option)soapPort);
        StringOption soapUrlPath = new StringOption("SOAP URL Path", KEY_OPTION_SOAP_URL_PATH, ++i);
        soapUrlPath.setRequired(false);
        this.addOption(KEY_OPTION_SOAP_URL_PATH, (Option)soapUrlPath);
        FileOption soapHeaderFile = new FileOption("SOAP HTTP Header File", KEY_OPTION_SOAP_HEADER_FILE, ++i);
        this.addOption(KEY_OPTION_SOAP_HEADER_FILE, (Option)soapHeaderFile);
        FileOption requestFile = new FileOption("Threads Definition File", KEY_OPTION_DEFINITION_FILE, new File("${source.folder}\\ThreadDefinition.xml"), ++i);
        requestFile.setRequired(true);
        requestFile.addFileExtension("xml", "Threads Definition (*.xml)");
        this.addOption(KEY_OPTION_DEFINITION_FILE, (Option)requestFile);
        FileOption requestsDirectory = new FileOption("Request files", KEY_OPTION_REQUESTS_DIR, new File("${source.folder}"), ++i);
        requestsDirectory.setRequired(true);
        requestsDirectory.setDirectory(true);
        this.addOption(KEY_OPTION_REQUESTS_DIR, (Option)requestsDirectory);
        FileOption controlDirectory = new FileOption("Control files", KEY_OPTION_CONTROL_DIR, new File("${reference.folder}"), ++i);
        controlDirectory.setRequired(true);
        controlDirectory.setDirectory(true);
        this.addOption(KEY_OPTION_CONTROL_DIR, (Option)controlDirectory);
        FileOption logDir = new FileOption("Log Directory", KEY_OPTION_LOG_DIR, new File("${library.output.folder}"), ++i);
        logDir.setRequired(true);
        logDir.setDirectory(true);
        this.addOption(KEY_OPTION_LOG_DIR, (Option)logDir);
    }

    private ActiveTestSuite readDefinition(File definitionFile) throws Exception {
        ActiveTestSuite suite = new ActiveTestSuite("ParallelRequests");
        if (definitionFile == null || !definitionFile.exists()) {
            throw new Exception("ParallelRequests configuration problem: File is missing: " + definitionFile);
        }
        try {
            NodeList threadsNodeList;
            Document definitionXML = DomUtilities.parse((File)definitionFile, (boolean)false, (boolean)false, (boolean)false);
            ArrayList<String> ignoredElements = new ArrayList<String>();
            ArrayList<String> ignoredAttributes = new ArrayList<String>();
            XPathFactory xpathFactory = XPathFactory.getInstance();
            XPath xpath = xpathFactory.newXPath();
            NodeList optionNodeList = (NodeList)xpath.evaluate("threadsDefinition/options", definitionXML, XPathConstants.NODESET);
            if (optionNodeList.getLength() == 1) {
                NodeList optionNodes = optionNodeList.item(0).getChildNodes();
                for (int i = 0; i < optionNodes.getLength(); ++i) {
                    Node optionNode = optionNodes.item(i);
                    if ("ignoreElement".equalsIgnoreCase(optionNode.getNodeName())) {
                        ignoredElements.add(optionNode.getAttributes().getNamedItem("value").getNodeValue());
                        continue;
                    }
                    if (!"ignoreAttribute".equalsIgnoreCase(optionNode.getNodeName())) continue;
                    ignoredAttributes.add(optionNode.getAttributes().getNamedItem("value").getNodeValue());
                }
            }
            if ((threadsNodeList = (NodeList)xpath.evaluate("threadsDefinition/threads", definitionXML, XPathConstants.NODESET)).getLength() == 1) {
                this.readThreads(suite, threadsNodeList.item(0), ignoredAttributes, ignoredElements);
            }
        }
        catch (Exception ex) {
            throw new Exception("ParallelRequests configuration problem with file " + definitionFile + ": " + ex.getMessage());
        }
        return suite;
    }

    private void readThreads(ActiveTestSuite currentSuite, Node node, Collection<String> ignoredAttributes, Collection<String> ignoredElements) {
        NodeList threadNodes = node.getChildNodes();
        for (int i = 0; i < threadNodes.getLength(); ++i) {
            Node threadNode = threadNodes.item(i);
            if (!"thread".equals(threadNode.getNodeName())) continue;
            TestSuite testSuite = new TestSuite();
            currentSuite.addTest((Test)testSuite);
            this.readThread(testSuite, threadNode, ignoredAttributes, ignoredElements);
        }
    }

    private void readThread(TestSuite threadSuite, Node threadNode, Collection<String> ignoredAttributes, Collection<String> ignoredElements) {
        NodeList testNodes = threadNode.getChildNodes();
        for (int i = 0; i < testNodes.getLength(); ++i) {
            Node node = testNodes.item(i);
            if (node.getNodeName().equals("threads")) {
                ActiveTestSuite activeTestSuite = new ActiveTestSuite();
                threadSuite.addTest((Test)activeTestSuite);
                this.readThreads(activeTestSuite, node, ignoredAttributes, ignoredElements);
                continue;
            }
            if (!node.getNodeName().equals("test")) continue;
            this.readTest(threadSuite, node, ignoredAttributes, ignoredElements);
        }
    }

    private void readTest(TestSuite threadSuite, Node testNode, Collection<String> ignoredAttributes, Collection<String> ignoredElements) {
        String urlType;
        String protocol = "http";
        Integer port = 0;
        String path = "";
        File header = null;
        NamedNodeMap attributes = testNode.getAttributes();
        Node methodNode = attributes.getNamedItem("method");
        String method = "POST";
        if (methodNode != null) {
            method = methodNode.getNodeValue();
        }
        String requestName = attributes.getNamedItem("name").getNodeValue();
        switch (urlType = attributes.getNamedItem("url").getNodeValue()) {
            case "soap": {
                protocol = (String)this.getOptionValue(KEY_OPTION_SOAP_URL_PROTOCOL);
                port = (Integer)this.getOptionValue(KEY_OPTION_SOAP_PORT);
                path = (String)this.getOptionValue(KEY_OPTION_SOAP_URL_PATH);
                header = (File)this.getOptionValue(KEY_OPTION_SOAP_HEADER_FILE);
                break;
            }
            case "control": {
                protocol = (String)this.getOptionValue(KEY_OPTION_CONTROL_URL_PROTOCOL);
                port = (Integer)this.getOptionValue(KEY_OPTION_CONTROL_PORT);
                path = (String)this.getOptionValue(KEY_OPTION_CONTROL_URL_PATH);
                header = (File)this.getOptionValue(KEY_OPTION_CONTROL_HEADER_FILE);
                break;
            }
            default: {
                ParallelRequestsTest.fail((String)("Attribute url of <thread><test> must be \"soap\" or \"control\" but is \"" + urlType + "\"."));
            }
        }
        Node pathNode = attributes.getNamedItem("path");
        if (pathNode != null) {
            path = pathNode.getNodeValue();
        }
        ParallelRequestTest test = new ParallelRequestTest(requestName, method, protocol, (String)this.getOptionValue(KEY_OPTION_HOST), port, path, requestName + ".xml", (File)this.getOptionValue(KEY_OPTION_REQUESTS_DIR), (File)this.getOptionValue(KEY_OPTION_CONTROL_DIR), (File)this.getOptionValue(KEY_OPTION_LOG_DIR), ignoredAttributes, ignoredElements, header);
        Node variableNode = attributes.getNamedItem("variable");
        if (variableNode != null) {
            test.setVariable(variableNode.getNodeValue());
            Node xpathNode = attributes.getNamedItem("xpath");
            if (xpathNode != null) {
                test.setVariableXPath(xpathNode.getNodeValue());
            }
        }
        threadSuite.addTest((Test)test);
    }

    public int countTestCases() {
        if (this.testCount == 0) {
            File definitionFile = new File(this.dirPath(), this.fileName());
            try {
                this.testCount = this.readDefinition(definitionFile).countTestCases();
            }
            catch (Exception e) {
                this.testCount = 1;
            }
        }
        return this.testCount;
    }

    private String dirPath() {
        Map properties = this.getOwner().getParent().getProperties();
        return (String)properties.get("source.folder");
    }

    private String fileName() {
        FileOption fileOption = (FileOption)this.getOptions().get(KEY_OPTION_DEFINITION_FILE);
        String absolutePath = ((File)fileOption.getValue()).getAbsolutePath();
        String pattern = Pattern.quote(File.separator);
        String[] split = absolutePath.split(pattern);
        return split[split.length - 1];
    }
}

