import {Injectable} from '@angular/core';
import {
    ActivatedRoute,
    ActivatedRouteSnapshot,
    CanActivate,
    Router,
    RouterStateSnapshot,
    UrlTree
} from '@angular/router';
import {NotificationService} from "@pas/app-core";
import {InstanceMetadata} from "@pas/xuml-communication";

@Injectable({
    providedIn: 'root'
})
export class SelectTaskGuard implements CanActivate {

    constructor(
        private router: Router,
        private route:  ActivatedRoute,
        private notification: NotificationService
    ) {
        this.router.onSameUrlNavigation = 'reload';
    }

    async canActivate(
        routeSnapshot: ActivatedRouteSnapshot,
        state: RouterStateSnapshot): Promise<boolean|UrlTree> {

        const processName = routeSnapshot.data.processName;
        const instanceId = routeSnapshot.params.instanceId;
        const instance: InstanceMetadata = routeSnapshot.data.instance.value;

        try {
            if (instance._meta.currentTasks.length < 2) {
                return this.router.navigate([processName, instanceId], {
                    relativeTo: this.route,
                    replaceUrl: true
                });
            }

        } catch (error) {
            this.notification.sendError(error.message);
            return this.router.navigate([processName], {
                relativeTo: this.route,
                replaceUrl: true
            });
        }

        return true;
    }

}