/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration.types.input;

import ch.e2e.ant.gui.configuration.types.input.InputElement;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.resource.ImageLoader;
import ch.e2e.swing.InputRadioButton;
import javax.swing.AbstractButton;
import javax.swing.JComponent;

public class RadioButton
extends InputElement
implements InputFieldListener {
    private AbstractButton radioButton;
    private String group;
    private String label;
    private boolean updateSelection = false;
    private String icon;
    private boolean selected;
    private String value = "true";

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void updateIcon(String icon) {
        if (this.icon == null || !this.icon.equals(icon)) {
            this.icon = icon;
            this.radioButton.setIcon(ImageLoader.loadIcon((String)icon, (boolean)false));
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void updateLabel(String label) {
        if (!this.label.equals(label)) {
            this.label = label;
            this.radioButton.setText(label);
        }
    }

    public void setUpdateSelection(boolean updateSelection) {
        this.updateSelection = updateSelection;
    }

    public void updateSelected(boolean selected) {
        if (this.updateSelection && this.selected ^ selected) {
            this.selected = selected;
            this.radioButton.setSelected(selected);
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public JComponent getGuiElement() {
        if (this.radioButton == null) {
            this.radioButton = new InputRadioButton(this.label, this.selected);
            if (this.icon != null) {
                this.radioButton.setIcon(ImageLoader.loadIcon((String)this.icon, (boolean)false));
            }
            ((InputRadioButton)this.radioButton).addInputFieldListener((InputFieldListener)this);
            this.radioButton.setActionCommand(this.getName());
        }
        return this.radioButton;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void updateValue(String value) {
        if (!value.equals(this.value)) {
            this.value = value;
        }
    }

    @Override
    public String getValue() {
        return this.radioButton.isSelected() ? this.value : null;
    }

    @Override
    public boolean isEnabled() {
        return this.radioButton.isEnabled();
    }

    @Override
    public void requestFocus() {
        this.radioButton.requestFocus();
    }

    public void inputFieldChanged(InputFieldEvent event) {
        this.fireInputFieldChanged(this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.radioButton.setEnabled(enabled);
    }
}

