/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration.types;

import ch.e2e.ant.gui.AntConsole;
import ch.e2e.ant.gui.configuration.ConfigurationParseException;
import ch.e2e.ant.gui.configuration.ConfigurationTools;
import ch.e2e.ant.gui.configuration.types.AntTarget;
import ch.e2e.ant.gui.configuration.types.Antcall;
import ch.e2e.ant.gui.configuration.types.TestFile;
import ch.e2e.dom.DomUtilities;
import ch.e2e.resource.Properties;
import ch.e2e.test.TestLogfile;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Test
extends Antcall {
    private String file;
    private File dir;
    private String name;
    private ArrayList<TestFile> testFiles = new ArrayList();
    private TestLogfile logfile;

    @Override
    public boolean hasExecutableTarget(Properties properties) {
        boolean result;
        if (this.file == null) {
            ArrayList<TestFile> executableFiles = new ArrayList<TestFile>();
            for (TestFile testFile : this.testFiles) {
                if (!ConfigurationTools.checkIfUnless(testFile.getIf(), testFile.getUnless(), properties)) continue;
                executableFiles.add(testFile);
            }
            result = executableFiles.size() > 0;
        } else {
            result = true;
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public TestLogfile createLogfile() {
        this.logfile = new TestLogfile();
        return this.logfile;
    }

    @Override
    public Antcall clone(Properties properties) {
        Test result = new Test();
        if (this.name != null) {
            result.setName(StringTools.replaceProperties((String)this.name, (Map)properties));
        }
        if (this.file != null) {
            result.setFile(StringTools.replaceProperties((String)this.file, (Map)properties));
        }
        if (this.dir != null) {
            result.setDir(new File(StringTools.replaceProperties((String)this.dir.getAbsolutePath(), (Map)properties)));
        }
        ArrayList<TestFile> clonedTestfiles = new ArrayList<TestFile>();
        for (TestFile testFile : this.testFiles) {
            clonedTestfiles.add(testFile.clone(properties));
        }
        result.setTestFiles(clonedTestfiles);
        if (this.logfile != null) {
            result.logfile = this.logfile.clone(properties);
        }
        return result;
    }

    @Override
    public void setBasedir(File basedir) {
        throw new ConfigurationParseException("It is not allowed to set the basedir of a test element");
    }

    @Override
    public void setAntfile(String antfile) {
        throw new ConfigurationParseException("It is not allowed to set the antfile of a test element");
    }

    @Override
    public void setTarget(String target) {
        throw new ConfigurationParseException("It is not allowed to add target elements to a test element");
    }

    @Override
    public void addTarget(AntTarget target) {
        throw new ConfigurationParseException("It is not allowed to add target elements to a test element");
    }

    @Override
    public void execute(AntConsole antConsole, Properties properties) throws IOException, TransformerException {
        if (this.file == null && this.testFiles.size() == 0) {
            throw new ConfigurationParseException("The attribute file of the test element have to be set or a file element must be added.");
        }
        if (this.file == null) {
            File testFile = this.createTestcaseFile(properties);
            this.execute(testFile, antConsole, properties);
            testFile.delete();
        } else {
            File testFile = this.dir == null ? new File(this.file) : new File(this.dir, this.file);
            this.execute(testFile, antConsole, properties);
        }
    }

    private void execute(File testFile, AntConsole antConsole, Properties properties) throws IOException, TransformerException {
        System.getProperties().putAll((Map<?, ?>)properties);
        super.setAntfile(this.createAntfile(testFile).getAbsolutePath());
        super.setBasedir(this.dir == null ? testFile.getParentFile() : this.dir);
        super.execute(antConsole, properties);
        for (Object key : properties.keySet()) {
            System.getProperties().remove(key);
        }
    }

    public void addInclude(TestFile testFile) {
        this.testFiles.add(testFile);
    }

    private void setTestFiles(ArrayList<TestFile> testFiles) {
        this.testFiles = testFiles;
    }

    private File createAntfile(File testfile) throws IOException, TransformerException {
        File buildFile = File.createTempFile("build", ".xml");
        Document document = DomUtilities.newDocument((String)"project");
        Element root = document.getDocumentElement();
        root.setAttribute("name", "e2etest");
        root.setAttribute("default", "do.test");
        Element target = document.createElement("target");
        target.setAttribute("name", "do.test");
        Element testunit = document.createElement("testunit");
        Element testsuite = document.createElement("testsuite");
        testsuite.setAttribute("testcases", testfile.getAbsolutePath());
        testsuite.setAttribute("name", this.name);
        if (this.logfile != null) {
            testsuite.appendChild(this.logfile.toXML(document));
        }
        testunit.appendChild(testsuite);
        target.appendChild(testunit);
        root.appendChild(target);
        DomUtilities.serialize((File)buildFile, (Document)document, (boolean)true);
        return buildFile;
    }

    public File createTestcaseFile(Properties properties) throws IOException, TransformerException {
        Document testcaseDocument = DomUtilities.newDocument((String)"testcases");
        for (TestFile testFile : this.testFiles) {
            if (!ConfigurationTools.checkIfUnless(testFile.getIf(), testFile.getUnless(), properties)) continue;
            File file = this.dir == null ? new File(testFile.getFile()) : new File(this.dir, testFile.getFile());
            Element includeElement = testcaseDocument.createElement("include");
            includeElement.setAttribute("file", file.getAbsolutePath());
            testcaseDocument.getDocumentElement().appendChild(includeElement);
        }
        File testcaseFile = File.createTempFile("testcases", ".xml");
        DomUtilities.serialize((File)testcaseFile, (Document)testcaseDocument, (boolean)true);
        return testcaseFile;
    }
}

